/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;

public class Box
extends Feature
implements Node {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int outlineWidthX;
    protected int outlineWidthY;
    protected Color outlineColor;
    protected Color fillColor;
    protected InterpolatedModel scalingModel = null;
    protected Rectangle scaledBounds = null;
    private boolean isActivated;
    private DrawRecord drawRecord = new DrawRecord();
    private boolean boxPropertiesChanged = false;

    public Box(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.isActivated) {
            throw new IllegalStateException();
        }
        Box result = new Box(this.show);
        result.x = this.x;
        result.y = this.y;
        result.width = this.width;
        result.height = this.height;
        result.outlineWidthX = this.outlineWidthX;
        result.outlineWidthY = this.outlineWidthY;
        result.outlineColor = this.outlineColor;
        result.fillColor = this.fillColor;
        if (this.scaledBounds != null) {
            result.scaledBounds = new Rectangle(this.scaledBounds);
        }
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        Box other = (Box)original;
        this.scalingModel = (InterpolatedModel)Feature.clonedReference(other.scalingModel, clones);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void resize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.boxPropertiesChanged = true;
    }

    public void resizeOutline(int outlineWidthX, int outlineWidthY) {
        this.outlineWidthX = outlineWidthX;
        this.outlineWidthY = outlineWidthY;
        this.boxPropertiesChanged = true;
    }

    public void changeBoxColor(Color c2) {
        this.fillColor = c2;
        this.boxPropertiesChanged = true;
    }

    public void changeBoxOutlineColor(Color c2) {
        this.outlineColor = c2;
        this.boxPropertiesChanged = true;
    }

    public void initialize() {
    }

    public void destroy() {
    }

    protected void setActivateMode(boolean mode) {
        this.isActivated = mode;
    }

    protected int setSetupMode(boolean mode) {
        return 0;
    }

    public boolean needsMoreSetup() {
        return false;
    }

    public void nextFrame() {
    }

    public void markDisplayAreasChanged() {
        this.drawRecord.setChanged();
    }

    public void addDisplayAreas(RenderContext context) {
        if (this.scalingModel == null) {
            this.drawRecord.setArea(this.x, this.y, this.width, this.height);
        } else {
            boolean changed = this.scalingModel.scaleBounds(this.x, this.y, this.width, this.height, this.scaledBounds);
            this.drawRecord.setArea(this.scaledBounds.x, this.scaledBounds.y, this.scaledBounds.width, this.scaledBounds.height);
            if (changed) {
                this.drawRecord.setChanged();
            }
        }
        if (this.boxPropertiesChanged) {
            this.drawRecord.setChanged();
            this.boxPropertiesChanged = false;
        }
        this.drawRecord.setSemiTransparent();
        context.addArea(this.drawRecord);
    }

    public void paintFrame(Graphics2D gr) {
        int h;
        int w;
        int y1;
        int x1;
        if (!this.isActivated) {
            return;
        }
        if (this.scalingModel == null) {
            x1 = this.x;
            y1 = this.y;
            w = this.width;
            h = this.height;
        } else {
            x1 = this.scaledBounds.x;
            y1 = this.scaledBounds.y;
            w = this.scaledBounds.width;
            if (w < 0) {
                w = -w;
                x1 -= w;
            }
            if ((h = this.scaledBounds.height) < 0) {
                h = -h;
                y1 -= h;
            }
        }
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        if ((this.outlineWidthX > 0 || this.outlineWidthY > 0) && this.outlineColor != null) {
            gr.setColor(this.outlineColor);
            int tx = this.outlineWidthX;
            int t2x = 2 * tx;
            int ty = this.outlineWidthY;
            int t2y = 2 * ty;
            gr.fillArc(x1, y1, t2x, t2y, 90, 90);
            gr.fillArc(x1, y2 - t2y, t2x, t2y, 180, 90);
            gr.fillArc(x2 - t2x, y2 - t2y, t2x, t2y, 270, 90);
            gr.fillArc(x2 - t2x, y1, t2x, t2y, 0, 90);
            gr.fillRect(x1, y1 + ty, tx, h - t2y - 1);
            gr.fillRect(x1 + tx, y2 - ty + 1, w - t2x - 1, ty);
            gr.fillRect(x2 - tx + 1, y1 + ty, tx, h - t2y - 1);
            gr.fillRect(x1 + tx, y1, w - t2x - 1, ty);
            x1 += tx;
            y1 += ty;
            w -= t2x;
            h -= t2y;
        }
        if (this.fillColor != null) {
            gr.setColor(this.fillColor);
            gr.fillRect(x1, y1, w, h);
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.x = in.readInt();
        this.y = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.outlineWidthX = in.readInt();
        this.outlineWidthY = in.readInt();
        this.outlineColor = in.readColor();
        this.fillColor = in.readColor();
        if (in.readBoolean()) {
            this.scalingModel = (InterpolatedModel)in.readFeatureReference();
            this.scaledBounds = new Rectangle();
        }
    }
}

