/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin;

import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Point;
import java.io.IOException;

public class GrinXHelper
extends Command
implements Node {
    protected int commandNumber;
    protected Command[] subCommands;
    protected static final int SYNC_DISPLAY = 0;
    protected static final int SEGMENT_DONE = 1;
    static final int FEATURE_SETUP = 2;
    protected static final int COMMAND_LIST = 3;
    public static final int MOUSE_MOVE = 4;
    public static final int MOUSE_CLICK = 5;
    private Object data = null;

    public GrinXHelper(Show show) {
        super(show);
    }

    public void setCommandNumber(int commandNumber) {
        this.commandNumber = commandNumber;
    }

    public void setCommandObject(Object object) {
        this.data = object;
    }

    public void setSubCommands(Command[] subCommands) {
        this.subCommands = subCommands;
    }

    protected void runSubCommand(int num, Show caller) {
        this.subCommands[num].execute(caller);
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.commandNumber = in.readInt();
        this.subCommands = in.readCommands();
    }

    public void execute(Show caller) {
        switch (this.commandNumber) {
            case 0: {
                this.show.deferNextCommands();
                break;
            }
            case 1: {
                this.show.doSegmentDone();
                break;
            }
            case 2: {
                Segment s = this.show.getCurrentSegment();
                if (s == null) break;
                s.runFeatureSetup();
                break;
            }
            case 3: {
                for (int i = 0; i < this.subCommands.length; ++i) {
                    this.subCommands[i].execute(caller);
                }
                break;
            }
            case 4: {
                Point p = (Point)this.data;
                this.show.handleMouseMoved(p.x, p.y);
                break;
            }
            case 5: {
                Point p = (Point)this.data;
                this.show.handleMouseClicked(p.x, p.y);
                break;
            }
            default: {
                Debug.assertFail();
            }
        }
    }

    public void execute() {
        Debug.assertFail();
    }

    public Node getInstanceOf(Show show, int id) throws IOException {
        throw new IOException();
    }

    public String toString() {
        return super.toString() + "(" + this.commandNumber + ")";
    }
}

