/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.SetupClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class SetupManager
implements Runnable {
    private SetupClient[] settingUp;
    int first;
    int lastPlusOne;
    private static Object monitor = new Object();
    private static SetupManager worker = null;
    private ArrayList managers;
    private static byte[] profileSetup;

    public SetupManager(int numFeatures) {
        this.managers = null;
        this.settingUp = new SetupClient[numFeatures + 1];
        this.first = 0;
        this.lastPlusOne = 0;
    }

    private SetupManager() {
        this.managers = new ArrayList(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = monitor;
        synchronized (object) {
            if (worker == null) {
                worker = new SetupManager();
                Thread t = new Thread((Runnable)worker, "SetupManager");
                t.setDaemon(true);
                t.setPriority(3);
                t.start();
            }
            if (SetupManager.worker.managers.indexOf(this) != -1) {
                Debug.assertFail();
            }
            SetupManager.worker.managers.add(this);
            monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = monitor;
        synchronized (object) {
            int i = SetupManager.worker.managers.indexOf(this);
            if (i < 0) {
                Debug.assertFail();
            }
            if (i >= 0) {
                SetupManager.worker.managers.remove(i);
            }
            if (SetupManager.worker.managers.size() == 0) {
                monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSetup(SetupClient f) {
        Object object = monitor;
        synchronized (object) {
            int nextLastPlusOne = this.next(this.lastPlusOne);
            if (this.first == nextLastPlusOne) {
                HashSet<SetupClient> set = new HashSet<SetupClient>();
                int i = this.first;
                while (i != this.lastPlusOne) {
                    set.add(this.settingUp[i]);
                    i = this.next(i);
                }
                set.add(f);
                if (set.size() >= this.settingUp.length) {
                    Debug.assertFail();
                }
                this.first = 0;
                this.lastPlusOne = 0;
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    this.settingUp[this.lastPlusOne] = (SetupClient)it.next();
                    ++this.lastPlusOne;
                }
                for (i = this.lastPlusOne; i < this.settingUp.length; ++i) {
                    this.settingUp[i] = null;
                }
            } else {
                this.settingUp[this.lastPlusOne] = f;
                this.lastPlusOne = nextLastPlusOne;
            }
            monitor.notifyAll();
        }
    }

    private int next(int i) {
        if (++i >= this.settingUp.length) {
            return 0;
        }
        return i;
    }

    private boolean hasWork() {
        return this.first != this.lastPlusOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        SetupClient work;
        Object object = monitor;
        synchronized (object) {
            if (!this.hasWork()) {
                return;
            }
            work = this.settingUp[this.first];
        }
        if (work.needsMoreSetup()) {
            work.doSomeSetup();
        }
        object = monitor;
        synchronized (object) {
            if (this.hasWork() && !this.settingUp[this.first].needsMoreSetup()) {
                this.settingUp[this.first] = null;
                this.first = this.next(this.first);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Debug.println("Setup thread starts.");
        SetupManager found = null;
        while (true) {
            Object object = monitor;
            synchronized (object) {
                if (this.managers.size() == 0) {
                    if (worker != this) {
                        Debug.assertFail();
                    }
                    worker = null;
                    break;
                }
                if (found != null && !super.hasWork()) {
                    found = null;
                }
                for (int i = 0; found == null && i < this.managers.size(); ++i) {
                    SetupManager m = (SetupManager)this.managers.get(i);
                    if (!m.hasWork()) continue;
                    found = m;
                }
                if (found == null) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            if (found == null) continue;
            found.doWork();
        }
        Debug.println("Setup thread exits.");
    }
}

