/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedFullImage;
import com.hdcookbook.grin.util.ManagedImage;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ManagedSubImage
extends ManagedImage {
    private String name;
    private ManagedFullImage mosaic;
    private Rectangle placement;
    private int numReferences = 0;

    ManagedSubImage(String name, String mosaicName, Rectangle placement) {
        this.name = name;
        this.mosaic = (ManagedFullImage)ImageManager.getImage(mosaicName);
        this.placement = placement;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.placement.width;
    }

    public int getHeight() {
        return this.placement.height;
    }

    void addReference() {
        ++this.numReferences;
        this.mosaic.addReference();
    }

    void removeReference() {
        --this.numReferences;
        this.mosaic.removeReference();
    }

    boolean isReferenced() {
        return this.numReferences > 0;
    }

    public void prepare() {
        this.mosaic.prepare();
    }

    public boolean isLoaded() {
        return this.mosaic.isLoaded();
    }

    public boolean hadErrorLoading() {
        return this.mosaic.hadErrorLoading();
    }

    public void load(Component comp) {
        this.mosaic.load(comp);
    }

    public synchronized void startLoading(Component comp) {
        this.mosaic.startLoading(comp);
    }

    public void unprepare() {
        this.mosaic.unprepare();
    }

    public void draw(Graphics2D gr, int x, int y, Component comp) {
        Rectangle p = this.placement;
        gr.drawImage(this.mosaic.image, x, y, x + p.width, y + p.height, p.x, p.y, p.x + p.width, p.y + p.height, comp);
    }

    public void drawScaled(Graphics2D gr, Rectangle bounds, Component comp) {
        Rectangle p = this.placement;
        gr.drawImage(this.mosaic.image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, p.x, p.y, p.x + p.width, p.y + p.height, comp);
    }

    public void drawClipped(Graphics2D gr, int x, int y, Rectangle subsection, Component comp) {
        Rectangle p = this.placement;
        gr.drawImage(this.mosaic.image, x, y, x + subsection.width, y + subsection.height, p.x + subsection.x, p.y + subsection.y, p.x + subsection.width, p.y + subsection.height, comp);
    }

    void destroy() {
        ImageManager.ungetImage(this.mosaic);
    }
}

