/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedFullImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class AssetFinder {
    private static AssetFinder helper = null;
    private static Class theClass = class$com$hdcookbook$grin$util$AssetFinder == null ? (class$com$hdcookbook$grin$util$AssetFinder = AssetFinder.class$("com.hdcookbook.grin.util.AssetFinder")) : class$com$hdcookbook$grin$util$AssetFinder;
    private static String[] appJarPath;
    private static File[] filePath;
    static /* synthetic */ Class class$com$hdcookbook$grin$util$AssetFinder;

    protected AssetFinder() {
    }

    public static void setHelper(AssetFinder helperArg) {
        helper = helperArg;
    }

    public static void setSearchPath(String[] appJarPathArg, File[] filePathArg) {
        if (appJarPathArg == null) {
            appJarPath = null;
        } else {
            appJarPath = new String[appJarPathArg.length];
            for (int i = 0; i < appJarPathArg.length; ++i) {
                AssetFinder.appJarPath[i] = appJarPathArg[i].endsWith("/") ? appJarPathArg[i] : appJarPathArg[i] + "/";
            }
        }
        filePath = filePathArg;
    }

    public static void setImageMap(String mapFile) {
        Hashtable map = new Hashtable();
        try {
            ImageManager.readImageMap(mapFile, map);
            ImageManager.setImageMap(map);
        }
        catch (IOException ex) {
            Debug.printStackTrace(ex);
            Debug.assertFail();
        }
    }

    public static void setImageMap(String[] mapFiles) {
        Hashtable map = new Hashtable();
        try {
            for (int i = 0; i < mapFiles.length; ++i) {
                ImageManager.readImageMap(mapFiles[i], map);
            }
            ImageManager.setImageMap(map);
        }
        catch (IOException ex) {
            Debug.printStackTrace(ex);
            Debug.assertFail();
        }
    }

    public static URL getURL(String path) {
        URL u = AssetFinder.tryURL(path);
        if (u == null) {
            int i;
            if (appJarPath != null) {
                for (i = 0; i < appJarPath.length; ++i) {
                    Debug.println("   Tried " + appJarPath[i] + path);
                }
            }
            if (filePath != null) {
                for (i = 0; i < filePath.length; ++i) {
                    Debug.println("   Tried " + new File(filePath[i], path));
                }
            }
            Debug.println();
            Debug.println("****  Resource " + path + " does not exist!  ****");
            Debug.println();
        }
        return u;
    }

    public static URL tryURL(String path) {
        URL u;
        if (helper != null && (u = helper.tryURLHelper(path)) != null) {
            return u;
        }
        if (appJarPath == null && filePath == null) {
            Debug.assertFail("Search path not set.");
        }
        if (appJarPath != null) {
            for (int i = 0; i < appJarPath.length; ++i) {
                URL u2 = theClass.getResource(appJarPath[i] + path);
                if (u2 == null) continue;
                return u2;
            }
        }
        if (filePath != null) {
            for (int i = 0; i < filePath.length; ++i) {
                File f = new File(filePath[i], path);
                if (!f.exists()) continue;
                try {
                    return f.toURL();
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
            }
        }
        return null;
    }

    protected URL tryURLHelper(String path) {
        return null;
    }

    public static Color getColor(int r, int g, int b2, int a2) {
        Color c2 = new Color(r, g, b2, a2);
        return c2;
    }

    public static Font getFont(String fontName, int style, int size) {
        if (helper != null) {
            Font f = helper.getFontHelper(fontName, style, size);
            if (f != null) {
                return f;
            }
            if (!"SansSerif".equals(fontName)) {
                Debug.println("*** Helper didn't find font " + fontName);
            }
        }
        return new Font(fontName, style, size);
    }

    protected Font getFontHelper(String fontName, int style, int size) {
        return null;
    }

    public static Image createCompatibleImageBuffer(Component c2, int width, int height) {
        Image im;
        if (helper != null && (im = helper.createCompatibleImageBufferHelper(c2, width, height)) != null) {
            return im;
        }
        return c2.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    protected Image createCompatibleImageBufferHelper(Component c2, int width, int height) {
        return null;
    }

    public static Graphics2D createGraphicsFromImageBuffer(Image buffer) {
        Graphics2D g;
        if (helper != null && (g = helper.createGraphicsFromImageBufferHelper(buffer)) != null) {
            return g;
        }
        return ((BufferedImage)buffer).createGraphics();
    }

    protected Graphics2D createGraphicsFromImageBufferHelper(Image buffer) {
        return null;
    }

    public static void destroyImageBuffer(Image buffer) {
        if (helper != null) {
            helper.destroyImageBufferHelper(buffer);
        }
    }

    protected void destroyImageBufferHelper(Image buffer) {
    }

    public static Image loadImage(String path) {
        Image im;
        if (helper != null && (im = helper.loadImageHelper(path)) != null) {
            return im;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = AssetFinder.getURL(path);
        return tk.createImage(url);
    }

    protected Image loadImageHelper(String path) {
        return null;
    }

    public static int getColorKeyCode(Color c2) {
        int code = -1;
        if (helper != null) {
            code = helper.getColorKeyCodeHelper(c2);
        }
        if (code == -1) {
            if (c2 == Color.red) {
                return 403;
            }
            if (c2 == Color.green) {
                return 404;
            }
            if (c2 == Color.yellow) {
                return 405;
            }
            if (c2 == Color.blue) {
                return 406;
            }
        }
        if (code < 403 || code > 406) {
            Debug.assertFail();
        }
        return code;
    }

    protected int getColorKeyCodeHelper(Color c2) {
        return -1;
    }

    public static void abort() {
        if (helper != null) {
            helper.abortHelper();
        }
        throw new RuntimeException("ABORT");
    }

    protected void abortHelper() {
    }

    public static void notifyLoaded(ManagedFullImage mi) {
        Debug.println("Loaded image " + mi.getName());
        if (helper != null) {
            helper.notifyLoadedHelper(mi);
        }
    }

    protected void notifyLoadedHelper(ManagedFullImage mi) {
    }

    public static void notifyUnloaded(ManagedFullImage mi, int width, int height) {
        Debug.println("Unloaded image " + mi.getName());
        if (helper != null) {
            helper.notifyUnloadedHelper(mi, width, height);
        }
    }

    protected void notifyUnloadedHelper(ManagedFullImage mi, int width, int height) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

