/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.io.binary;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.Modifier;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.io.binary.GrinBinaryReader;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GrinDataInputStream
extends DataInputStream {
    private GrinBinaryReader binaryReader;

    GrinDataInputStream(InputStream in, GrinBinaryReader reader) {
        super(in);
        this.binaryReader = reader;
    }

    public Color readColor() throws IOException {
        byte b2 = this.readByte();
        if (b2 == -1) {
            return null;
        }
        int rgba = this.readInt();
        return new Color(rgba, true);
    }

    public Rectangle readRectangle() throws IOException {
        byte b2 = this.readByte();
        if (b2 == -1) {
            return null;
        }
        double x = this.readDouble();
        double y = this.readDouble();
        double w = this.readDouble();
        double h = this.readDouble();
        return new Rectangle((int)x, (int)y, (int)w, (int)h);
    }

    public Rectangle[] readRectangleArray() throws IOException {
        byte b2 = this.readByte();
        if (b2 == -1) {
            return null;
        }
        Rectangle[] array = new Rectangle[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readRectangle();
        }
        return array;
    }

    public int[] readIntArray() throws IOException {
        byte b2 = this.readByte();
        if (b2 == -1) {
            return null;
        }
        int[] array = new int[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public int[] readSharedIntArray() throws IOException {
        int index = this.readInt();
        return this.binaryReader.getIntArrayFromReference(index);
    }

    public Rectangle[] readSharedRectangleArray() throws IOException {
        int index = this.readInt();
        return this.binaryReader.getRectangleArrayFromReference(index);
    }

    public Rectangle readSharedRectangle() throws IOException {
        int index = this.readInt();
        return this.binaryReader.getRectangleFromReference(index);
    }

    public String readString() throws IOException {
        int index = this.readInt();
        return this.binaryReader.getStringFromReference(index);
    }

    public String[] readStringArray() throws IOException {
        byte b2 = this.readByte();
        if (b2 == -1) {
            return null;
        }
        String[] array = new String[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readString();
        }
        return array;
    }

    public Feature readFeatureReference() throws IOException {
        if (this.isNull()) {
            return null;
        }
        int index = this.readInt();
        return this.binaryReader.getFeatureFromIndex(index);
    }

    public Segment readSegmentReference() throws IOException {
        if (this.isNull()) {
            return null;
        }
        int index = this.readInt();
        return this.binaryReader.getSegmentFromIndex(index);
    }

    public RCHandler readRCHandlerReference() throws IOException {
        if (this.isNull()) {
            return null;
        }
        int index = this.readInt();
        return this.binaryReader.getRCHandlerFromIndex(index);
    }

    public Feature[] readFeaturesArrayReference() throws IOException {
        if (this.readByte() == -1) {
            return null;
        }
        Feature[] f = new Feature[this.readInt()];
        for (int i = 0; i < f.length; ++i) {
            f[i] = this.readFeatureReference();
        }
        return f;
    }

    public RCHandler[] readRCHandlersArrayReference() throws IOException {
        int length = this.readInt();
        RCHandler[] handlers = new RCHandler[length];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = this.readRCHandlerReference();
        }
        return handlers;
    }

    public Command[] readCommands() throws IOException {
        int index = this.readInt();
        return this.binaryReader.getCommandArrayFromReference(index);
    }

    public boolean isNull() throws IOException {
        return this.readByte() == -1;
    }

    public void readSuperClassData(Feature feature) throws IOException {
        boolean isPublic = this.readBoolean();
        if (isPublic || this.binaryReader.debuggable) {
            feature.setName(this.readString());
        }
        if (feature instanceof Modifier) {
            ((Modifier)feature).setup(this.readFeatureReference());
        }
        if (isPublic) {
            this.binaryReader.publicFeatures.put(feature.getName(), feature);
        }
    }

    public void readSuperClassData(RCHandler handler) throws IOException {
        boolean isPublic = this.readBoolean();
        if (isPublic || this.binaryReader.debuggable) {
            handler.setName(this.readString());
        }
        if (isPublic) {
            this.binaryReader.publicRCHandlers.put(handler.getName(), handler);
        }
    }

    public void readSuperClassData(Segment segment) throws IOException {
        boolean isPublic = this.readBoolean();
        if (isPublic || this.binaryReader.debuggable) {
            segment.setName(this.readString());
        }
        if (isPublic) {
            this.binaryReader.publicSegments.put(segment.getName(), segment);
        }
    }

    public void readSuperClassData(Command command) {
    }
}

