/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.input;

import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import java.awt.Color;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class RCKeyEvent
extends Command {
    public static RCKeyEvent KEY_0;
    public static RCKeyEvent KEY_1;
    public static RCKeyEvent KEY_2;
    public static RCKeyEvent KEY_3;
    public static RCKeyEvent KEY_4;
    public static RCKeyEvent KEY_5;
    public static RCKeyEvent KEY_6;
    public static RCKeyEvent KEY_7;
    public static RCKeyEvent KEY_8;
    public static RCKeyEvent KEY_9;
    public static RCKeyEvent KEY_RIGHT;
    public static RCKeyEvent KEY_LEFT;
    public static RCKeyEvent KEY_UP;
    public static RCKeyEvent KEY_DOWN;
    public static RCKeyEvent KEY_ENTER;
    public static RCKeyEvent KEY_POPUP_MENU;
    public static RCKeyEvent KEY_PLAY;
    public static RCKeyEvent KEY_STOP;
    public static RCKeyEvent KEY_STILL_OFF;
    public static RCKeyEvent KEY_TRACK_NEXT;
    public static RCKeyEvent KEY_TRACK_PREV;
    public static RCKeyEvent KEY_FAST_FWD;
    public static RCKeyEvent KEY_REWIND;
    public static RCKeyEvent KEY_PAUSE;
    public static RCKeyEvent KEY_SECONDARY_VIDEO_ENABLE_DISABLE;
    public static RCKeyEvent KEY_SECONDARY_AUDIO_ENABLE_DISABLE;
    public static RCKeyEvent KEY_PG_TEXTST_ENABLE_DISABLE;
    public static RCKeyEvent KEY_INFO;
    public static RCKeyEvent KEY_RED;
    public static RCKeyEvent KEY_GREEN;
    public static RCKeyEvent KEY_YELLOW;
    public static RCKeyEvent KEY_BLUE;
    private static Hashtable keyByName;
    private static RCKeyEvent[] keyByEventCode;
    private String name;
    private int keyCode;
    private int mask;
    private RCKeyEvent keyReleased;

    private RCKeyEvent(String name, int keyCode, int mask) {
        super(null);
        this.name = name;
        this.keyCode = keyCode;
        this.mask = mask;
        keyByName.put(name, this);
    }

    protected RCKeyEvent(int keyCode, int mask) {
        super(null);
        this.keyCode = keyCode;
        this.mask = mask;
    }

    private RCKeyEvent() {
        super(null);
    }

    public String getName() {
        return this.name;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getBitMask() {
        return this.mask;
    }

    public boolean isKeyPress() {
        return this.keyReleased != this;
    }

    public synchronized RCKeyEvent getKeyReleased() {
        if (this.keyReleased == null) {
            this.keyReleased = new RCKeyEvent();
            this.keyReleased.name = this.name;
            this.keyReleased.keyCode = this.keyCode;
            this.keyReleased.mask = this.mask;
            this.keyReleased.keyReleased = this.keyReleased;
        }
        return this.keyReleased;
    }

    public void execute(Show caller) {
        if (this.isKeyPress()) {
            caller.internalHandleKeyPressed(this, caller);
        } else {
            caller.internalHandleKeyReleased(this, caller);
        }
    }

    public void execute() {
        Debug.assertFail();
    }

    public static RCKeyEvent getKeyByEventCode(int key) {
        RCKeyEvent result = keyByEventCode[key % keyByEventCode.length];
        if (result != null && result.keyCode == key) {
            return result;
        }
        return null;
    }

    public static RCKeyEvent getKeyByName(String name) {
        return (RCKeyEvent)keyByName.get(name);
    }

    public static Vector getEventsFromMask(int mask) {
        Collection values = keyByName.values();
        Vector<RCKeyEvent> result = new Vector<RCKeyEvent>();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            RCKeyEvent keyEvent = (RCKeyEvent)itr.next();
            if ((mask & keyEvent.getBitMask()) == 0) continue;
            result.add(keyEvent);
        }
        return result;
    }

    private static RCKeyEvent[] generatePerfectHashOfEventCodes(RCKeyEvent[] keys) {
        int remainder = 78;
        while (true) {
            boolean ok = true;
            RCKeyEvent[] result = new RCKeyEvent[remainder];
            for (int i = 0; i < keys.length; ++i) {
                int x = keys[i].keyCode % remainder;
                if (result[x] != null) {
                    ok = false;
                    break;
                }
                result[x] = keys[i];
            }
            if (ok) {
                return result;
            }
            if (++remainder <= 120) continue;
            Debug.assertFail("Find a better algorithm!");
        }
    }

    static {
        keyByName = new Hashtable();
        KEY_0 = new RCKeyEvent("0", 48, 1);
        KEY_1 = new RCKeyEvent("1", 49, 2);
        KEY_2 = new RCKeyEvent("2", 50, 4);
        KEY_3 = new RCKeyEvent("3", 51, 8);
        KEY_4 = new RCKeyEvent("4", 52, 16);
        KEY_5 = new RCKeyEvent("5", 53, 32);
        KEY_6 = new RCKeyEvent("6", 54, 64);
        KEY_7 = new RCKeyEvent("7", 55, 128);
        KEY_8 = new RCKeyEvent("8", 56, 256);
        KEY_9 = new RCKeyEvent("9", 57, 512);
        KEY_RIGHT = new RCKeyEvent("right", 39, 1024);
        KEY_LEFT = new RCKeyEvent("left", 37, 2048);
        KEY_UP = new RCKeyEvent("up", 38, 4096);
        KEY_DOWN = new RCKeyEvent("down", 40, 8192);
        KEY_ENTER = new RCKeyEvent("enter", 10, 16384);
        KEY_RED = new RCKeyEvent("red", AssetFinder.getColorKeyCode(Color.red), 32768);
        KEY_GREEN = new RCKeyEvent("green", AssetFinder.getColorKeyCode(Color.green), 65536);
        KEY_YELLOW = new RCKeyEvent("yellow", AssetFinder.getColorKeyCode(Color.yellow), 131072);
        KEY_BLUE = new RCKeyEvent("blue", AssetFinder.getColorKeyCode(Color.blue), 262144);
        KEY_POPUP_MENU = new RCKeyEvent("popup_menu", 461, 524288);
        KEY_PLAY = new RCKeyEvent("play", 415, 0x100000);
        KEY_STOP = new RCKeyEvent("stop", 413, 0x200000);
        KEY_STILL_OFF = new RCKeyEvent("still_off", 462, 0x400000);
        KEY_TRACK_NEXT = new RCKeyEvent("track_next", 425, 0x800000);
        KEY_TRACK_PREV = new RCKeyEvent("track_prev", 424, 0x1000000);
        KEY_FAST_FWD = new RCKeyEvent("fast_fwd", 417, 0x2000000);
        KEY_REWIND = new RCKeyEvent("rewind", 412, 0x4000000);
        KEY_PAUSE = new RCKeyEvent("pause", 19, 0x8000000);
        KEY_SECONDARY_VIDEO_ENABLE_DISABLE = new RCKeyEvent("secondary_video_enable_disable", 464, 0x10000000);
        KEY_SECONDARY_AUDIO_ENABLE_DISABLE = new RCKeyEvent("secondary_audio_enable_disable", 463, 0x20000000);
        KEY_PG_TEXTST_ENABLE_DISABLE = new RCKeyEvent("pg_textst_enable_disable", 465, 0x40000000);
        KEY_INFO = new RCKeyEvent("info", 457, Integer.MIN_VALUE);
        RCKeyEvent[] keys = new RCKeyEvent[]{KEY_0, KEY_1, KEY_2, KEY_3, KEY_4, KEY_5, KEY_6, KEY_7, KEY_8, KEY_9, KEY_RIGHT, KEY_LEFT, KEY_UP, KEY_DOWN, KEY_ENTER, KEY_RED, KEY_GREEN, KEY_YELLOW, KEY_BLUE, KEY_POPUP_MENU, KEY_PLAY, KEY_STOP, KEY_STILL_OFF, KEY_TRACK_NEXT, KEY_TRACK_PREV, KEY_FAST_FWD, KEY_REWIND, KEY_PAUSE, KEY_SECONDARY_VIDEO_ENABLE_DISABLE, KEY_SECONDARY_AUDIO_ENABLE_DISABLE, KEY_PG_TEXTST_ENABLE_DISABLE, KEY_INFO};
        keyByEventCode = RCKeyEvent.generatePerfectHashOfEventCodes(keys);
    }
}

