/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;

public class InterpolatedModel
extends Feature
implements Node {
    public static final int SCALE_X_FIELD = 0;
    public static final int SCALE_Y_FIELD = 1;
    public static final int SCALE_X_FACTOR_FIELD = 2;
    public static final int SCALE_Y_FACTOR_FIELD = 3;
    protected int[] frames;
    protected int[] currValues;
    protected int[][] values;
    protected int repeatFrame;
    protected int loopCount;
    private boolean isActivated = false;
    private int currFrame;
    private int currIndex;
    private int repeatIndex;
    private int loopsRemaining;
    protected Command[] endCommands;

    public InterpolatedModel(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.isActivated) {
            throw new IllegalStateException();
        }
        InterpolatedModel result = new InterpolatedModel(this.show);
        result.frames = this.frames;
        result.currValues = new int[this.currValues.length];
        System.arraycopy(this.currValues, 0, result.currValues, 0, this.currValues.length);
        result.values = this.values;
        result.repeatFrame = this.repeatFrame;
        result.loopCount = this.loopCount;
        result.currFrame = this.currFrame;
        result.currIndex = this.currIndex;
        result.repeatIndex = this.repeatIndex;
        result.loopsRemaining = this.loopsRemaining;
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        InterpolatedModel other = (InterpolatedModel)original;
        this.endCommands = Feature.cloneCommands(other.endCommands, clones);
    }

    public final int getField(int fieldNum) {
        if (!this.isActivated && this.values[fieldNum] != null) {
            Debug.assertFail("InterpolatedModel " + this.getName() + " not activated");
        }
        return this.currValues[fieldNum];
    }

    public final void setField(int fieldNum, int value) {
        if (this.values[fieldNum] != null) {
            Debug.assertFail();
        }
        this.currValues[fieldNum] = value;
    }

    public int getX() {
        return Integer.MAX_VALUE;
    }

    public int getY() {
        return Integer.MAX_VALUE;
    }

    public Command[] getEndCommands() {
        return this.endCommands;
    }

    final boolean getIsActivated() {
        return this.isActivated;
    }

    public void initialize() {
        if (this.repeatFrame == Integer.MAX_VALUE) {
            this.repeatIndex = Integer.MAX_VALUE;
        } else {
            this.repeatIndex = 0;
            while (this.repeatFrame - 1 >= this.frames[this.repeatIndex + 1]) {
                ++this.repeatIndex;
            }
        }
    }

    public void destroy() {
    }

    protected void setActivateMode(boolean mode) {
        this.isActivated = mode;
        if (mode) {
            this.loopsRemaining = this.loopCount;
            if (this.frames.length <= 1) {
                this.currFrame = Integer.MAX_VALUE;
                this.currIndex = Integer.MAX_VALUE;
            } else {
                this.currFrame = 0;
                this.currIndex = 0;
                for (int i = 0; i < this.currValues.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.currValues[i] = this.values[i][0];
                }
            }
        }
    }

    protected int setSetupMode(boolean mode) {
        return 0;
    }

    public boolean needsMoreSetup() {
        return false;
    }

    public void nextFrame() {
        if (!this.isActivated) {
            Debug.assertFail("InterpolatedModel " + this.getName() + " not activated");
        }
        if (this.currFrame == Integer.MAX_VALUE) {
            return;
        }
        ++this.currFrame;
        int nextIndex = this.currIndex + 1;
        int dist = this.frames[nextIndex] - this.frames[this.currIndex];
        int distNext = this.frames[nextIndex] - this.currFrame;
        int distLast = this.currFrame - this.frames[this.currIndex];
        if (distLast < 0 || distNext < 0 && this.frames[nextIndex] != 0) {
            Debug.assertFail();
        }
        for (int i = 0; i < this.currValues.length; ++i) {
            int[] vs = this.values[i];
            if (vs == null) continue;
            this.currValues[i] = (vs[nextIndex] * distLast + vs[this.currIndex] * distNext) / dist;
        }
        if (distNext <= 0) {
            this.currIndex = nextIndex;
            if (this.currIndex + 1 >= this.frames.length) {
                if (this.loopCount != Integer.MAX_VALUE) {
                    --this.loopsRemaining;
                }
                if (this.loopsRemaining > 0) {
                    if (this.repeatFrame == Integer.MAX_VALUE) {
                        this.currFrame = 0;
                        this.currIndex = 0;
                    } else {
                        this.currFrame = this.repeatFrame;
                        if (this.currFrame != Integer.MAX_VALUE) {
                            --this.currFrame;
                        }
                        this.currIndex = this.repeatIndex;
                    }
                } else {
                    this.loopsRemaining = this.loopCount;
                    this.currFrame = this.repeatFrame;
                    if (this.currFrame != Integer.MAX_VALUE) {
                        --this.currFrame;
                    }
                    this.currIndex = this.repeatIndex;
                    this.show.runCommands(this.endCommands);
                }
            }
        }
    }

    public void markDisplayAreasChanged() {
    }

    public void addDisplayAreas(RenderContext context) {
    }

    public void paintFrame(Graphics2D gr) {
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.frames = in.readSharedIntArray();
        this.currValues = in.readIntArray();
        this.values = new int[this.currValues.length][];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = in.readSharedIntArray();
        }
        this.repeatFrame = in.readInt();
        this.loopCount = in.readInt();
        this.endCommands = in.readCommands();
    }

    public boolean scaleBounds(int x, int y, int width, int height, Rectangle scaledBounds) {
        if (!this.isActivated) {
            Debug.assertFail("InterpolatedModel " + this.getName() + " not activated");
        }
        int dx = this.getField(0);
        int dy = this.getField(1);
        int xf = this.getField(2);
        int yf = this.getField(3);
        x = (x = (x - dx) * xf) < 0 ? (x -= 500) : (x += 500);
        x = x / 1000 + dx;
        y = (y - dy) * yf;
        y = y < 0 ? (y -= 500) : (y += 500);
        y = y / 1000 + dy;
        width = (width *= xf) < 0 ? (width -= 500) : (width += 500);
        height = (height *= yf) < 0 ? (height -= 500) : (height += 500);
        if (x != scaledBounds.x || y != scaledBounds.y || (width /= 1000) != scaledBounds.width || (height /= 1000) != scaledBounds.height) {
            scaledBounds.x = x;
            scaledBounds.y = y;
            scaledBounds.width = width;
            scaledBounds.height = height;
            return true;
        }
        return false;
    }
}

