/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedImage;
import com.hdcookbook.grin.util.SetupClient;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;

public class ImageSequence
extends Feature
implements Node,
SetupClient {
    protected Rectangle[] placements;
    protected String[] fileNames;
    protected boolean repeat;
    protected InterpolatedModel scalingModel = null;
    protected Rectangle scaledBounds = null;
    protected int loopCount;
    protected Command[] endCommands;
    protected ManagedImage[] images;
    private boolean setupMode = false;
    private boolean imagesSetup = false;
    private Object setupMonitor = new Object();
    private boolean isActivated = false;
    protected ImageSequence model;
    private int activeModelCount = 0;
    private int nextFrameCalls = 0;
    private int currFrame = 0;
    private boolean atEnd;
    private int loopsRemaining;
    private ManagedImage lastImage = null;
    private ManagedImage currImage = null;
    private Rectangle currPlacement = null;
    private DrawRecord drawRecord = new DrawRecord();

    public ImageSequence(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.isActivated) {
            throw new IllegalStateException();
        }
        ImageSequence result = new ImageSequence(this.show);
        result.placements = this.placements;
        result.fileNames = this.fileNames;
        result.repeat = this.repeat;
        if (this.scaledBounds != null) {
            result.scaledBounds = new Rectangle(this.scaledBounds);
        }
        result.loopCount = this.loopCount;
        result.images = this.images;
        for (int i = 0; i < this.images.length; ++i) {
            ManagedImage mi = this.images[i];
            if (mi == null) continue;
            ImageManager.getImage(mi);
            mi.prepare();
            if (mi == this.images[i]) continue;
            Debug.assertFail();
        }
        result.setupMode = true;
        result.imagesSetup = this.imagesSetup;
        result.nextFrameCalls = this.nextFrameCalls;
        result.currFrame = this.currFrame;
        result.activeModelCount = this.activeModelCount;
        result.atEnd = this.atEnd;
        result.loopsRemaining = this.loopsRemaining;
        result.lastImage = this.lastImage;
        result.currImage = this.currImage;
        result.currPlacement = this.currPlacement;
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        ImageSequence other = (ImageSequence)original;
        this.scalingModel = (InterpolatedModel)Feature.clonedReference(other.scalingModel, clones);
        this.endCommands = Feature.cloneCommands(other.endCommands, clones);
        this.model = (ImageSequence)Feature.clonedReference(other.model, clones);
    }

    public int getX() {
        return this.placements[this.getStateHolder().currFrame].x;
    }

    public int getY() {
        return this.placements[this.getStateHolder().currFrame].y;
    }

    public ManagedImage[] getImages() {
        return this.images;
    }

    public void initialize() {
        if (this.images != null) {
            return;
        }
        this.images = new ManagedImage[this.fileNames.length];
        for (int i = 0; i < this.fileNames.length; ++i) {
            this.images[i] = this.fileNames[i] == null ? null : ImageManager.getImage(this.fileNames[i]);
        }
    }

    public void destroy() {
        if (this.setupMode && !this.imagesSetup) {
            Debug.assertFail();
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == null) continue;
            if (this.setupMode) {
                this.images[i].unprepare();
            }
            ImageManager.ungetImage(this.images[i]);
        }
    }

    protected void setActivateMode(boolean mode) {
        this.isActivated = mode;
        if (this.model != null) {
            if (mode) {
                if (!this.model.isActivated && this.model.activeModelCount == 0) {
                    this.model.currFrame = 0;
                    this.model.atEnd = false;
                    this.model.loopsRemaining = this.model.loopCount;
                }
                ++this.model.activeModelCount;
            } else {
                --this.model.activeModelCount;
            }
        } else if (mode) {
            if (this.activeModelCount == 0) {
                this.currFrame = 0;
                this.atEnd = false;
                this.loopsRemaining = this.loopCount;
            }
            ++this.activeModelCount;
        } else {
            --this.activeModelCount;
        }
        if (mode) {
            this.lastImage = null;
            this.currImage = this.images[this.getStateHolder().currFrame];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setSetupMode(boolean mode) {
        Object object = this.setupMonitor;
        synchronized (object) {
            this.setupMode = mode;
            if (this.setupMode) {
                boolean allLoaded = true;
                for (int i = 0; i < this.images.length; ++i) {
                    ManagedImage mi = this.images[i];
                    if (mi == null) continue;
                    mi.prepare();
                    allLoaded = allLoaded && mi.isLoaded();
                }
                if (allLoaded) {
                    this.imagesSetup = true;
                    return 0;
                }
                this.show.setupManager.scheduleSetup(this);
                return 1;
            }
            for (int i = 0; i < this.images.length; ++i) {
                ManagedImage mi = this.images[i];
                if (mi == null) continue;
                mi.unprepare();
            }
            this.imagesSetup = false;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSomeSetup() {
        for (int i = 0; i < this.images.length; ++i) {
            Object object = this.setupMonitor;
            synchronized (object) {
                if (!this.setupMode) {
                    return;
                }
            }
            ManagedImage mi = this.images[i];
            if (mi == null) continue;
            mi.load(this.show.component);
        }
        Object object = this.setupMonitor;
        synchronized (object) {
            if (!this.setupMode) {
                return;
            }
            this.imagesSetup = true;
        }
        this.sendFeatureSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsMoreSetup() {
        Object object = this.setupMonitor;
        synchronized (object) {
            return this.setupMode && !this.imagesSetup;
        }
    }

    private ImageSequence getStateHolder() {
        if (this.model == null) {
            return this;
        }
        return this.model;
    }

    public void nextFrame() {
        if (!this.isActivated) {
            Debug.println("\n*** WARNING:  Advancing inactive sequence " + this.getName() + "\n");
        }
        if (this.model != null) {
            this.model.nextFrame();
        } else {
            ++this.nextFrameCalls;
            if (this.nextFrameCalls >= this.activeModelCount) {
                this.nextFrameCalls = 0;
                if (!this.atEnd) {
                    ++this.currFrame;
                    if (this.currFrame == this.images.length) {
                        if (this.loopCount != Integer.MAX_VALUE) {
                            --this.loopsRemaining;
                        }
                        if (this.loopsRemaining > 0) {
                            this.currFrame = 0;
                        } else {
                            this.loopsRemaining = this.loopCount;
                            this.show.runCommands(this.endCommands);
                            if (this.repeat) {
                                this.currFrame = 0;
                            } else {
                                this.atEnd = true;
                                --this.currFrame;
                            }
                        }
                    }
                }
            }
        }
    }

    public void setCurrentFrame(int f) {
        if (f < 0 || f >= this.images.length) {
            throw new IllegalArgumentException();
        }
        this.currFrame = f;
        this.atEnd = false;
    }

    public int getCurrentFrame() {
        return this.currFrame;
    }

    public void markDisplayAreasChanged() {
        this.drawRecord.setChanged();
    }

    public void addDisplayAreas(RenderContext context) {
        int frame = this.getStateHolder().currFrame;
        this.currImage = this.images[frame];
        this.currPlacement = this.placements[frame];
        if (this.currImage != null) {
            if (this.scalingModel == null) {
                this.drawRecord.setArea(this.currPlacement.x, this.currPlacement.y, this.currPlacement.width, this.currPlacement.height);
            } else {
                boolean changed = this.scalingModel.scaleBounds(this.currPlacement.x, this.currPlacement.y, this.currPlacement.width, this.currPlacement.height, this.scaledBounds);
                this.drawRecord.setArea(this.scaledBounds.x, this.scaledBounds.y, this.scaledBounds.width, this.scaledBounds.height);
                if (changed) {
                    this.drawRecord.setChanged();
                }
            }
            if (this.currImage != this.lastImage) {
                this.drawRecord.setChanged();
            }
            context.addArea(this.drawRecord);
        }
        this.lastImage = this.currImage;
    }

    public void paintFrame(Graphics2D gr) {
        if (!this.isActivated) {
            return;
        }
        this.doPaint(gr);
    }

    private void doPaint(Graphics2D g) {
        if (this.currImage != null) {
            if (this.scalingModel == null) {
                this.currImage.drawScaled(g, this.currPlacement, this.show.component);
            } else {
                this.currImage.drawScaled(g, this.scaledBounds, this.show.component);
            }
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.placements = in.readSharedRectangleArray();
        this.fileNames = in.readStringArray();
        this.repeat = in.readBoolean();
        if (in.readBoolean()) {
            this.model = (ImageSequence)in.readFeatureReference();
        }
        this.loopCount = in.readInt();
        this.endCommands = in.readCommands();
        if (in.readBoolean()) {
            this.scalingModel = (InterpolatedModel)in.readFeatureReference();
            this.scaledBounds = new Rectangle();
        }
        if (this.placements.length != this.fileNames.length) {
            Debug.assertFail();
        }
    }
}

