/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Group
extends Feature
implements Node {
    private Feature[] parts;
    private Feature[] visibleParts;
    private boolean activated = false;
    private int numSetupChecked;

    public Group(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.activated) {
            throw new IllegalStateException();
        }
        Group result = new Group(this.show);
        result.parts = new Feature[this.parts.length];
        result.numSetupChecked = this.numSetupChecked;
        for (int i = 0; i < this.parts.length; ++i) {
            result.parts[i] = this.parts[i].makeNewClone(clones);
        }
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        Group other = (Group)original;
        if (other.visibleParts == other.parts) {
            this.visibleParts = this.parts;
        } else {
            this.visibleParts = new Feature[other.visibleParts.length];
            for (int i = 0; i < this.visibleParts.length; ++i) {
                Feature f = other.visibleParts[i];
                this.visibleParts[i] = Feature.clonedReference(f, clones);
            }
        }
    }

    public void addSubgraph(HashSet set) {
        if (set.contains(this)) {
            return;
        }
        super.addSubgraph(set);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].addSubgraph(set);
        }
    }

    public Feature[] getParts() {
        return this.parts;
    }

    protected void setParts(Feature[] parts) {
        this.parts = parts;
        this.visibleParts = parts;
    }

    public int getX() {
        int x = Integer.MAX_VALUE;
        for (int i = 0; i < this.visibleParts.length; ++i) {
            int val = this.visibleParts[i].getX();
            if (val >= x) continue;
            x = val;
        }
        return x;
    }

    public int getY() {
        int y = Integer.MAX_VALUE;
        for (int i = 0; i < this.visibleParts.length; ++i) {
            int val = this.visibleParts[i].getY();
            if (val >= y) continue;
            y = val;
        }
        return y;
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public void resetVisibleParts(Feature[] visibleParts) {
        if (!this.isSetup() && (visibleParts != null || this.activated)) {
            Debug.assertFail();
        }
        if (visibleParts != null) {
            HashSet union = null;
            for (int i = 0; i < visibleParts.length; ++i) {
                HashSet child = new HashSet();
                visibleParts[i].addSubgraph(child);
                if (union == null) {
                    union = child;
                    continue;
                }
                Iterator it = child.iterator();
                while (it.hasNext()) {
                    Object f = it.next();
                    if (union.contains(f)) {
                        Debug.assertFail("Invalid cloned scene graph -  see comments in Group");
                    }
                    union.add(f);
                }
            }
        }
        this.resetVisiblePartsNoAssert(visibleParts);
    }

    public void resetVisiblePartsNoAssert(Feature[] visibleParts) {
        if (visibleParts == null) {
            visibleParts = this.parts;
        }
        if (this.activated) {
            int i;
            for (i = 0; i < visibleParts.length; ++i) {
                visibleParts[i].activate();
            }
            for (i = 0; i < this.visibleParts.length; ++i) {
                this.visibleParts[i].deactivate();
            }
        }
        this.visibleParts = visibleParts;
    }

    protected void setActivateMode(boolean mode) {
        this.activated = mode;
        if (mode) {
            for (int i = 0; i < this.visibleParts.length; ++i) {
                this.visibleParts[i].activate();
            }
        } else {
            for (int i = 0; i < this.visibleParts.length; ++i) {
                this.visibleParts[i].deactivate();
            }
        }
    }

    protected int setSetupMode(boolean mode) {
        if (mode) {
            this.numSetupChecked = 0;
            int num = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                num += this.parts[i].setup();
            }
            return num;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].unsetup();
        }
        return 0;
    }

    public boolean needsMoreSetup() {
        while (this.numSetupChecked < this.parts.length) {
            if (this.parts[this.numSetupChecked].needsMoreSetup()) {
                return true;
            }
            ++this.numSetupChecked;
        }
        return false;
    }

    public void markDisplayAreasChanged() {
        for (int i = 0; i < this.visibleParts.length; ++i) {
            this.visibleParts[i].markDisplayAreasChanged();
        }
    }

    public void addDisplayAreas(RenderContext context) {
        for (int i = 0; i < this.visibleParts.length; ++i) {
            this.visibleParts[i].addDisplayAreas(context);
        }
    }

    public void paintFrame(Graphics2D gr) {
        for (int i = 0; i < this.visibleParts.length; ++i) {
            this.visibleParts[i].paintFrame(gr);
        }
    }

    public void nextFrame() {
        for (int i = 0; i < this.visibleParts.length; ++i) {
            this.visibleParts[i].nextFrame();
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.setParts(in.readFeaturesArrayReference());
    }
}

