/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.ClockBasedEngine;
import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class RepaintDrawEngine
extends ClockBasedEngine {
    private Container container;
    private Component rdComponent;
    private Rectangle bounds;
    private Image buffer = null;
    private Graphics2D bufferG = null;
    private Object repaintMonitor = new Object();
    private boolean repaintPending = false;
    private Rectangle clipBounds = new Rectangle();
    private Rectangle damageArea = new Rectangle();

    public void initContainer(Container container, Rectangle bounds) {
        this.container = container;
        this.bounds = bounds;
        this.rdComponent = new Component(){

            public void paint(Graphics g) {
                try {
                    RepaintDrawEngine.this.rdRepaintFrame((Graphics2D)g);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.rdComponent.setBounds(bounds);
        container.add(this.rdComponent);
        this.rdComponent.setVisible(true);
        if (!container.isDoubleBuffered()) {
            this.buffer = AssetFinder.createCompatibleImageBuffer(container, bounds.width, bounds.height);
            this.bufferG = AssetFinder.createGraphicsFromImageBuffer(this.buffer);
            this.bufferG.setComposite(AlphaComposite.Src);
            this.bufferG.setColor(transparent);
            this.bufferG.fillRect(0, 0, bounds.width, bounds.height);
        }
        this.repaintBounds = new Rectangle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rdRepaintFrame(Graphics2D g) throws InterruptedException {
        g.setComposite(AlphaComposite.Src);
        Object object = this.repaintMonitor;
        synchronized (object) {
            if (this.repaintPending) {
                if (this.buffer == null) {
                    this.paintFrame(g);
                } else {
                    this.clipBounds.setBounds(this.bounds);
                    g.getClipBounds(this.clipBounds);
                    Rectangle a2 = this.clipBounds;
                    g.drawImage(this.buffer, a2.x, a2.y, a2.x + a2.width, a2.y + a2.height, a2.x, a2.y, a2.x + a2.width, a2.y + a2.height, null);
                }
                this.repaintPending = false;
                this.repaintMonitor.notify();
                return;
            }
        }
        Debug.println("repainting...");
        this.repaintFrame(g);
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Component getComponent() {
        return this.rdComponent;
    }

    public synchronized void addRepaintArea(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.repaintBounds.isEmpty()) {
            this.repaintBounds.setBounds(x, y, width, height);
        } else {
            this.repaintBounds.add(x, y);
            this.repaintBounds.add(x + width, y + height);
        }
    }

    protected void clearArea(int x, int y, int width, int height) {
        if (this.buffer != null) {
            this.bufferG.setColor(transparent);
            this.bufferG.fillRect(x, y, width, height);
        }
    }

    protected boolean needsFullRedrawInAnimationLoop() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callPaintTargets() throws InterruptedException {
        if (this.renderContext.numDrawTargets == 0) {
            return;
        }
        this.damageArea.setBounds(this.renderContext.drawTargets[0]);
        for (int i = 1; i < this.renderContext.numDrawTargets; ++i) {
            this.damageArea.add(this.renderContext.drawTargets[i]);
        }
        Rectangle a2 = this.damageArea;
        Object object = this.repaintMonitor;
        synchronized (object) {
            if (this.buffer != null) {
                this.bufferG.setClip(this.damageArea);
                this.paintTargets(this.bufferG);
                this.bufferG.setClip(null);
            }
            this.repaintPending = true;
            this.rdComponent.repaint(a2.x, a2.y, a2.width, a2.height);
            try {
                this.repaintMonitor.wait(40L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void finishedFrame() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminatingEraseScreen() {
        this.rdComponent.repaint();
        this.container.remove(this.rdComponent);
        Image buf = this.buffer;
        if (buf != null) {
            Object object = this.repaintMonitor;
            synchronized (object) {
                this.buffer = null;
                this.bufferG = null;
            }
            AssetFinder.destroyImageBuffer(buf);
        }
    }
}

