/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin;

import com.hdcookbook.grin.Director;
import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.GrinXHelper;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.ShowInitializer;
import com.hdcookbook.grin.animator.AnimationClient;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.ActivateSegmentCommand;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.Group;
import com.hdcookbook.grin.features.SetTarget;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.RCKeyEvent;
import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedImage;
import com.hdcookbook.grin.util.Queue;
import com.hdcookbook.grin.util.SetupClient;
import com.hdcookbook.grin.util.SetupManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.Hashtable;

public class Show
implements AnimationClient {
    private Director director;
    public SetupManager setupManager;
    public Component component;
    public ShowInitializer initializer = new ShowInitializer();
    protected Segment[] segments;
    protected Feature[] features;
    protected RCHandler[] rcHandlers;
    protected Hashtable publicSegments;
    protected Hashtable publicFeatures;
    protected Hashtable publicRCHandlers;
    protected Hashtable publicNamedCommands;
    protected ManagedImage[] stickyImages = null;
    protected Segment showTop = null;
    protected Group showTopGroup = null;
    private Segment currentSegment = null;
    private Segment[] segmentStack = new Segment[0];
    private int segmentStackPos = 0;
    private String[] drawTargets;
    private int defaultDrawTarget = 0;
    private ActivateSegmentCommand popSegmentCommand = null;
    private GrinXHelper syncDisplayCommand = null;
    private GrinXHelper segmentDoneCommand = null;
    private boolean initialized = false;
    private boolean destroyed = false;
    private Queue pendingCommands = new Queue(32);
    private boolean deferringPendingCommands = false;
    private int numTargets = 1;
    private boolean inputOK = true;
    private int inputOKWaiting = 0;
    protected String[] fontName;
    protected int[] fontStyleSize;
    private Font[] font;
    private int xScale = 1000;
    private int yScale = 1000;
    private int xOffset = 0;
    private int yOffset = 0;

    public Show(Director director) {
        if (director == null) {
            director = new Director();
        }
        this.director = director;
        director.setShow(this);
    }

    public Director getDirector() {
        return this.director;
    }

    public void buildShow(Segment[] segments, Feature[] features, RCHandler[] rcHandlers, String[] stickyImages, Segment showTop, Group showTopGroup, Hashtable publicSegments, Hashtable publicFeatures, Hashtable publicRCHandlers, Hashtable publicNamedCommands, String[] fontName, int[] fontStyleSize) throws IOException {
        int i;
        this.segments = segments;
        this.features = features;
        this.rcHandlers = rcHandlers;
        if (stickyImages != null) {
            this.stickyImages = new ManagedImage[stickyImages.length];
            for (i = 0; i < stickyImages.length; ++i) {
                this.stickyImages[i] = ImageManager.getImage(stickyImages[i]);
            }
        }
        this.showTopGroup = showTopGroup;
        this.showTop = showTop;
        this.showTop.setShow(this);
        this.publicSegments = publicSegments;
        this.publicFeatures = publicFeatures;
        this.publicRCHandlers = publicRCHandlers;
        this.publicNamedCommands = publicNamedCommands;
        for (i = 0; i < rcHandlers.length; ++i) {
            rcHandlers[i].setShow(this);
        }
        for (i = 0; i < segments.length; ++i) {
            segments[i].setShow(this);
        }
        this.fontName = fontName;
        this.fontStyleSize = fontStyleSize;
        this.font = new Font[fontName.length];
    }

    public void setScale(int xScale, int yScale, int xOffset, int yOffset) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public Font getFont(int index) {
        if (this.font[index] == null) {
            int style = this.fontStyleSize[index] & 3;
            int size = this.fontStyleSize[index] >> 2;
            this.font[index] = AssetFinder.getFont(this.fontName[index], style, size);
        }
        return this.font[index];
    }

    public void initialize(Component component) {
        int i;
        if (this.initialized) {
            Debug.assertFail("Initizlize called twice");
        }
        this.initialized = true;
        this.component = component;
        if (this.stickyImages != null) {
            for (i = 0; i < this.stickyImages.length; ++i) {
                this.stickyImages[i].makeSticky();
            }
        }
        this.popSegmentCommand = new ActivateSegmentCommand(this, false, true);
        int num = 0;
        for (int i2 = 0; i2 < this.features.length; ++i2) {
            if (!(this.features[i2] instanceof SetupClient)) continue;
            ++num;
        }
        this.setupManager = new SetupManager(num);
        this.setupManager.start();
        for (i = 0; i < this.segments.length; ++i) {
            this.segments[i].initialize();
        }
        for (i = 0; i < this.features.length; ++i) {
            this.features[i].initialize();
        }
        this.showTop.initialize();
        this.showTop.activate(null);
        this.initializer = null;
    }

    public synchronized void destroy() {
        int i;
        if (!this.initialized) {
            Debug.assertFail("Destroy of uninitialized show");
        }
        if (this.currentSegment != null) {
            this.currentSegment.deactivate();
            this.currentSegment = null;
        }
        this.showTop.deactivate();
        this.showTop = null;
        for (i = 0; i < this.features.length; ++i) {
            this.features[i].destroy();
        }
        if (this.stickyImages != null) {
            for (i = 0; i < this.stickyImages.length; ++i) {
                this.stickyImages[i].unmakeSticky();
            }
        }
        this.destroyed = true;
        this.setupManager.stop();
        this.director.notifyDestroyed();
        this.notifyAll();
    }

    public void setSegmentStackDepth(int depth) {
        this.segmentStack = new Segment[depth];
    }

    public void setDrawTargets(String[] drawTargets) {
        this.drawTargets = drawTargets;
    }

    public String[] getDrawTargets() {
        return this.drawTargets;
    }

    public void mapDrawTargets(Hashtable targetMap) {
        this.defaultDrawTarget = (Integer)targetMap.get(this.drawTargets[0]);
        for (int i = 0; i < this.features.length; ++i) {
            Feature f = this.features[i];
            if (!(f instanceof SetTarget)) continue;
            ((SetTarget)f).mapDrawTarget(targetMap);
        }
    }

    public Feature getFeature(String name) {
        return (Feature)this.publicFeatures.get(name);
    }

    public Command getNamedCommand(String name) {
        return (Command)this.publicNamedCommands.get(name);
    }

    public RCHandler getRCHandler(String name) {
        return (RCHandler)this.publicRCHandlers.get(name);
    }

    public Segment getSegment(String name) {
        return (Segment)this.publicSegments.get(name);
    }

    public int getSegmentStackDepth() {
        return this.segmentStack.length;
    }

    public void activateSegment(Segment seg) {
        this.activateSegment(seg, false);
    }

    public void activateSegment(Segment seg, boolean push) {
        if (seg != null && seg.show != this) {
            Debug.assertFail();
        }
        if (seg == null) {
            this.runCommand(this.popSegmentCommand);
        } else {
            this.runCommand(seg.getCommandToActivate(push));
        }
    }

    public synchronized void pushCurrentSegment() {
        this.segmentStack[this.segmentStackPos] = this.currentSegment;
        this.segmentStackPos = (this.segmentStackPos + 1) % this.segmentStack.length;
    }

    public synchronized Segment popSegmentStack() {
        --this.segmentStackPos;
        if (this.segmentStackPos < 0) {
            this.segmentStackPos = this.segmentStack.length - 1;
        }
        Segment result = this.segmentStack[this.segmentStackPos];
        this.segmentStack[this.segmentStackPos] = null;
        return result;
    }

    public void syncDisplay() {
        if (this.syncDisplayCommand == null) {
            GrinXHelper cmd = new GrinXHelper(this);
            cmd.setCommandNumber(0);
            this.syncDisplayCommand = cmd;
        }
        this.runCommand(this.syncDisplayCommand);
    }

    public void segmentDone() {
        if (this.segmentDoneCommand == null) {
            GrinXHelper cmd = new GrinXHelper(this);
            cmd.setCommandNumber(1);
            this.segmentDoneCommand = cmd;
        }
        this.runCommand(this.segmentDoneCommand);
    }

    public void runCommand(Command cmd) {
        this.pendingCommands.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommands(Command[] cmds) {
        if (cmds == null || cmds.length == 0) {
            return;
        }
        Queue queue = this.pendingCommands;
        synchronized (queue) {
            for (int i = 0; i < cmds.length; ++i) {
                this.pendingCommands.add(cmds[i]);
            }
        }
    }

    public synchronized void setCaughtUp() {
        this.deferringPendingCommands = false;
    }

    public synchronized void nextFrame() throws InterruptedException {
        if (this.currentSegment != null) {
            this.showTop.nextFrameForActiveFeatures();
            this.currentSegment.nextFrameForRCHandlers();
        }
        this.director.notifyNextFrame();
    }

    synchronized void runPendingCommands() {
        while (!this.deferringPendingCommands && !this.pendingCommands.isEmpty()) {
            Command c2 = (Command)this.pendingCommands.remove();
            if (c2 == null) continue;
            c2.execute(this);
        }
    }

    public synchronized void deferNextCommands() {
        this.deferringPendingCommands = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doActivateSegment(Segment newS) {
        Segment old = this.currentSegment;
        Queue queue = this.pendingCommands;
        synchronized (queue) {
            this.currentSegment = newS;
        }
        this.currentSegment.activate(old);
        this.director.notifySegmentActivated(newS, old);
    }

    public void doSegmentDone() {
        this.currentSegment.doSegmentDone();
    }

    public synchronized Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public synchronized void addDisplayAreas(RenderContext context) throws InterruptedException {
        while (this.inputOKWaiting > 0) {
            this.wait();
        }
        this.inputOK = false;
        if (this.currentSegment != null) {
            int old = context.setTarget(this.defaultDrawTarget);
            this.showTop.addDisplayAreas(context);
            context.setTarget(old);
        }
    }

    public synchronized void paintFrame(Graphics2D gr) throws InterruptedException {
        if (Thread.interrupted() || this.destroyed) {
            throw new InterruptedException();
        }
        if (this.currentSegment != null) {
            this.showTop.paintFrame(gr);
        }
        if (this.deferringPendingCommands) {
            Debug.assertFail();
        }
    }

    public synchronized void paintDone() {
        this.inputOK = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForInputOK() {
        if (!this.inputOK && !this.destroyed) {
            ++this.inputOKWaiting;
            try {
                while (!this.inputOK && !this.destroyed) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                boolean bl = false;
                return bl;
            }
            finally {
                --this.inputOKWaiting;
                this.notifyAll();
            }
        }
        return !this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleKeyPressed(int vkCode) {
        Queue queue = this.pendingCommands;
        synchronized (queue) {
            if (this.currentSegment == null) {
                return false;
            }
            RCKeyEvent re = RCKeyEvent.getKeyByEventCode(vkCode);
            if (re == null) {
                return false;
            }
            if ((this.currentSegment.rcPressedInterest & re.getBitMask()) == 0) {
                return false;
            }
            this.pendingCommands.add(re);
        }
        return true;
    }

    public synchronized void internalHandleKeyPressed(RCKeyEvent re, Show caller) {
        if (this.currentSegment != null) {
            this.currentSegment.handleKeyPressed(re, caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleKeyReleased(int vkCode) {
        Queue queue = this.pendingCommands;
        synchronized (queue) {
            if (this.currentSegment == null) {
                return false;
            }
            RCKeyEvent re = RCKeyEvent.getKeyByEventCode(vkCode);
            if (re == null) {
                return false;
            }
            if ((this.currentSegment.rcReleasedInterest & re.getBitMask()) == 0) {
                return false;
            }
            this.pendingCommands.add(re.getKeyReleased());
        }
        return true;
    }

    public synchronized void internalHandleKeyReleased(RCKeyEvent re, Show caller) {
        if (this.currentSegment != null) {
            this.currentSegment.handleKeyReleased(re, caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleKeyTyped(RCKeyEvent typed) {
        Queue queue = this.pendingCommands;
        synchronized (queue) {
            if ((this.currentSegment.keyTypedInterest & typed.getBitMask()) == 0) {
                return false;
            }
            this.pendingCommands.add(typed);
        }
        return true;
    }

    public synchronized void internalHandleKeyTyped(RCKeyEvent re, Show caller) {
        if (this.currentSegment != null) {
            this.currentSegment.handleKeyTyped(re, caller);
        }
    }

    public synchronized void handleMouseMoved(int x, int y) {
        Cursor c2;
        boolean used = false;
        if (this.currentSegment != null) {
            if (!this.waitForInputOK()) {
                return;
            }
            used = this.currentSegment.handleMouse(x, y, false);
        }
        Cursor cursor = c2 = used ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
        if (this.component != null && c2 != this.component.getCursor()) {
            this.component.setCursor(c2);
        }
    }

    public synchronized void handleMouseClicked(int x, int y) {
        if (this.currentSegment != null) {
            if (!this.waitForInputOK()) {
                return;
            }
            this.currentSegment.handleMouse(x, y, true);
        }
        Cursor c2 = Cursor.getDefaultCursor();
        if (this.component != null && c2 != this.component.getCursor()) {
            this.component.setCursor(c2);
        }
    }

    public static int scale(int value, int mills) {
        return (value * mills + 500) / 1000;
    }

    public int getXScale() {
        return this.xScale;
    }

    public int getYScale() {
        return this.yScale;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }
}

