/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.Assembly;
import com.hdcookbook.grin.util.Debug;

public class Director {
    private Show show;

    void setShow(Show show) {
        this.show = show;
    }

    public Show getShow() {
        return this.show;
    }

    public Feature getFeature(String name) {
        Feature f = this.getShow().getFeature(name);
        if (f == null) {
            Debug.assertFail("Feature \"" + name + "\" not found.");
        }
        return f;
    }

    public Command getNamedCommand(String name) {
        Command c2 = this.getShow().getNamedCommand(name);
        if (c2 == null) {
            Debug.assertFail("Named command \"" + name + "\" not found.");
        }
        return c2;
    }

    public Feature getPart(Assembly assembly, String partName) {
        Feature[] parts = assembly.getParts();
        String[] partNames = assembly.getPartNames();
        for (int i = 0; i < parts.length; ++i) {
            if (!partName.equals(partNames[i])) continue;
            return parts[i];
        }
        Debug.assertFail();
        return null;
    }

    public Segment getSegment(String name) {
        Segment s = this.getShow().getSegment(name);
        if (s == null) {
            Debug.assertFail("Segment \"" + name + "\" not found.");
        }
        return s;
    }

    public void notifyNextFrame() {
        this.show.runPendingCommands();
    }

    public void notifySegmentActivated(Segment newSegment, Segment oldSegment) {
    }

    public void notifyAssemblyPartSelected(Assembly assembly, Feature newPart, Feature oldPart, boolean assemblyIsActive) {
    }

    public void notifyDestroyed() {
    }
}

