/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonIO {
    private static long LONG_MAX_MSD = 9000000000000000000L;

    private JsonIO() {
    }

    public static void writeJSON(Writer out, Object value) throws IOException {
        if (value == null) {
            out.write("null");
        } else if (value instanceof Number) {
            out.write(value.toString());
        } else if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                out.write("true");
            } else {
                out.write("false");
            }
        } else if (value instanceof String) {
            String s = (String)value;
            out.write(34);
            for (int i = 0; i < s.length(); ++i) {
                char c2 = s.charAt(i);
                if (c2 == '\"') {
                    out.write(92);
                    out.write(34);
                    continue;
                }
                if (c2 == '\\') {
                    out.write("\\\\");
                    continue;
                }
                if (c2 == '\b') {
                    out.write("\\b");
                    continue;
                }
                if (c2 == '\f') {
                    out.write("\\f");
                    continue;
                }
                if (c2 == '\n') {
                    out.write("\\n");
                    continue;
                }
                if (c2 == '\r') {
                    out.write("\\r");
                    continue;
                }
                if (c2 == '\t') {
                    out.write("\\t");
                    continue;
                }
                if (c2 < ' ' || c2 > '~') {
                    out.write("\\u");
                    String hex = Integer.toHexString(c2);
                    for (int j = hex.length(); j < 4; ++j) {
                        out.write(48);
                    }
                    out.write(hex);
                    continue;
                }
                out.write(c2);
            }
            out.write(34);
        } else if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            out.write(91);
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    out.write(44);
                }
                JsonIO.writeJSON(out, arr[i]);
            }
            out.write(93);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            out.write(123);
            boolean first = true;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    out.write(44);
                }
                Map.Entry ent = it.next();
                JsonIO.writeJSON(out, ent.getKey());
                out.write(58);
                JsonIO.writeJSON(out, ent.getValue());
            }
            out.write(125);
        } else {
            throw new IOException("Invalid type " + value.getClass() + " for " + value);
        }
    }

    public static Object readJSON(Reader rdr) throws IOException {
        int c2;
        char ch;
        if (!rdr.markSupported()) {
            throw new IOException("Reader.markSupported must be true");
        }
        do {
            if ((c2 = rdr.read()) != -1) continue;
            throw new IOException("Unexpected EOF");
        } while (JsonIO.skipWhitespace(ch = (char)c2, rdr));
        if (ch == '\"' || ch == '\'') {
            return JsonIO.readString(rdr, ch);
        }
        if (ch == '{') {
            return JsonIO.readHashMap(rdr);
        }
        if (ch == '[') {
            return JsonIO.readArray(rdr);
        }
        if ((ch = Character.toLowerCase(ch)) == 't') {
            JsonIO.readConstant(rdr, "rue");
            return Boolean.TRUE;
        }
        if (ch == 'f') {
            JsonIO.readConstant(rdr, "alse");
            return Boolean.FALSE;
        }
        if (ch == 'n') {
            JsonIO.readConstant(rdr, "ull");
            return null;
        }
        return JsonIO.readNumber(rdr, ch);
    }

    private static boolean skipWhitespace(int ch, Reader rdr) throws IOException {
        if (Character.isWhitespace((char)ch)) {
            return true;
        }
        if (ch == 47) {
            JsonIO.skipSlashComment(rdr);
            return true;
        }
        if (ch == 35) {
            JsonIO.skipToEOLN(rdr);
            return true;
        }
        return false;
    }

    private static void skipSlashComment(Reader rdr) throws IOException {
        int c2 = rdr.read();
        if (c2 != 47) {
            if (c2 == 42) {
                boolean starSeen = false;
                while (true) {
                    if ((c2 = rdr.read()) == -1) {
                        throw new IOException("Unexpected EOF");
                    }
                    if (starSeen && c2 == 47) {
                        return;
                    }
                    starSeen = c2 == 42;
                }
            }
            throw new IOException("Syntax error");
        }
        JsonIO.skipToEOLN(rdr);
    }

    private static void skipToEOLN(Reader rdr) throws IOException {
        int c2;
        do {
            if ((c2 = rdr.read()) != -1) continue;
            throw new IOException("Unexpected EOF");
        } while (c2 != 10 && c2 != 13);
    }

    private static String readString(Reader rdr, char delimiter) throws IOException {
        StringBuffer buf = new StringBuffer();
        block10: while (true) {
            int c2;
            if ((c2 = rdr.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (c2 == 92) {
                c2 = rdr.read();
                switch (c2) {
                    case -1: {
                        throw new IOException("Unexpected EOF");
                    }
                    case 98: {
                        buf.append('\b');
                        continue block10;
                    }
                    case 116: {
                        buf.append('\t');
                        continue block10;
                    }
                    case 110: {
                        buf.append('\n');
                        continue block10;
                    }
                    case 102: {
                        buf.append('\f');
                        continue block10;
                    }
                    case 114: {
                        buf.append('\r');
                        continue block10;
                    }
                    case 117: {
                        buf.append(JsonIO.parseHex(rdr, 4));
                        continue block10;
                    }
                    case 120: {
                        buf.append(JsonIO.parseHex(rdr, 2));
                        continue block10;
                    }
                }
                buf.append((char)c2);
                continue;
            }
            if (c2 == delimiter) {
                return buf.toString();
            }
            buf.append((char)c2);
        }
    }

    private static char parseHex(Reader rdr, int digits) throws IOException {
        int val = 0;
        for (int i = 0; i < digits; ++i) {
            val *= 16;
            int ch = rdr.read();
            if (ch >= 48 && ch <= 57) {
                val += ch - 48;
                continue;
            }
            if (ch >= 65 && ch <= 70) {
                val += ch - 65 + 10;
                continue;
            }
            if (ch >= 97 && ch <= 102) {
                val += ch - 97 + 10;
                continue;
            }
            JsonIO.throwUnexpected(ch);
        }
        return (char)val;
    }

    private static HashMap readHashMap(Reader rdr) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (true) {
            int ch;
            if (JsonIO.skipWhitespace(ch = rdr.read(), rdr)) {
                continue;
            }
            if (ch == 125) {
                return result;
            }
            if (ch == 44) continue;
            if (ch == 34 || ch == 39) {
                String key = JsonIO.readString(rdr, (char)ch);
                while ((ch = rdr.read()) != 58) {
                    if (JsonIO.skipWhitespace(ch, rdr)) continue;
                    JsonIO.throwUnexpected(ch);
                }
                Object value = JsonIO.readJSON(rdr);
                result.put(key, value);
                continue;
            }
            JsonIO.throwUnexpected(ch);
        }
    }

    private static Object[] readArray(Reader rdr) throws IOException {
        while (true) {
            rdr.mark(1);
            int ch = rdr.read();
            if (ch == -1) {
                JsonIO.throwUnexpected(ch);
                continue;
            }
            if (ch == 93) {
                return new Object[0];
            }
            if (!JsonIO.skipWhitespace(ch, rdr)) break;
        }
        rdr.reset();
        ArrayList<Object> result = new ArrayList<Object>();
        block1: while (true) {
            result.add(JsonIO.readJSON(rdr));
            while (true) {
                int ch;
                if ((ch = rdr.read()) == 44) continue block1;
                if (ch == 93) {
                    return result.toArray(new Object[result.size()]);
                }
                if (JsonIO.skipWhitespace(ch, rdr)) continue;
                JsonIO.throwUnexpected(ch);
            }
            break;
        }
    }

    private static void readConstant(Reader rdr, String wanted) throws IOException {
        for (int i = 0; i < wanted.length(); ++i) {
            int ch = rdr.read();
            if (ch == wanted.charAt(i)) continue;
            JsonIO.throwUnexpected(ch);
        }
    }

    private static Number readNumber(Reader rdr, char initial) throws IOException {
        boolean negative = false;
        boolean digitSeen = false;
        int value = 0;
        int ch = initial;
        if (initial == 45) {
            negative = true;
            ch = rdr.read();
        }
        while (true) {
            if (ch >= 48 && ch <= 57) {
                digitSeen = true;
                if (value <= -214748364) {
                    return JsonIO.readLong(rdr, negative, value, ch);
                }
                value *= 10;
                value -= ch - 48;
                rdr.mark(1);
                ch = rdr.read();
                continue;
            }
            if (ch == 46) {
                return JsonIO.readDouble(rdr, negative, value, true);
            }
            if (ch == 101 || ch == 69) {
                double v = negative ? (double)value : -((double)value);
                return JsonIO.readScientific(rdr, v);
            }
            if (digitSeen) {
                rdr.reset();
                if (negative) {
                    return new Integer(value);
                }
                return new Integer(-value);
            }
            JsonIO.throwUnexpected(ch);
        }
    }

    private static Number readLong(Reader rdr, boolean negative, long value, int ch) throws IOException {
        long limit = negative ? Long.MIN_VALUE : -9223372036854775807L;
        limit += LONG_MAX_MSD;
        value *= 10L;
        value -= (long)(ch - 48);
        while (true) {
            rdr.mark(1);
            ch = rdr.read();
            if (ch >= 48 && ch <= 57) {
                if (value < -922337203685477580L) {
                    rdr.reset();
                    return JsonIO.readDouble(rdr, negative, value, false);
                }
                int digit = ch - 48;
                if ((value *= 10L) + LONG_MAX_MSD - (long)digit < limit) {
                    double v = value;
                    return JsonIO.readDouble(rdr, negative, v -= (double)digit, false);
                }
                value -= (long)digit;
                continue;
            }
            if (ch == 46) {
                return JsonIO.readDouble(rdr, negative, value, true);
            }
            if (ch != 101 && ch != 69) break;
            double v = negative ? (double)value : -((double)value);
            JsonIO.readScientific(rdr, v);
        }
        rdr.reset();
        if (negative) {
            if (value >= Integer.MIN_VALUE) {
                return new Integer((int)value);
            }
            return new Long(value);
        }
        if (value >= -2147483647L) {
            return new Integer((int)(-value));
        }
        return new Long(-value);
    }

    private static Number readDouble(Reader rdr, boolean negative, double value, boolean decimalSeen) throws IOException {
        int ch;
        while (!decimalSeen) {
            rdr.mark(1);
            int ch2 = rdr.read();
            if (ch2 >= 48 && ch2 <= 57) {
                value *= 10.0;
                value -= (double)(ch2 - 48);
                continue;
            }
            if (ch2 == 46) {
                decimalSeen = true;
                continue;
            }
            if (ch2 == 101 || ch2 == 69) {
                if (!negative) {
                    value = -value;
                }
                return JsonIO.readScientific(rdr, value);
            }
            rdr.reset();
            if (negative) {
                return new Double(value);
            }
            return new Double(-value);
        }
        double multiplier = 1.0;
        while (true) {
            rdr.mark(1);
            ch = rdr.read();
            if (ch < 48 || ch > 57) break;
            value -= (multiplier /= 10.0) * (double)(ch - 48);
        }
        if (ch == 101 || ch == 69) {
            if (!negative) {
                value = -value;
            }
            return JsonIO.readScientific(rdr, value);
        }
        rdr.reset();
        if (negative) {
            return new Double(value);
        }
        return new Double(-value);
    }

    private static Number readScientific(Reader rdr, double value) throws IOException {
        boolean expNegative = false;
        int ch = rdr.read();
        if (ch == 43) {
            ch = rdr.read();
        } else if (ch == 45) {
            expNegative = true;
            ch = rdr.read();
        }
        if (ch < 48 || ch > 57) {
            JsonIO.throwUnexpected(ch);
        }
        int exp = ch - 48;
        while (true) {
            rdr.mark(1);
            ch = rdr.read();
            if (ch < 48 || ch > 57) break;
            exp *= 10;
            exp += ch - 48;
        }
        rdr.reset();
        if (expNegative) {
            return new Double(value / Math.pow(10.0, exp));
        }
        return new Double(value * Math.pow(10.0, exp));
    }

    private static void throwUnexpected(int ch) throws IOException {
        String str = ch == -1 ? "EOF" : "" + (char)ch;
        throw new IOException("Syntax error in JSON object:  " + str + " unexpected.");
    }
}

