/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.io.binary;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.GrinXHelper;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.ActivatePartCommand;
import com.hdcookbook.grin.commands.ActivateSegmentCommand;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.commands.ResetFeatureCommand;
import com.hdcookbook.grin.commands.SetVisualRCStateCommand;
import com.hdcookbook.grin.features.Assembly;
import com.hdcookbook.grin.features.Box;
import com.hdcookbook.grin.features.Clipped;
import com.hdcookbook.grin.features.Fade;
import com.hdcookbook.grin.features.FixedImage;
import com.hdcookbook.grin.features.Group;
import com.hdcookbook.grin.features.GuaranteeFill;
import com.hdcookbook.grin.features.ImageSequence;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.features.SetTarget;
import com.hdcookbook.grin.features.SrcOver;
import com.hdcookbook.grin.features.Text;
import com.hdcookbook.grin.features.Translator;
import com.hdcookbook.grin.input.CommandRCHandler;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.VisualRCHandler;
import com.hdcookbook.grin.io.binary.DebugInputStream;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class GrinBinaryReader {
    private Show show;
    private Object[] showInArray;
    private Feature[] featureList;
    private RCHandler[] rcHandlerList;
    private Segment[] segmentList;
    private Command[] commandList;
    Hashtable publicSegments = new Hashtable();
    Hashtable publicFeatures = new Hashtable();
    Hashtable publicRCHandlers = new Hashtable();
    private InputStream stream;
    private Class showCommandsClass = null;
    private String[] stringConstants = null;
    private int[][] intArrayConstants = null;
    private Rectangle[] rectangleConstants;
    private Rectangle[][] rectangleArrayConstants;
    private Command[][] commandArrayConstants;
    private GrinXHelper showCommands = null;
    private int extensionStartIndex;
    private Constructor[] extensionConstructors = null;
    boolean debuggable = false;
    private ClassLoader classLoader = null;
    static /* synthetic */ Class class$com$hdcookbook$grin$Show;

    public GrinBinaryReader(InputStream stream) {
        this.stream = new DebugInputStream(stream);
    }

    public GrinBinaryReader(InputStream stream, ClassLoader loader) {
        this(stream);
        this.classLoader = loader;
    }

    Feature getFeatureFromIndex(int index) throws IOException {
        if (index < 0 || index >= this.featureList.length) {
            throw new IOException("non-existing feature reference");
        }
        return this.featureList[index];
    }

    Segment getSegmentFromIndex(int index) throws IOException {
        if (index < 0 || index > this.segmentList.length) {
            throw new IOException("non-existing segment reference");
        }
        return this.segmentList[index];
    }

    RCHandler getRCHandlerFromIndex(int index) throws IOException {
        if (index < 0 || index > this.rcHandlerList.length) {
            throw new IOException("non-existing rchandler reference");
        }
        return this.rcHandlerList[index];
    }

    Command getCommandFromIndex(int index) throws IOException {
        if (index < 0 || index > this.commandList.length) {
            throw new IOException("non-existing command reference " + index);
        }
        return this.commandList[index];
    }

    int[] getIntArrayFromReference(int index) throws IOException {
        if (index < 0 || index > this.intArrayConstants.length) {
            throw new IOException("non-existing int array reference");
        }
        return this.intArrayConstants[index];
    }

    String getStringFromReference(int index) throws IOException {
        if (index < 0 || index > this.stringConstants.length) {
            throw new IOException("wrong string reference ");
        }
        return this.stringConstants[index];
    }

    Rectangle getRectangleFromReference(int index) throws IOException {
        if (index < 0 || index > this.rectangleConstants.length) {
            throw new IOException("bad rectangle reference");
        }
        return this.rectangleConstants[index];
    }

    Rectangle[] getRectangleArrayFromReference(int index) throws IOException {
        if (index < 0 || index > this.rectangleArrayConstants.length) {
            throw new IOException("bad rectangle array reference");
        }
        return this.rectangleArrayConstants[index];
    }

    Command[] getCommandArrayFromReference(int index) throws IOException {
        if (index < 0 || index > this.commandArrayConstants.length) {
            throw new IOException("bad command array reference");
        }
        return this.commandArrayConstants[index];
    }

    private void checkValue(int x, int y, String message) throws IOException {
        if (x != y) {
            throw new IOException("Mismatch: " + message);
        }
    }

    private void checkScriptHeader(DataInputStream in) throws IOException {
        this.checkValue(in.readInt(), -1072910324, "Script identifier");
        int version = in.readInt();
        this.checkValue(version, 27, "Script version mismatch, expects 27, found " + version);
    }

    public void readShow(Show show) throws IOException {
        this.show = show;
        this.showInArray = new Show[]{show};
        GrinDataInputStream in = new GrinDataInputStream(this.stream, this);
        this.checkScriptHeader(in);
        this.stringConstants = this.readStringConstants(in);
        this.intArrayConstants = this.readIntArrayConstants(in);
        this.rectangleConstants = this.readRectangleConstants(in);
        this.rectangleArrayConstants = this.readRectangleArrayConstants(in);
        this.extensionConstructors = this.readExtensionConstructors(in);
        this.readShowCommandsClass(in);
        this.showCommands = this.instantiateShowCommandsCmd();
        this.commandList = new Command[in.readInt()];
        this.readDeclarations(in, this.commandList);
        this.commandArrayConstants = this.readCommandArrayConstants(in);
        int showSegmentStackDepth = in.readInt();
        show.setSegmentStackDepth(showSegmentStackDepth);
        String[] showDrawTargets = in.readStringArray();
        show.setDrawTargets(showDrawTargets);
        String[] stickyImages = in.readStringArray();
        Hashtable publicNamedCommands = this.readPublicNamedCommands(in);
        this.debuggable = in.readBoolean();
        this.featureList = new Feature[in.readInt()];
        this.readDeclarations(in, this.featureList);
        this.rcHandlerList = new RCHandler[in.readInt()];
        this.readDeclarations(in, this.rcHandlerList);
        this.segmentList = new Segment[in.readInt()];
        this.readDeclarations(in, this.segmentList);
        this.readContents(in, this.featureList);
        this.readContents(in, this.rcHandlerList);
        this.readContents(in, this.segmentList);
        this.readContents(in, this.commandList);
        Segment showTop = in.readSegmentReference();
        Group showTopGroup = (Group)in.readFeatureReference();
        String[] fontName = in.readStringArray();
        int[] fontStyleSize = in.readSharedIntArray();
        int xScale = in.readInt();
        int yScale = in.readInt();
        int xOffset = in.readInt();
        int yOffset = in.readInt();
        show.setScale(xScale, yScale, xOffset, yOffset);
        show.buildShow(this.segmentList, this.featureList, this.rcHandlerList, stickyImages, showTop, showTopGroup, this.publicSegments, this.publicFeatures, this.publicRCHandlers, publicNamedCommands, fontName, fontStyleSize);
    }

    private Hashtable readPublicNamedCommands(GrinDataInputStream in) throws IOException {
        int num = in.readInt();
        Hashtable<String, Command> result = new Hashtable<String, Command>(num);
        for (int i = 0; i < num; ++i) {
            String key = in.readString();
            Command value = this.getCommandFromIndex(in.readInt());
            result.put(key, value);
        }
        return result;
    }

    private void readDeclarations(GrinDataInputStream in, Object[] list) throws IOException {
        for (int i = 0; i < list.length; ++i) {
            Node node;
            int identifier = in.readInt();
            switch (identifier) {
                case 0: {
                    node = new Assembly(this.show);
                    break;
                }
                case 1: {
                    node = new Box(this.show);
                    break;
                }
                case 8: {
                    node = new Clipped(this.show);
                    break;
                }
                case 9: {
                    node = new Fade(this.show);
                    break;
                }
                case 2: {
                    node = new FixedImage(this.show);
                    break;
                }
                case 3: {
                    node = new Group(this.show);
                    break;
                }
                case 4: {
                    node = new ImageSequence(this.show);
                    break;
                }
                case 5: {
                    node = new Text(this.show);
                    break;
                }
                case 6: {
                    node = new InterpolatedModel(this.show);
                    break;
                }
                case 7: {
                    node = new Translator(this.show);
                    break;
                }
                case 10: {
                    node = new SrcOver(this.show);
                    break;
                }
                case 18: {
                    node = new GuaranteeFill(this.show);
                    break;
                }
                case 19: {
                    node = new SetTarget(this.show);
                    break;
                }
                case 16: {
                    node = new CommandRCHandler();
                    break;
                }
                case 17: {
                    node = new VisualRCHandler();
                    break;
                }
                case 20: {
                    node = new Segment();
                    break;
                }
                case 11: {
                    node = new ActivatePartCommand(this.show);
                    break;
                }
                case 12: {
                    node = new ActivateSegmentCommand(this.show);
                    break;
                }
                case 13: {
                    node = new ResetFeatureCommand(this.show);
                    break;
                }
                case 14: {
                    node = new GrinXHelper(this.show);
                    break;
                }
                case 15: {
                    node = new SetVisualRCStateCommand(this.show);
                    break;
                }
                case -1: {
                    node = null;
                }
                default: {
                    node = this.instantiateExtension(identifier);
                }
            }
            list[i] = node;
        }
    }

    private Node instantiateExtension(int typeIdentifier) throws IOException {
        if (this.extensionConstructors == null) {
            if (this.showCommands == null) {
                throw new IOException("Missing GrinXHelper subclass for instantiating extensions");
            }
            return this.showCommands.getInstanceOf(this.show, typeIdentifier);
        }
        int i = typeIdentifier - this.extensionStartIndex;
        try {
            return (Node)this.extensionConstructors[i].newInstance(this.showInArray);
        }
        catch (Exception ex) {
            throw new IOException("Error instantiating extension:  " + ex);
        }
    }

    private int[][] readIntArrayConstants(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -31, "Integer array constants identifier");
        int length = in.readInt();
        int[][] array = new int[length][];
        array[0] = null;
        for (int i = 1; i < length; ++i) {
            array[i] = new int[in.readInt()];
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = in.readInt();
            }
        }
        return array;
    }

    private Rectangle[] readRectangleConstants(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -30, "Rectangle constants identifier");
        int length = in.readInt();
        Rectangle[] array = new Rectangle[length];
        array[0] = null;
        for (int i = 1; i < length; ++i) {
            Rectangle r = new Rectangle();
            r.x = in.readInt();
            r.y = in.readInt();
            r.width = in.readInt();
            r.height = in.readInt();
            array[i] = r;
        }
        return array;
    }

    private Rectangle[][] readRectangleArrayConstants(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -29, "Rectangle array constants identifier");
        int length = in.readInt();
        Rectangle[][] array = new Rectangle[length][];
        array[0] = null;
        for (int i = 1; i < length; ++i) {
            Rectangle[] row = new Rectangle[in.readInt()];
            array[i] = row;
            for (int j = 0; j < row.length; ++j) {
                row[j] = this.getRectangleFromReference(in.readInt());
            }
        }
        return array;
    }

    private Command[][] readCommandArrayConstants(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -28, "Command array constants identifier");
        int length = in.readInt();
        Command[][] array = new Command[length][];
        array[0] = null;
        for (int i = 1; i < length; ++i) {
            Command[] row = new Command[in.readInt()];
            array[i] = row;
            for (int j = 0; j < row.length; ++j) {
                row[j] = this.getCommandFromIndex(in.readInt());
            }
        }
        return array;
    }

    private Constructor[] readExtensionConstructors(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -27, "Extension classes identifier");
        this.extensionStartIndex = in.readInt();
        if (this.extensionStartIndex == -1) {
            return null;
        }
        int length = in.readInt();
        Constructor[] result = new Constructor[length];
        Class[] paramTypes = new Class[]{class$com$hdcookbook$grin$Show == null ? (class$com$hdcookbook$grin$Show = GrinBinaryReader.class$("com.hdcookbook.grin.Show")) : class$com$hdcookbook$grin$Show};
        for (int i = 0; i < length; ++i) {
            String name = in.readUTF();
            try {
                Class<?> cl = null;
                cl = this.classLoader == null ? Class.forName(name) : Class.forName(name, true, this.classLoader);
                result[i] = cl.getDeclaredConstructor(paramTypes);
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Extension class " + name + " is missing:  " + ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("Extension class " + name + " missing constructor:  " + ex);
            }
        }
        return result;
    }

    private void readShowCommandsClass(GrinDataInputStream in) throws IOException {
        String className = in.readString();
        if (className == null) {
            return;
        }
        try {
            this.showCommandsClass = this.classLoader == null ? Class.forName(className) : Class.forName(className, true, this.classLoader);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    private void readContents(GrinDataInputStream in, Object[] list) throws IOException {
        for (int i = 0; i < list.length; ++i) {
            Node node = (Node)list[i];
            if (node == null) continue;
            int length = in.readInt();
            ((DebugInputStream)this.stream).pushExpectedLength(length);
            node.readInstanceData(in, length);
            ((DebugInputStream)this.stream).popExpectedLength();
        }
    }

    private String[] readStringConstants(GrinDataInputStream in) throws IOException {
        this.checkValue(in.readByte(), -32, "String array identifier");
        String[] strings = new String[in.readInt()];
        for (int i = 1; i < strings.length; ++i) {
            strings[i] = in.readUTF();
        }
        return strings;
    }

    Command[] getCommandArrayFromIndex(int index) throws IOException {
        if (index < 0 || index > this.commandArrayConstants.length) {
            throw new IOException("non-existing command array reference");
        }
        return this.commandArrayConstants[index];
    }

    private GrinXHelper instantiateShowCommandsCmd() throws IOException {
        GrinXHelper result;
        if (this.showCommandsClass == null) {
            return null;
        }
        Class[] paramType = new Class[]{class$com$hdcookbook$grin$Show == null ? (class$com$hdcookbook$grin$Show = GrinBinaryReader.class$("com.hdcookbook.grin.Show")) : class$com$hdcookbook$grin$Show};
        Object[] param = new Object[]{this.show};
        try {
            result = (GrinXHelper)this.showCommandsClass.getConstructor(paramType).newInstance(param);
        }
        catch (Throwable ex) {
            throw new IOException(ex.toString());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

