/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.AnimationEngine;
import com.hdcookbook.grin.util.Debug;

public abstract class ClockBasedEngine
extends AnimationEngine {
    private static final int MODEL_PERCENT_TIME = 50;
    private boolean paused = true;
    private int newFps = 24000;
    private static int NEW_FPS_SKIP_REQUEST = -1;
    private static int NEW_FPS_SKIPPED = -2;
    private static int INVALID_FPS = -3;
    private byte[] profileWait;
    private byte[] profileModel;

    protected ClockBasedEngine() {
    }

    public synchronized void start() {
        this.paused = false;
        this.notifyAll();
    }

    public synchronized void pause() {
        this.paused = true;
        this.notifyAll();
    }

    public synchronized void setFps(int fps) {
        if (fps <= 0) {
            throw new IllegalArgumentException();
        }
        this.newFps = fps;
        this.notifyAll();
    }

    public synchronized int getFps() {
        if (this.newFps < 0) {
            return 0;
        }
        return this.newFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void skipFrames(int num) throws InterruptedException {
        ClockBasedEngine clockBasedEngine = this;
        synchronized (clockBasedEngine) {
            if (this.newFps == NEW_FPS_SKIP_REQUEST || this.newFps == NEW_FPS_SKIPPED) {
                return;
            }
            int oldNewFps = this.newFps;
            for (int i = 0; i < num; ++i) {
                this.newFps = NEW_FPS_SKIP_REQUEST;
                this.notifyAll();
                while (this.newFps == NEW_FPS_SKIP_REQUEST) {
                    if (this.destroyRequested()) {
                        return;
                    }
                    this.wait();
                }
                if (this.newFps == NEW_FPS_SKIPPED) continue;
                return;
            }
            this.newFps = oldNewFps;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runAnimationLoop() throws InterruptedException {
        long startFrameTime;
        long nextFrameTime = startFrameTime = System.currentTimeMillis();
        int fps = this.newFps;
        int maxModelTime = 500500 / fps;
        int frame = 0;
        int startFrame = 0;
        int skippedFrames = 0;
        boolean wasPaused = false;
        boolean modelOnProbation = false;
        this.modelTimeSkipped = 0;
        while (true) {
            long currTime;
            block17: {
                this.checkNewClients();
                ClockBasedEngine clockBasedEngine = this;
                synchronized (clockBasedEngine) {
                    if (this.destroyRequested()) {
                        return;
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.paused && this.newFps != NEW_FPS_SKIP_REQUEST) {
                        wasPaused = true;
                        this.wait();
                        continue;
                    }
                    if (frame == Integer.MAX_VALUE) {
                        startFrameTime = nextFrameTime;
                        startFrame += frame;
                        frame = 0;
                        continue;
                    }
                    if (wasPaused || this.newFps != fps) {
                        startFrameTime = System.currentTimeMillis();
                        startFrame += frame;
                        if (this.newFps == NEW_FPS_SKIP_REQUEST) {
                            this.newFps = NEW_FPS_SKIPPED;
                            this.notifyAll();
                            while (this.newFps == NEW_FPS_SKIPPED) {
                                this.wait();
                            }
                            fps = INVALID_FPS;
                            currTime = this.newFps == NEW_FPS_SKIP_REQUEST ? Long.MAX_VALUE : 0x7FFFFFFFFFFFFFFEL;
                            break block17;
                        } else {
                            wasPaused = false;
                            fps = this.newFps;
                            maxModelTime = 500500 / fps;
                            frame = 0;
                            nextFrameTime = startFrameTime;
                            continue;
                        }
                    }
                    currTime = System.currentTimeMillis();
                    if (currTime < nextFrameTime) {
                        this.wait(nextFrameTime - currTime);
                        continue;
                    }
                }
            }
            this.advanceModel();
            this.modelTimeSkipped = 0;
            nextFrameTime = fps <= 0 ? Long.MAX_VALUE : startFrameTime + (long)(++frame) * 1000L * 1001L / (long)fps;
            if (frame % 100 == 0) {
                Debug.println("Frame " + (frame + startFrame) + ", " + skippedFrames + " skipped.");
            }
            if (currTime < nextFrameTime) {
                this.showFrame();
                modelOnProbation = false;
                continue;
            }
            long modelTime = System.currentTimeMillis() - currTime;
            if (modelTime <= (long)maxModelTime) {
                ++skippedFrames;
                continue;
            }
            Debug.println("    (Model update ran long:  " + modelTime + " ms.)");
            if (!modelOnProbation) {
                modelOnProbation = true;
                ++skippedFrames;
                continue;
            }
            if (currTime >= 0x7FFFFFFFFFFFFFFEL) {
                Debug.assertFail();
            }
            this.showFrame();
            currTime = System.currentTimeMillis();
            this.modelTimeSkipped = (int)(currTime - nextFrameTime);
            nextFrameTime = currTime;
            Debug.println("WARNING:  Animation f/w detects slow model; delaying animation by " + this.modelTimeSkipped + " ms.");
            startFrameTime = nextFrameTime - (long)frame * 1000L * 1001L / (long)fps;
        }
    }
}

