/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class Profile {
    public static final byte TIMER_START = 0;
    public static final byte TIMER_STOP = 1;
    public static final byte MESSAGE = 2;
    private static DatagramSocket socket = null;
    private static DatagramPacket packet;
    private static byte[] stopBuf;
    private static int token;
    public static final byte TID_ANIMATION = -1;
    public static final byte TID_SETUP = -2;

    private Profile() {
    }

    public static void initProfiler(int port, String host) {
        Debug.println("***  Profiling data being sent to host " + host + " port " + port);
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
            socket = new DatagramSocket();
            packet = new DatagramPacket(stopBuf, stopBuf.length, addr, port);
        }
        catch (IOException e2) {
            Debug.printStackTrace(e2);
            socket = null;
        }
    }

    public static void initTokenStart(int tokenStart) {
        if (tokenStart < token) {
            Debug.assertFail("Illegal token start value " + tokenStart + " < " + token);
        }
        token = tokenStart;
    }

    public static byte[] makeProfileTimer(String description) {
        byte[] utf8Buf = null;
        try {
            utf8Buf = description.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Debug.printStackTrace(e2);
        }
        byte[] retBuf = new byte[utf8Buf.length + 6];
        System.arraycopy(utf8Buf, 0, retBuf, 6, utf8Buf.length);
        utf8Buf = null;
        return retBuf;
    }

    public static byte[] makeMessage(String message) {
        byte[] utf8Buf = null;
        try {
            utf8Buf = message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Debug.printStackTrace(e2);
        }
        byte[] retBuf = new byte[utf8Buf.length + 1];
        System.arraycopy(utf8Buf, 0, retBuf, 1, utf8Buf.length);
        utf8Buf = null;
        return retBuf;
    }

    public static synchronized void doneProfiling() {
        if (socket != null) {
            socket.close();
        }
        socket = null;
    }

    public static synchronized int startTimer(byte[] startBuf, byte threadID) {
        ++token;
        DatagramSocket sock = socket;
        if (sock != null) {
            startBuf[0] = 0;
            startBuf[1] = (byte)(token >> 24 & 0xFF);
            startBuf[2] = (byte)(token >> 16 & 0xFF);
            startBuf[3] = (byte)(token >> 8 & 0xFF);
            startBuf[4] = (byte)(token & 0xFF);
            startBuf[5] = threadID;
            try {
                packet.setData(startBuf);
                sock.send(packet);
            }
            catch (IOException e2) {
                Debug.printStackTrace(e2);
            }
        }
        return token;
    }

    public static synchronized void stopTimer(int tk) {
        DatagramSocket sock = socket;
        if (sock != null) {
            Profile.stopBuf[0] = 1;
            Profile.stopBuf[1] = (byte)(tk >> 24 & 0xFF);
            Profile.stopBuf[2] = (byte)(tk >> 16 & 0xFF);
            Profile.stopBuf[3] = (byte)(tk >> 8 & 0xFF);
            Profile.stopBuf[4] = (byte)(tk & 0xFF);
            try {
                packet.setData(stopBuf);
                sock.send(packet);
            }
            catch (IOException e2) {
                Debug.printStackTrace(e2);
            }
        }
    }

    public static synchronized void sendMessage(byte[] buf) {
        DatagramSocket sock = socket;
        if (sock != null) {
            buf[0] = 2;
            try {
                packet.setData(buf);
                sock.send(packet);
            }
            catch (IOException e2) {
                Debug.printStackTrace(e2);
            }
        }
    }

    static {
        stopBuf = new byte[5];
        token = 0;
    }
}

