/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.io.binary;

import com.hdcookbook.grin.util.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

class DebugInputStream
extends InputStream {
    private Stack positionStack;
    private int pos = 0;
    private InputStream src;

    DebugInputStream(InputStream src) {
        this.src = src;
        this.positionStack = new Stack();
    }

    public int read() throws IOException {
        int result = this.src.read();
        if (result >= 0) {
            ++this.pos;
        }
        return result;
    }

    public void close() throws IOException {
        if (!this.positionStack.empty()) {
            Debug.assertFail("positionStack has extra " + this.positionStack.size() + " elements.");
        }
        this.src.close();
    }

    public void pushExpectedLength(int len) {
        this.positionStack.push(new Integer(len + this.pos));
    }

    public void popExpectedLength() {
        Integer popped = (Integer)this.positionStack.pop();
        if (popped != this.pos) {
            Debug.assertFail("Expected " + popped + " got " + this.pos);
        }
    }
}

