/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.SetupClient;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashMap;

public class Text
extends Feature
implements Node,
SetupClient {
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BASELINE = 8;
    public static final int BOTTOM = 12;
    protected int alignment;
    protected int xArg;
    protected int yArg;
    protected String[] strings;
    protected int vspace;
    protected int fontIndex;
    protected Color[] colors;
    private Color currColor = null;
    private Color lastColor = null;
    protected int loopCount;
    protected Color background;
    private boolean isActivated = false;
    private Object setupMonitor = new Object();
    private boolean needsSetup = true;
    private int alignedX;
    private int alignedY;
    private int ascent;
    private int descent;
    private int width = -1;
    private int height = -1;
    private int colorIndex;
    private int loopsRemaining;
    private boolean changed = false;
    private DrawRecord drawRecord = new DrawRecord();

    public Text(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.width == -1 || this.isActivated) {
            throw new IllegalStateException();
        }
        Text result = new Text(this.show);
        result.alignment = this.alignment;
        result.xArg = this.xArg;
        result.yArg = this.yArg;
        result.strings = this.strings;
        result.vspace = this.vspace;
        result.fontIndex = this.fontIndex;
        result.colors = this.colors;
        result.currColor = this.currColor;
        result.lastColor = this.lastColor;
        result.loopCount = this.loopCount;
        result.background = this.background;
        result.alignedX = this.alignedX;
        result.alignedY = this.alignedY;
        result.ascent = this.ascent;
        result.descent = this.descent;
        result.width = this.width;
        result.height = this.height;
        result.colorIndex = this.colorIndex;
        result.loopsRemaining = this.loopsRemaining;
        result.changed = this.changed;
        result.needsSetup = this.needsSetup;
        return result;
    }

    public int getX() {
        return this.alignedX;
    }

    public int getY() {
        return this.alignedY;
    }

    public void initialize() {
    }

    public Font getFont() {
        return this.show.getFont(this.fontIndex);
    }

    private void calculateMetrics() {
        Font font = this.show.getFont(this.fontIndex);
        this.changed = true;
        FontMetrics fm = this.show.component.getFontMetrics(font);
        int width = 0;
        for (int i = 0; i < this.strings.length; ++i) {
            int w = fm.stringWidth(this.strings[i]);
            if (w <= width) continue;
            width = w;
        }
        this.ascent = fm.getMaxAscent();
        this.descent = fm.getMaxDescent();
        this.height = this.vspace * (this.strings.length - 1) + this.strings.length * (this.ascent + this.descent + 1);
        int a2 = this.alignment & 3;
        this.alignedX = a2 == 2 ? this.xArg - width / 2 : (a2 == 3 ? this.xArg - width : this.xArg);
        a2 = this.alignment & 0xC;
        this.alignedY = a2 == 8 ? this.yArg - this.ascent : (a2 == 12 ? this.yArg - this.height : this.yArg);
        this.width = width;
    }

    public String[] getText() {
        return this.strings;
    }

    public int getLineHeight() {
        return this.vspace + this.ascent + this.descent + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String[] newText) {
        Show show = this.show;
        synchronized (show) {
            this.strings = newText;
            Object object = this.setupMonitor;
            synchronized (object) {
                if (!this.needsSetup) {
                    this.calculateMetrics();
                }
            }
        }
    }

    public void destroy() {
    }

    protected void setActivateMode(boolean mode) {
        this.isActivated = mode;
        if (mode) {
            this.colorIndex = 0;
            this.lastColor = null;
            this.currColor = this.colors[this.colorIndex];
            this.loopsRemaining = this.loopCount;
        }
    }

    protected int setSetupMode(boolean mode) {
        if (mode && this.width == -1) {
            this.needsSetup = true;
            this.show.setupManager.scheduleSetup(this);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSomeSetup() {
        Object object = this.setupMonitor;
        synchronized (object) {
            if (!this.isSetup()) {
                return;
            }
            if (this.width == -1) {
                this.calculateMetrics();
            }
            if (!this.isSetup()) {
                return;
            }
            this.needsSetup = false;
        }
        this.sendFeatureSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsMoreSetup() {
        Object object = this.setupMonitor;
        synchronized (object) {
            return this.needsSetup;
        }
    }

    public void nextFrame() {
        ++this.colorIndex;
        if (this.colorIndex >= this.colors.length) {
            if (this.loopCount != Integer.MAX_VALUE) {
                --this.loopsRemaining;
            }
            if (this.loopsRemaining > 0) {
                this.colorIndex = 0;
            } else {
                this.loopsRemaining = this.loopCount;
                this.colorIndex = this.colors.length - 1;
            }
        }
        this.currColor = this.colors[this.colorIndex];
    }

    public void markDisplayAreasChanged() {
        this.drawRecord.setChanged();
    }

    public void addDisplayAreas(RenderContext context) {
        this.drawRecord.setArea(this.alignedX, this.alignedY, this.width, this.height);
        if (this.lastColor != this.currColor || this.changed) {
            this.drawRecord.setChanged();
        }
        this.drawRecord.setSemiTransparent();
        context.addArea(this.drawRecord);
        this.lastColor = this.currColor;
        this.changed = false;
    }

    public void paintFrame(Graphics2D gr) {
        if (!this.isActivated) {
            return;
        }
        if (this.background != null) {
            gr.setColor(this.background);
            gr.fillRect(this.alignedX, this.alignedY, this.width, this.height);
        }
        gr.setFont(this.show.getFont(this.fontIndex));
        gr.setColor(this.currColor);
        int y2 = this.alignedY + this.ascent;
        for (int i = 0; i < this.strings.length; ++i) {
            gr.drawString(this.strings[i], this.alignedX, y2);
            y2 += this.ascent + this.descent + this.vspace;
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.xArg = in.readInt();
        this.yArg = in.readInt();
        this.alignment = in.readInt();
        this.strings = in.readStringArray();
        this.vspace = in.readInt();
        this.fontIndex = in.readInt();
        this.colors = new Color[in.readInt()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = in.readColor();
        }
        this.loopCount = in.readInt();
        this.background = in.readColor();
    }
}

