/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.Modifier;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashMap;

public class Fade
extends Modifier
implements Node {
    private AlphaComposite[] alphas;
    private AlphaComposite opaqueAlpha = null;
    protected int[] keyframes;
    protected int[] keyAlphas;
    protected boolean srcOver;
    protected int repeatFrame;
    private int alphaIndex;
    protected int loopCount;
    private int loopsRemaining;
    protected Command[] endCommands;
    private AlphaComposite currAlpha;
    private AlphaComposite lastAlpha;
    private ChildContext childContext = new ChildContext();

    public Fade(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (this.activated || this.alphas == null) {
            throw new IllegalStateException();
        }
        Fade result = new Fade(this.show);
        result.part = this.part.makeNewClone(clones);
        result.alphas = this.alphas;
        result.opaqueAlpha = this.opaqueAlpha;
        result.srcOver = this.srcOver;
        result.repeatFrame = this.repeatFrame;
        result.alphaIndex = this.alphaIndex;
        result.loopCount = this.loopCount;
        result.loopsRemaining = this.loopsRemaining;
        result.currAlpha = this.currAlpha;
        result.lastAlpha = this.lastAlpha;
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        Fade other = (Fade)original;
        this.endCommands = Feature.cloneCommands(other.endCommands, clones);
    }

    public void initialize() {
        if (this.keyframes.length == 1) {
            AlphaComposite ac = this.show.initializer.getAlpha(this.srcOver, this.keyAlphas[0]);
            this.alphas = new AlphaComposite[]{ac};
        } else {
            this.alphas = new AlphaComposite[this.keyframes[this.keyframes.length - 1] + 1];
            int i = 0;
            for (int f = 0; f < this.alphas.length; ++f) {
                int alpha;
                while (i + 1 < this.keyframes.length && f >= this.keyframes[i + 1]) {
                    ++i;
                }
                if (f == this.keyframes[i]) {
                    alpha = this.keyAlphas[i];
                } else {
                    int dist = this.keyframes[i + 1] - this.keyframes[i];
                    int distNext = this.keyframes[i + 1] - f;
                    int distLast = f - this.keyframes[i];
                    if (distNext < 0 || distLast < 0) {
                        Debug.assertFail();
                    }
                    alpha = (this.keyAlphas[i + 1] * distLast + this.keyAlphas[i] * distNext + dist / 2) / dist;
                }
                this.alphas[f] = this.show.initializer.getAlpha(this.srcOver, alpha);
                if (this.opaqueAlpha != null || alpha != 255) continue;
                this.opaqueAlpha = this.alphas[f];
            }
        }
    }

    public final void setAlpha(AlphaComposite ac) {
        if (this.alphas.length != 1) {
            Debug.assertFail();
        }
        this.alphas[0] = ac;
        this.currAlpha = ac;
        this.srcOver = ac.getRule() != 2;
    }

    protected void setActivateMode(boolean mode) {
        super.setActivateMode(mode);
        if (mode) {
            this.alphaIndex = 0;
            this.lastAlpha = null;
            this.currAlpha = this.alphas[this.alphaIndex];
            this.loopsRemaining = this.loopCount;
        }
    }

    public void nextFrame() {
        super.nextFrame();
        if (this.alphaIndex == Integer.MAX_VALUE) {
            return;
        }
        ++this.alphaIndex;
        if (this.alphaIndex == this.alphas.length) {
            if (this.loopCount != Integer.MAX_VALUE) {
                --this.loopsRemaining;
            }
            if (this.loopsRemaining > 0) {
                this.alphaIndex = this.repeatFrame == Integer.MAX_VALUE ? 0 : this.repeatFrame;
            } else {
                this.loopsRemaining = this.loopCount;
                this.show.runCommands(this.endCommands);
                this.alphaIndex = this.repeatFrame;
            }
        }
        if (this.alphaIndex < this.alphas.length) {
            this.currAlpha = this.alphas[this.alphaIndex];
        }
    }

    public void addDisplayAreas(RenderContext context) {
        this.childContext.parent = context;
        super.addDisplayAreas(this.childContext);
        this.lastAlpha = this.currAlpha;
    }

    public void paintFrame(Graphics2D gr) {
        if (this.currAlpha != null) {
            Composite old = gr.getComposite();
            gr.setComposite(this.currAlpha);
            this.part.paintFrame(gr);
            gr.setComposite(old);
        } else {
            this.part.paintFrame(gr);
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.srcOver = in.readBoolean();
        this.keyframes = in.readSharedIntArray();
        this.keyAlphas = in.readSharedIntArray();
        this.repeatFrame = in.readInt();
        this.loopCount = in.readInt();
        this.endCommands = in.readCommands();
    }

    class ChildContext
    extends RenderContext {
        RenderContext parent;
        private int x;
        private int y;
        private int width;
        private int height;

        ChildContext() {
        }

        public void addArea(DrawRecord r) {
            if (Fade.this.srcOver) {
                r.setSemiTransparent();
            }
            if (Fade.this.currAlpha != Fade.this.lastAlpha) {
                r.setChanged();
            }
            this.parent.addArea(r);
        }

        public void guaranteeAreaFilled(DrawRecord r) {
            if (!Fade.this.srcOver || Fade.this.currAlpha == Fade.this.opaqueAlpha || Fade.this.currAlpha == null) {
                this.parent.guaranteeAreaFilled(r);
            }
        }

        public int setTarget(int target) {
            return this.parent.setTarget(target);
        }
    }
}

