/*
 * Decompiled with CFR 0.152.
 */
package com.disc_art_authoring.bdjmenu;

import com.hdcookbook.grin.features.Clipped;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ClipAnimator {
    private Rectangle from;
    private Rectangle to;
    private int frames;
    private ArrayList items;

    public ClipAnimator(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        this.from = rectangle;
        this.to = rectangle2;
        this.frames = n + 1;
        this.items = new ArrayList(n2);
    }

    public void addItem(Clipped clipped) {
        this.items.add(clipped);
    }

    public void initAnimator() {
        this.applyClipping(this.from);
    }

    public void nextFrame() {
        if (this.frames < 0) {
            return;
        }
        if (this.frames <= 1) {
            this.from = this.to;
        } else {
            this.from.x += (this.to.x - this.from.x) / this.frames;
            this.from.y += (this.to.y - this.from.y) / this.frames;
            this.from.height += (this.to.height - this.from.height) / this.frames;
            this.from.width += (this.to.width - this.from.width) / this.frames;
        }
        --this.frames;
        this.applyClipping(this.from);
    }

    public void finalizeAnimator() {
        this.frames = -1;
        this.applyClipping(this.to);
    }

    public void clearAnimator() {
        this.applyClipping(new Rectangle(0, 0, 1920, 1080));
    }

    private void applyClipping(Rectangle rectangle) {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Clipped)this.items.get(i)).changeClipRegion(rectangle);
        }
    }
}

