/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.features.Modifier;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashMap;

public class Translator
extends Modifier
implements Node {
    public static final int X_FIELD = 0;
    public static final int Y_FIELD = 1;
    public static final int OFFSCREEN = Integer.MIN_VALUE;
    protected InterpolatedModel model;
    protected int fx = 0;
    protected int fy = 0;
    protected boolean modelIsRelative;
    private int dx;
    private int dy;
    private int lastDx;
    private int lastDy;
    private DrawRecord drawRecord = new DrawRecord();
    private ChildContext childContext = new ChildContext();

    public Translator(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.activated) {
            throw new IllegalStateException();
        }
        Translator result = new Translator(this.show);
        result.part = this.part.makeNewClone(clones);
        result.fx = this.fx;
        result.fy = this.fy;
        result.modelIsRelative = this.modelIsRelative;
        result.dx = this.dx;
        result.dy = this.dy;
        result.lastDx = this.lastDx;
        result.lastDy = this.lastDy;
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        Translator other = (Translator)original;
        this.model = (InterpolatedModel)Feature.clonedReference(other.model, clones);
    }

    public InterpolatedModel getModel() {
        return this.model;
    }

    public void initialize() {
        super.initialize();
    }

    public void destroy() {
        super.destroy();
    }

    public void nextFrame() {
        if (!this.model.getIsActivated()) {
            Debug.assertFail();
        }
        super.nextFrame();
    }

    public void addDisplayAreas(RenderContext context) {
        this.dx = this.model.getField(0);
        this.dy = this.model.getField(1);
        if (this.dx == Integer.MIN_VALUE || this.dy == Integer.MIN_VALUE) {
            return;
        }
        if (!this.modelIsRelative) {
            this.dx -= this.fx;
            this.dy -= this.fy;
        }
        this.childContext.parent = context;
        this.part.addDisplayAreas(this.childContext);
        this.lastDx = this.dx;
        this.lastDy = this.dy;
    }

    public int getX() {
        int x = this.model.getField(0);
        if (!this.modelIsRelative) {
            x -= this.fx;
        }
        return x += this.part.getX();
    }

    public int getY() {
        int y = this.model.getField(1);
        if (!this.modelIsRelative) {
            y -= this.fy;
        }
        return y += this.part.getY();
    }

    public void paintFrame(Graphics2D gr) {
        if (this.dx == Integer.MIN_VALUE || this.dy == Integer.MIN_VALUE) {
            return;
        }
        gr.translate(this.dx, this.dy);
        this.part.paintFrame(gr);
        gr.translate(-this.dx, -this.dy);
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.fx = in.readInt();
        this.fy = in.readInt();
        this.modelIsRelative = in.readBoolean();
        this.model = (InterpolatedModel)in.readFeatureReference();
    }

    class ChildContext
    extends RenderContext {
        RenderContext parent;

        ChildContext() {
        }

        public void addArea(DrawRecord r) {
            r.applyTranslation(Translator.this.dx, Translator.this.dy);
            if (Translator.this.dx != Translator.this.lastDx || Translator.this.dy != Translator.this.lastDy) {
                r.setChanged();
            }
            this.parent.addArea(r);
        }

        public void guaranteeAreaFilled(DrawRecord r) {
            r.applyTranslation(Translator.this.dx, Translator.this.dy);
            this.parent.guaranteeAreaFilled(r);
        }

        public int setTarget(int target) {
            return this.parent.setTarget(target);
        }
    }
}

