/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ManagedImage;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class ManagedFullImage
extends ManagedImage
implements ImageObserver {
    private String name;
    private URL url = null;
    private int numReferences = 0;
    private int numPrepares = 0;
    Image image = null;
    private boolean loaded = false;
    private int width = 0;
    private int height = 0;

    ManagedFullImage(String name) {
        this.name = name;
    }

    ManagedFullImage(String name, URL url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    synchronized void addReference() {
        ++this.numReferences;
    }

    synchronized void removeReference() {
        --this.numReferences;
    }

    synchronized boolean isReferenced() {
        return this.numReferences > 0;
    }

    public synchronized void prepare() {
        ++this.numPrepares;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    public synchronized boolean hadErrorLoading() {
        return this.loaded && this.height == 0 && this.width == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Component comp) {
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            while (!this.loaded && this.numPrepares > 0) {
                if (this.image == null) {
                    this.startLoading(comp);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            return;
        }
    }

    public synchronized void startLoading(Component comp) {
        if (this.image != null || this.numPrepares <= 0) {
            return;
        }
        this.image = this.url == null ? AssetFinder.loadImage(this.name) : Toolkit.getDefaultToolkit().createImage(this.url);
        Thread.currentThread();
        Thread.yield();
        comp.prepareImage(this.image, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            if (img != this.image) {
                img.flush();
                return false;
            }
            if ((infoflags & 0xC0) != 0) {
                Debug.println("Error loading image " + this);
                this.loaded = true;
                this.width = 0;
                this.height = 0;
                this.notifyAll();
            } else if ((infoflags & 0x20) != 0) {
                this.loaded = true;
                this.width = width;
                this.height = height;
                this.notifyAll();
            } else {
                return true;
            }
        }
        AssetFinder.notifyLoaded(this);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare() {
        int w = 0;
        int h = 0;
        ManagedFullImage managedFullImage = this;
        synchronized (managedFullImage) {
            --this.numPrepares;
            if (this.numPrepares > 0) {
                return;
            }
            if (this.image != null) {
                w = this.width;
                h = this.height;
                this.width = 0;
                this.height = 0;
                this.image.flush();
                this.image = null;
            }
            if (!this.loaded) {
                return;
            }
            this.loaded = false;
        }
        AssetFinder.notifyUnloaded(this, w, h);
    }

    public void draw(Graphics2D gr, int x, int y, Component comp) {
        if (this.width > 0) {
            gr.drawImage(this.image, x, y, comp);
        }
    }

    public void drawScaled(Graphics2D gr, Rectangle bounds, Component comp) {
        if (this.width > 0) {
            gr.drawImage(this.image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, 0, this.width, this.height, comp);
        }
    }

    public void drawClipped(Graphics2D gr, int x, int y, Rectangle subsection, Component comp) {
        if (this.width > 0) {
            gr.drawImage(this.image, x, y, x + subsection.width, y + subsection.height, subsection.x, subsection.y, subsection.x + subsection.width, subsection.y + subsection.height, comp);
        }
    }

    void destroy() {
        Image im;
        if (this.loaded) {
            Debug.println("Warning:  Destroying loaded image " + this + ".");
            Debug.println("          unprepare() should always be called before ungetImage().");
        }
        if ((im = this.image) != null) {
            im.flush();
        }
    }
}

