/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.ClockBasedEngine;
import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class DirectDrawEngine
extends ClockBasedEngine {
    private Container container;
    private Component ddComponent;
    private Image buffer;
    private Graphics2D bufferG;
    private Graphics2D componentG;
    private byte[] profileBlitToFB;
    private int engineNumber = DirectDrawEngine.getNextEngineNumber();
    private static int nextEngineNumber = 0;

    private static synchronized int getNextEngineNumber() {
        return ++nextEngineNumber;
    }

    public String toString() {
        return "DD engine " + this.engineNumber;
    }

    public void initContainer(Container container, Rectangle bounds) {
        this.container = container;
        this.ddComponent = new Component(){

            public void paint(Graphics g) {
                Debug.println("repainting...");
                try {
                    DirectDrawEngine.this.repaintFrame((Graphics2D)g);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this.ddComponent.setBounds(bounds);
        container.add(this.ddComponent);
        this.ddComponent.setVisible(true);
        this.buffer = AssetFinder.createCompatibleImageBuffer(container, bounds.width, bounds.height);
        this.bufferG = AssetFinder.createGraphicsFromImageBuffer(this.buffer);
        this.bufferG.setComposite(AlphaComposite.Src);
        this.bufferG.setColor(transparent);
        this.bufferG.fillRect(0, 0, bounds.width, bounds.height);
        this.componentG = (Graphics2D)this.ddComponent.getGraphics();
        if (this.componentG == null) {
            Debug.assertFail();
        }
        this.componentG.setComposite(AlphaComposite.Src);
    }

    public int getWidth() {
        return this.ddComponent.getWidth();
    }

    public int getHeight() {
        return this.ddComponent.getHeight();
    }

    public Component getComponent() {
        return this.ddComponent;
    }

    protected void clearArea(int x, int y, int width, int height) {
        this.bufferG.setColor(transparent);
        this.bufferG.fillRect(x, y, width, height);
    }

    protected boolean needsFullRedrawInAnimationLoop() {
        return false;
    }

    protected void callPaintTargets() throws InterruptedException {
        this.paintTargets(this.bufferG);
        this.bufferG.setComposite(AlphaComposite.Src);
    }

    protected void finishedFrame() {
        int n = this.renderContext.numDrawTargets;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Rectangle a2 = this.renderContext.drawTargets[i];
                this.componentG.drawImage(this.buffer, a2.x, a2.y, a2.x + a2.width, a2.y + a2.height, a2.x, a2.y, a2.x + a2.width, a2.y + a2.height, null);
            }
            Toolkit.getDefaultToolkit().sync();
        }
        Thread.currentThread();
        Thread.yield();
    }

    protected void terminatingEraseScreen() {
        this.componentG.setColor(transparent);
        this.componentG.fillRect(0, 0, this.getWidth(), this.getHeight());
        Toolkit.getDefaultToolkit().sync();
        this.container.remove(this.ddComponent);
        Image buf = this.buffer;
        this.buffer = null;
        this.bufferG = null;
        AssetFinder.destroyImageBuffer(buf);
    }
}

