/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.ActivateSegmentCommand;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.RCKeyEvent;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Graphics2D;
import java.io.IOException;

public class Segment
implements Node {
    protected String name;
    protected Show show;
    protected Feature[] activeFeatures;
    private boolean[] featureWasActivated;
    protected Feature[] settingUpFeatures;
    protected Command[] onEntryCommands;
    protected boolean nextOnSetupDone;
    protected Command[] nextCommands;
    protected RCHandler[] rcHandlers;
    protected int rcPressedInterest;
    protected int rcReleasedInterest;
    protected int keyTypedInterest;
    private boolean active = false;
    private boolean segmentSetupComplete;
    private ActivateSegmentCommand cmdToActivate;
    private ActivateSegmentCommand cmdToActivatePush;
    private int outstandingSetups;
    private int setupCheckedInSetup;
    private int setupCheckedInActive;

    public String toString() {
        if (this.name == null) {
            return "segment @" + Integer.toHexString(this.hashCode());
        }
        return "segment " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Show getShow() {
        return this.show;
    }

    void setShow(Show show) {
        this.show = show;
    }

    public void initialize() {
        this.featureWasActivated = new boolean[this.activeFeatures.length];
        for (int i = 0; i < this.featureWasActivated.length; ++i) {
            this.featureWasActivated[i] = false;
        }
    }

    synchronized Command getCommandToActivate(boolean push) {
        if (push) {
            if (this.cmdToActivatePush == null) {
                this.cmdToActivatePush = new ActivateSegmentCommand(this.show, true, false);
                this.cmdToActivatePush.setup(this);
            }
            return this.cmdToActivatePush;
        }
        if (this.cmdToActivate == null) {
            this.cmdToActivate = new ActivateSegmentCommand(this.show);
            this.cmdToActivate.setup(this);
        }
        return this.cmdToActivate;
    }

    void activate(Segment lastSegment) {
        int i;
        Debug.println("Going from segment " + lastSegment + " to " + this);
        if (lastSegment == this) {
            return;
        }
        this.active = true;
        this.segmentSetupComplete = false;
        this.outstandingSetups = 0;
        this.setupCheckedInSetup = 0;
        this.setupCheckedInActive = 0;
        this.show.showTopGroup.resetVisiblePartsNoAssert(null);
        for (i = 0; i < this.activeFeatures.length; ++i) {
            int needed = this.activeFeatures[i].setup();
            this.outstandingSetups += needed;
            if (needed > 0 || this.activeFeatures[i].needsMoreSetup()) {
                Debug.println();
                Debug.println("WARNING:  Feature " + this.activeFeatures[i] + " in segment " + this.name + " wasn't set up on time.");
                Debug.println();
            }
            if (this.activeFeatures[i].needsMoreSetup()) continue;
            this.activeFeatures[i].activate();
            this.featureWasActivated[i] = true;
        }
        for (i = 0; i < this.settingUpFeatures.length; ++i) {
            this.outstandingSetups += this.settingUpFeatures[i].setup();
        }
        if (lastSegment != null) {
            lastSegment.deactivate();
        }
        if (this.rcHandlers != null) {
            for (i = 0; i < this.rcHandlers.length; ++i) {
                this.rcHandlers[i].activate(this);
            }
        }
        if (this.onEntryCommands != null) {
            for (i = 0; i < this.onEntryCommands.length; ++i) {
                this.show.runCommand(this.onEntryCommands[i]);
            }
        }
        ++this.outstandingSetups;
        this.runFeatureSetup();
    }

    void deactivate() {
        int i;
        this.active = false;
        for (i = 0; i < this.activeFeatures.length; ++i) {
            if (this.featureWasActivated[i]) {
                this.activeFeatures[i].deactivate();
                this.featureWasActivated[i] = false;
            }
            this.activeFeatures[i].unsetup();
        }
        for (i = 0; i < this.settingUpFeatures.length; ++i) {
            this.settingUpFeatures[i].unsetup();
        }
        this.show.showTopGroup.resetVisiblePartsNoAssert(null);
    }

    void runFeatureSetup() {
        if (this.setupCheckedInActive < this.activeFeatures.length) {
            while (this.setupCheckedInActive < this.activeFeatures.length) {
                if (!this.featureWasActivated[this.setupCheckedInActive] && this.activeFeatures[this.setupCheckedInActive].needsMoreSetup()) {
                    return;
                }
                ++this.setupCheckedInActive;
            }
            for (int i = 0; i < this.activeFeatures.length; ++i) {
                if (this.featureWasActivated[i]) continue;
                this.activeFeatures[i].activate();
                this.featureWasActivated[i] = true;
            }
            if (this != this.show.showTop) {
                this.show.showTopGroup.resetVisiblePartsNoAssert(this.activeFeatures);
            }
        }
        --this.outstandingSetups;
        if (!this.active || this.outstandingSetups > 0 || this.segmentSetupComplete) {
            return;
        }
        while (this.setupCheckedInSetup < this.settingUpFeatures.length) {
            if (this.settingUpFeatures[this.setupCheckedInSetup].needsMoreSetup()) {
                return;
            }
            ++this.setupCheckedInSetup;
        }
        this.segmentSetupComplete = true;
        if (this.nextOnSetupDone || this.activeFeatures.length == 0) {
            this.doSegmentDone();
        }
    }

    void doSegmentDone() {
        if (this.nextCommands != null) {
            for (int i = 0; i < this.nextCommands.length; ++i) {
                this.show.runCommand(this.nextCommands[i]);
            }
        }
    }

    void paintFrame(Graphics2D gr) {
        for (int i = 0; i < this.activeFeatures.length; ++i) {
            this.activeFeatures[i].paintFrame(gr);
        }
    }

    void addDisplayAreas(RenderContext context) {
        for (int i = 0; i < this.activeFeatures.length; ++i) {
            this.activeFeatures[i].addDisplayAreas(context);
        }
    }

    void nextFrameForActiveFeatures() {
        for (int i = 0; i < this.activeFeatures.length; ++i) {
            this.activeFeatures[i].nextFrame();
        }
    }

    void nextFrameForRCHandlers() {
        if (this.rcHandlers != null) {
            for (int i = 0; i < this.rcHandlers.length; ++i) {
                this.rcHandlers[i].nextFrame();
            }
        }
    }

    boolean handleKeyPressed(RCKeyEvent re, Show caller) {
        if (this.rcHandlers == null) {
            return false;
        }
        for (int i = 0; i < this.rcHandlers.length; ++i) {
            if (!this.rcHandlers[i].handleKeyPressed(re, caller)) continue;
            return true;
        }
        return false;
    }

    boolean handleKeyReleased(RCKeyEvent re, Show caller) {
        if (this.rcHandlers == null) {
            return false;
        }
        for (int i = 0; i < this.rcHandlers.length; ++i) {
            if (!this.rcHandlers[i].handleKeyReleased(re, caller)) continue;
            return true;
        }
        return false;
    }

    boolean handleKeyTyped(RCKeyEvent re, Show caller) {
        if (this.rcHandlers == null) {
            return false;
        }
        for (int i = 0; i < this.rcHandlers.length; ++i) {
            if (!this.rcHandlers[i].handleKeyTyped(re, caller)) continue;
            return true;
        }
        return false;
    }

    boolean handleMouse(int x, int y, boolean activate) {
        if (this.rcHandlers == null) {
            return false;
        }
        boolean handled = false;
        for (int i = 0; i < this.rcHandlers.length; ++i) {
            if (!this.rcHandlers[i].handleMouse(x, y, activate)) continue;
            handled = true;
        }
        return handled;
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.activeFeatures = in.readFeaturesArrayReference();
        this.settingUpFeatures = in.readFeaturesArrayReference();
        this.rcHandlers = in.readRCHandlersArrayReference();
        this.onEntryCommands = in.readCommands();
        this.nextOnSetupDone = in.readBoolean();
        this.nextCommands = in.readCommands();
        this.rcPressedInterest = in.readInt();
        this.rcReleasedInterest = in.readInt();
        this.keyTypedInterest = in.readInt();
    }

    public Feature[] getActiveFeatures() {
        return this.activeFeatures;
    }

    public Feature[] getSetupFeatures() {
        return this.settingUpFeatures;
    }

    public Command[] getOnEntryCommands() {
        return this.onEntryCommands;
    }

    public boolean getNextOnSetupDone() {
        return this.nextOnSetupDone;
    }

    public Command[] getNextCommands() {
        return this.nextCommands;
    }

    public RCHandler[] getRCHandlers() {
        return this.rcHandlers;
    }
}

