/*
 * Decompiled with CFR 0.152.
 */
package com.disc_art_authoring.bdjmenu;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyHelper {
    private Properties prop;
    private String propertyFileName;

    public PropertyHelper(String string) {
        this.propertyFileName = string;
        this.prop = new Properties();
    }

    public void clear() {
        this.prop.clear();
    }

    private String getPropertyFile() {
        return System.getProperty("dvb.persistent.root") + this.propertyFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFile() {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(this.getPropertyFile());
            this.prop.load(fileInputStream);
            bl = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getPropertyFile());
            this.prop.store(fileOutputStream, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public String getData(String string) {
        String string2 = this.prop.getProperty(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public int getDataInt(String string, int n) {
        Integer n2;
        String string2 = this.getData(string);
        if (string2.length() == 0) {
            return n;
        }
        try {
            n2 = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2;
    }

    public long getDataLong(String string, long l) {
        Long l2;
        String string2 = this.getData(string);
        if (string2.length() == 0) {
            return l;
        }
        try {
            l2 = new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
        return l2;
    }

    public float getDataFloat(String string, float f) {
        Float f2;
        String string2 = this.getData(string);
        if (string2.length() == 0) {
            return f;
        }
        try {
            f2 = new Float(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
        return f2.floatValue();
    }

    public boolean getDataBoolean(String string, boolean bl) {
        String string2 = this.getData(string);
        if (string2.length() == 0) {
            return bl;
        }
        Boolean bl2 = new Boolean(string2);
        return bl2;
    }

    public void setData(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.prop.setProperty(string, string2);
    }

    public void setData(String string, int n) {
        this.prop.setProperty(string, Integer.toString(n));
    }

    public void setData(String string, long l) {
        this.prop.setProperty(string, Long.toString(l));
    }

    public void setData(String string, float f) {
        this.prop.setProperty(string, Float.toString(f));
    }

    public void setData(String string, boolean bl) {
        this.prop.setProperty(string, Boolean.toString(bl));
    }
}

