/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedImage;
import com.hdcookbook.grin.util.SetupClient;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;

public class FixedImage
extends Feature
implements Node,
SetupClient {
    protected Rectangle placement;
    private boolean placementCopied = false;
    protected String fileName;
    protected InterpolatedModel scalingModel = null;
    protected Rectangle scaledBounds = null;
    protected ManagedImage image;
    private boolean setupMode = false;
    private Object setupMonitor = new Object();
    private boolean imageSetup = false;
    private boolean isActivated = false;
    private boolean imageChanged = false;
    private DrawRecord drawRecord = new DrawRecord();

    public FixedImage(Show show) {
        super(show);
    }

    protected Feature createClone(HashMap clones) {
        if (!this.setupMode || !this.imageSetup || this.isActivated) {
            throw new IllegalStateException();
        }
        FixedImage result = new FixedImage(this.show);
        result.placement = this.placement;
        result.fileName = this.fileName;
        if (this.scaledBounds != null) {
            result.scaledBounds = new Rectangle(this.scaledBounds);
        }
        result.image = this.image;
        ImageManager.getImage(this.image);
        result.image.prepare();
        result.imageSetup = true;
        result.setupMode = true;
        return result;
    }

    protected void initializeClone(Feature original, HashMap clones) {
        super.initializeClone(original, clones);
        FixedImage other = (FixedImage)original;
        this.scalingModel = (InterpolatedModel)Feature.clonedReference(other.scalingModel, clones);
    }

    public void initialize() {
        this.image = ImageManager.getImage(this.fileName);
    }

    public int getX() {
        return this.placement.x;
    }

    public int getY() {
        return this.placement.y;
    }

    public synchronized Rectangle getMutablePlacement() {
        if (!this.placementCopied) {
            this.placement = new Rectangle(this.placement);
            this.placementCopied = true;
        }
        return this.placement;
    }

    public void setImageSizeChanged() {
        this.imageChanged = true;
    }

    public ManagedImage getImage() {
        return this.image;
    }

    public void replaceImage(ManagedImage newImage) {
        if (newImage == this.image) {
            return;
        }
        if (this.setupMode) {
            if (!newImage.isLoaded()) {
                throw new IllegalStateException();
            }
            ImageManager.getImage(newImage);
            newImage.prepare();
            this.image.unprepare();
            ImageManager.ungetImage(this.image);
        } else {
            ImageManager.getImage(newImage);
            ImageManager.ungetImage(this.image);
        }
        this.image = newImage;
        this.fileName = null;
        this.imageChanged = true;
    }

    public void destroy() {
        if (this.setupMode) {
            if (!this.imageSetup) {
                Debug.assertFail();
            }
            this.image.unprepare();
        }
        ImageManager.ungetImage(this.image);
    }

    protected void setActivateMode(boolean mode) {
        this.isActivated = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setSetupMode(boolean mode) {
        Object object = this.setupMonitor;
        synchronized (object) {
            this.setupMode = mode;
            if (this.setupMode) {
                this.image.prepare();
                if (this.image.isLoaded()) {
                    this.imageSetup = true;
                    return 0;
                }
                this.show.setupManager.scheduleSetup(this);
                return 1;
            }
            this.image.unprepare();
            this.imageSetup = false;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSomeSetup() {
        Object object = this.setupMonitor;
        synchronized (object) {
            if (!this.setupMode) {
                return;
            }
        }
        this.image.load(this.show.component);
        object = this.setupMonitor;
        synchronized (object) {
            if (!this.setupMode) {
                return;
            }
            this.imageSetup = true;
        }
        this.sendFeatureSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsMoreSetup() {
        Object object = this.setupMonitor;
        synchronized (object) {
            return this.setupMode && !this.imageSetup;
        }
    }

    public void paintFrame(Graphics2D gr) {
        if (!this.isActivated) {
            return;
        }
        if (this.scalingModel == null) {
            this.image.drawScaled(gr, this.placement, this.show.component);
        } else {
            this.image.drawScaled(gr, this.scaledBounds, this.show.component);
        }
    }

    public void markDisplayAreasChanged() {
        this.drawRecord.setChanged();
    }

    public void addDisplayAreas(RenderContext context) {
        if (this.scalingModel == null) {
            this.drawRecord.setArea(this.placement.x, this.placement.y, this.placement.width, this.placement.height);
        } else {
            boolean changed = this.scalingModel.scaleBounds(this.placement.x, this.placement.y, this.placement.width, this.placement.height, this.scaledBounds);
            this.drawRecord.setArea(this.scaledBounds.x, this.scaledBounds.y, this.scaledBounds.width, this.scaledBounds.height);
            if (changed) {
                this.drawRecord.setChanged();
            }
        }
        if (this.imageChanged) {
            this.drawRecord.setChanged();
            this.imageChanged = false;
        }
        context.addArea(this.drawRecord);
    }

    public void nextFrame() {
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.placement = in.readSharedRectangle();
        this.fileName = in.readString();
        if (in.readBoolean()) {
            this.scalingModel = (InterpolatedModel)in.readFeatureReference();
            this.scaledBounds = new Rectangle();
        }
    }
}

