/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.commands;

import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.io.IOException;

public class ActivateSegmentCommand
extends Command
implements Node {
    protected Segment segment;
    protected boolean push;
    protected boolean pop;

    public ActivateSegmentCommand(Show show, boolean push, boolean pop) {
        super(show);
        this.push = push;
        this.pop = pop;
    }

    public ActivateSegmentCommand(Show show) {
        this(show, false, false);
    }

    public boolean getPush() {
        return this.push;
    }

    public boolean getPop() {
        return this.pop;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public void setup(Segment segment) {
        this.segment = segment;
    }

    public void execute() {
        if (this.push) {
            this.show.pushCurrentSegment();
        }
        Segment seg = this.segment;
        if (this.pop && (seg = this.show.popSegmentStack()) == null) {
            Debug.println("****  Error:  Popping segment stack gets null ***");
        }
        if (seg != null) {
            this.show.doActivateSegment(seg);
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.push = in.readBoolean();
        this.pop = in.readBoolean();
        this.segment = in.readSegmentReference();
    }
}

