/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.RenderContextBase;
import java.awt.Rectangle;

public class DrawRecord {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean changed;
    private boolean opaque;
    private int lastX;
    private int lastY;
    private int lastWidth;
    private int lastHeight;
    DrawRecord prev = null;
    DrawRecord next = null;
    int target;

    public DrawRecord() {
        this.resetPreviousFrame();
    }

    void resetPreviousFrame() {
        this.lastWidth = Integer.MIN_VALUE;
    }

    public void setArea(int x, int y, int width, int height) {
        if (width < 0) {
            width = -width;
            x -= width;
        }
        if (height < 0) {
            height = -height;
            y -= height;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    void finishedFrame() {
        this.changed = false;
        this.opaque = true;
    }

    public void setSemiTransparent() {
        this.opaque = false;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void applyTranslation(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void addClip(int x, int y, int width, int height) {
        if (this.x < x) {
            this.width -= x - this.x;
            this.x = x;
        }
        if (this.y < y) {
            this.height -= y - this.y;
            this.y = y;
        }
        if (this.x + this.width > x + width) {
            this.width = x + width - this.x;
        }
        if (this.y + this.height > y + height) {
            this.height = y + height - this.y;
        }
    }

    void applyGuarantee(Rectangle area) {
        int d2;
        int x1 = this.x;
        int y1 = this.y;
        int x2 = x1 + this.width;
        int y2 = y1 + this.height;
        int ax1 = area.x;
        int ay1 = area.y;
        int ax2 = ax1 + area.width;
        int ay2 = ay1 + area.height;
        if (y1 <= ay1 && y2 >= ay2) {
            if (x1 <= ax1 && x2 > ax1) {
                d2 = x2 - ax1;
                area.x += d2;
                area.width -= d2;
                if (area.width <= 0) {
                    RenderContextBase.setEmpty(area);
                    return;
                }
            }
            if (x2 >= ax2 && x1 < ax2) {
                d2 = ax2 - x1;
                area.width -= d2;
                if (area.width <= 0) {
                    RenderContextBase.setEmpty(area);
                    return;
                }
            }
        }
        if (x1 <= ax1 && x2 >= ax2) {
            if (y1 <= ay1 && y2 > ay1) {
                d2 = y2 - ay1;
                area.y += d2;
                area.height -= d2;
                if (area.height <= 0) {
                    RenderContextBase.setEmpty(area);
                    return;
                }
            }
            if (y2 >= ay2 && y1 < ay2) {
                d2 = ay2 - y1;
                area.height -= d2;
                if (area.height <= 0) {
                    RenderContextBase.setEmpty(area);
                    return;
                }
            }
        }
    }

    void addAreaTo(Rectangle drawTarget) {
        boolean newCoords;
        boolean bl = newCoords = this.x != this.lastX || this.y != this.lastY || this.width != this.lastWidth || this.height != this.lastHeight;
        if (this.lastWidth > 0 && this.lastHeight > 0 && (newCoords || this.changed && !this.opaque)) {
            this.addToRect(drawTarget, this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        }
        if (this.width > 0 && this.height > 0 && (this.lastWidth == Integer.MIN_VALUE || this.changed || newCoords)) {
            this.addToRect(drawTarget, this.x, this.y, this.width, this.height);
        }
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastWidth = this.width;
        this.lastHeight = this.height;
    }

    void eraseLastFrame(Rectangle drawTarget) {
        if (this.lastWidth > 0 && this.lastHeight > 0) {
            this.addToRect(drawTarget, this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        }
    }

    private void addToRect(Rectangle r, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (RenderContextBase.isEmpty(r)) {
            r.setBounds(x, y, width, height);
        } else {
            r.add(x, y);
            r.add(x + width, y + height);
        }
    }
}

