/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ManagedFullImage;
import com.hdcookbook.grin.util.ManagedImage;
import com.hdcookbook.grin.util.ManagedSubImage;
import com.hdcookbook.grin.util.MosaicTile;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class ImageManager {
    private static Hashtable images = new Hashtable();
    private static Hashtable imageMap = null;
    private static Object lock = new Object();

    private ImageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedImage getImage(String name) {
        Object object = lock;
        synchronized (object) {
            ManagedImage im = (ManagedImage)images.get(name);
            if (im == null) {
                if (imageMap != null) {
                    MosaicTile t = (MosaicTile)imageMap.get(name);
                    if (t != null) {
                        im = new ManagedSubImage(name, t.mosaicName, t.placement);
                    } else {
                        Debug.println(name + " not found in image map.");
                    }
                }
                if (im == null) {
                    im = new ManagedFullImage(name);
                }
                images.put(name, im);
            }
            im.addReference();
            return im;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedImage getImage(URL url) {
        String name = url.toExternalForm();
        Object object = lock;
        synchronized (object) {
            ManagedImage im = (ManagedImage)images.get(name);
            if (im == null) {
                im = new ManagedFullImage(name, url);
                images.put(name, im);
            }
            im.addReference();
            return im;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getImage(ManagedImage im) {
        Object object = lock;
        synchronized (object) {
            if (!im.isReferenced()) {
                throw new IllegalStateException();
            }
            im.addReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ungetImage(ManagedImage im) {
        Object object = lock;
        synchronized (object) {
            im.removeReference();
            if (!im.isReferenced()) {
                images.remove(im.getName());
                im.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void readImageMap(String fileName, Hashtable map) throws IOException {
        FilterInputStream dis;
        block11: {
            int i;
            dis = null;
            URL u = AssetFinder.getURL(fileName);
            if (u == null) {
                throw new IOException("No image map " + fileName);
            }
            dis = new DataInputStream(new BufferedInputStream(u.openStream()));
            int n = ((DataInputStream)dis).readInt();
            String[] mosaics = new String[n];
            for (i = 0; i < n; ++i) {
                mosaics[i] = ((DataInputStream)dis).readUTF();
            }
            n = ((DataInputStream)dis).readInt();
            for (i = 0; i < n; ++i) {
                String tileName = ((DataInputStream)dis).readUTF();
                MosaicTile t = new MosaicTile();
                t.mosaicName = mosaics[((DataInputStream)dis).readInt()];
                t.placement = new Rectangle();
                t.placement.x = ((DataInputStream)dis).readInt();
                t.placement.y = ((DataInputStream)dis).readInt();
                t.placement.width = ((DataInputStream)dis).readInt();
                t.placement.height = ((DataInputStream)dis).readInt();
                map.put(tileName, t);
            }
            if (dis.read() == -1) break block11;
            Debug.assertFail();
        }
        Object var10_10 = null;
        if (dis == null) return;
        try {
            dis.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException ex) {
                Debug.printStackTrace(ex);
                Debug.assertFail();
                Object var10_11 = null;
                if (dis == null) return;
                try {
                    dis.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (dis == null) throw throwable;
            try {
                dis.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setImageMap(Hashtable map) {
        Object object = lock;
        synchronized (object) {
            imageMap = map;
        }
    }
}

