/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.DrawRecord;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.util.Debug;
import java.awt.Rectangle;

class RenderContextBase
extends RenderContext {
    private int currTarget = 0;
    Rectangle[] drawTargets;
    int numDrawTargets;
    Rectangle[] eraseTargets;
    private Rectangle collapsed = new Rectangle();
    private DrawRecord thisFrameList = null;
    private DrawRecord guaranteeList = null;
    private DrawRecord guaranteeListLast = null;
    private DrawRecord lastFrameList = new DrawRecord();
    private int collapseThreshold = 148225;
    private boolean targetsCanOverlap;

    RenderContextBase(int numTargets) {
        if (numTargets < 1) {
            numTargets = 1;
        }
        this.drawTargets = this.newRectArray(numTargets);
        this.eraseTargets = this.newRectArray(numTargets);
        this.lastFrameList.prev = this.lastFrameList;
        this.lastFrameList.next = this.lastFrameList;
    }

    private Rectangle[] newRectArray(int n) {
        Rectangle[] r = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            r[i] = new Rectangle();
        }
        return r;
    }

    void setCollapseThreshold(int collapseThreshold) {
        this.collapseThreshold = collapseThreshold;
    }

    void setTargetsCanOverlap(boolean v) {
        this.targetsCanOverlap = v;
    }

    public void addArea(DrawRecord r) {
        if (r.prev != null) {
            r.prev.next = r.next;
            r.next.prev = r.prev;
        } else {
            r.resetPreviousFrame();
        }
        r.target = this.currTarget;
        r.addAreaTo(this.drawTargets[this.currTarget]);
        r.next = this.thisFrameList;
        this.thisFrameList = r;
        r.prev = null;
    }

    public void guaranteeAreaFilled(DrawRecord filled) {
        filled.target = this.currTarget;
        if (filled.prev != null) {
            filled.prev.next = filled.next;
            filled.next.prev = filled.prev;
        }
        if (this.guaranteeList == null) {
            this.guaranteeList = filled;
        } else {
            this.guaranteeListLast.next = filled;
        }
        this.guaranteeListLast = filled;
        filled.next = null;
        filled.prev = null;
    }

    public int setTarget(int newTarget) {
        int old = this.currTarget;
        this.currTarget = newTarget;
        return old;
    }

    void setEmpty() {
        for (int i = 0; i < this.drawTargets.length; ++i) {
            this.drawTargets[i].width = 0;
            this.eraseTargets[i].width = 0;
        }
    }

    void setFullPaint(int x, int y, int width, int height) {
        this.drawTargets[0].setBounds(x, y, width, height);
    }

    void processLastFrameRecords() {
        DrawRecord n = this.lastFrameList.prev;
        while (n != this.lastFrameList) {
            n.eraseLastFrame(this.drawTargets[n.target]);
            DrawRecord tmp = n;
            n = n.prev;
            tmp.prev = null;
            tmp.next = null;
        }
        this.lastFrameList.next = this.thisFrameList;
        this.thisFrameList = null;
        n = this.lastFrameList.next;
        DrawRecord prev = this.lastFrameList;
        while (n != null) {
            n.finishedFrame();
            n.prev = prev;
            prev = n;
            n = n.next;
        }
        prev.next = this.lastFrameList;
        this.lastFrameList.prev = prev;
    }

    void resetLastFrameList() {
        if (this.thisFrameList != null) {
            Debug.assertFail();
        }
        DrawRecord n = this.lastFrameList.next;
        while (n != this.lastFrameList) {
            n.resetPreviousFrame();
            DrawRecord tmp = n.next;
            n.next = null;
            n.prev = null;
            n = tmp;
        }
        this.lastFrameList.next = this.lastFrameList;
        this.lastFrameList.prev = this.lastFrameList;
    }

    static void setEmpty(Rectangle r) {
        r.width = 0;
        r.height = 0;
    }

    static boolean isEmpty(Rectangle r) {
        return r.width <= 0;
    }

    void collapseTargets() {
        this.numDrawTargets = this.collapseTargets(this.drawTargets);
    }

    private int collapseTargets(Rectangle[] targets) {
        int i;
        int n = this.purgeEmpty(targets, targets.length) - 1;
        for (i = 0; i < n; ++i) {
            if (!RenderContextBase.isEmpty(targets[i])) continue;
            Debug.assertFail();
        }
        while (true) {
            block2: for (i = 0; i < n; ++i) {
                for (int j = i + 1; j <= n; ++j) {
                    boolean combine;
                    this.collapsed.setBounds(targets[i]);
                    this.collapsed.add(targets[j]);
                    boolean bl = combine = !this.targetsCanOverlap && targets[i].intersects(targets[j]);
                    if (!combine) {
                        int ac = this.collapsed.width * this.collapsed.height;
                        int a2 = targets[i].width * targets[i].height + targets[j].width * targets[j].height;
                        boolean bl2 = combine = ac <= a2 + this.collapseThreshold;
                    }
                    if (!combine) continue;
                    targets[i].setBounds(this.collapsed);
                    if (j < n) {
                        Rectangle ra = targets[j];
                        targets[j] = targets[n];
                        targets[n] = ra;
                    }
                    RenderContextBase.setEmpty(targets[n]);
                    --n;
                    continue block2;
                }
            }
            break;
        }
        return n + 1;
    }

    private int purgeEmpty(Rectangle[] targets, int num) {
        int n;
        for (n = num - 1; n >= 0 && RenderContextBase.isEmpty(targets[n]); --n) {
        }
        int i = 0;
        while (i < n) {
            if (RenderContextBase.isEmpty(targets[i])) {
                Rectangle a2 = targets[n];
                targets[n] = targets[i];
                targets[i] = a2;
                --n;
                continue;
            }
            ++i;
        }
        return n + 1;
    }

    void calculateEraseTargets() {
        int i;
        for (i = 0; i < this.numDrawTargets; ++i) {
            this.eraseTargets[i].setBounds(this.drawTargets[i]);
        }
        while (this.guaranteeList != null) {
            for (i = 0; i < this.numDrawTargets; ++i) {
                Rectangle area = this.eraseTargets[i];
                if (RenderContextBase.isEmpty(area)) continue;
                this.guaranteeList.applyGuarantee(area);
            }
            this.guaranteeList = this.guaranteeList.next;
        }
        this.guaranteeListLast = null;
    }
}

