/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.animator;

import com.hdcookbook.grin.animator.AnimationClient;
import com.hdcookbook.grin.animator.AnimationContext;
import com.hdcookbook.grin.animator.RenderContextBase;
import com.hdcookbook.grin.util.Debug;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Hashtable;

public abstract class AnimationEngine
implements Runnable {
    public static final Color transparent = new Color(0, 0, 0, 0);
    protected RenderContextBase renderContext;
    protected Rectangle repaintBounds = null;
    private AnimationClient[] clients;
    private AnimationClient[] newClients;
    private Thread worker;
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPING = 2;
    private static final int STATE_STOPPED = 3;
    private int state = 0;
    private Object repaintLock = new Object();
    private AnimationContext context;
    private Rectangle lastClip = new Rectangle();
    private boolean needsFullPaint = true;
    protected int modelTimeSkipped = 0;
    private byte[] profileDamageCalc;
    private byte[] profileErase;
    private byte[] profileDraw;
    private int drawTargetCollapseThreshold = Integer.MIN_VALUE;
    protected boolean targetsCanOverlap = false;

    protected AnimationEngine() {
        this.worker = new Thread((Runnable)this, "Animation " + this);
        this.worker.setPriority(4);
    }

    public synchronized void initClients(AnimationClient[] clients) {
        if (this.clients != null) {
            Debug.assertFail();
        }
        this.doInitClients(clients);
    }

    private synchronized void doInitClients(AnimationClient[] clients) {
        this.clients = clients;
        Hashtable<String, Integer> targets = new Hashtable<String, Integer>();
        int num = 0;
        for (int i = 0; i < clients.length; ++i) {
            String[] ts = clients[i].getDrawTargets();
            for (int j = 0; j < ts.length; ++j) {
                if (targets.get(ts[j]) != null) continue;
                targets.put(ts[j], new Integer(num++));
            }
            clients[i].mapDrawTargets(targets);
        }
        this.renderContext = new RenderContextBase(targets.size());
        if (this.drawTargetCollapseThreshold != Integer.MIN_VALUE) {
            this.renderContext.setCollapseThreshold(this.drawTargetCollapseThreshold);
        }
        this.renderContext.setTargetsCanOverlap(this.targetsCanOverlap);
    }

    public synchronized void setDrawTargetCollapseThreshold(int t) {
        if (t == Integer.MIN_VALUE) {
            t = -2147483647;
        }
        this.drawTargetCollapseThreshold = t;
        if (this.renderContext != null) {
            this.renderContext.setCollapseThreshold(t);
        }
    }

    public synchronized void setAllowOverlappingTargets(boolean v) {
        this.targetsCanOverlap = v;
        if (this.renderContext != null) {
            this.renderContext.setTargetsCanOverlap(this.targetsCanOverlap);
        }
    }

    public synchronized void resetAnimationClients(AnimationClient[] clients) {
        this.newClients = clients;
    }

    public synchronized AnimationClient[] getAnimationClients() {
        AnimationClient[] src = this.newClients == null ? this.clients : this.newClients;
        AnimationClient[] result = new AnimationClient[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = src[i];
        }
        return result;
    }

    public void setThreadPriority(int priority) {
        this.worker.setPriority(priority);
    }

    public abstract void initContainer(Container var1, Rectangle var2);

    public abstract int getWidth();

    public abstract int getHeight();

    protected int getNumEraseTargets() {
        return this.renderContext.numDrawTargets;
    }

    protected Rectangle[] getEraseTargets() {
        return this.renderContext.eraseTargets;
    }

    protected int getNumDrawTargets() {
        return this.renderContext.numDrawTargets;
    }

    protected Rectangle[] getDrawTargets() {
        return this.renderContext.drawTargets;
    }

    private synchronized void setState(int s) {
        this.state = s;
        this.notifyAll();
        Debug.println("****  Animation " + this + " state set to " + s);
    }

    public synchronized boolean destroyRequested() {
        return this.state != 1 && this.state != 0;
    }

    public void checkDestroy() throws InterruptedException {
        if (Thread.interrupted() || this.destroyRequested()) {
            throw new InterruptedException();
        }
    }

    public abstract Component getComponent();

    public synchronized void paintNextFrameFully() {
        this.needsFullPaint = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(AnimationContext context) {
        AnimationEngine animationEngine = this;
        synchronized (animationEngine) {
            if (this.state != 0) {
                Debug.assertFail("Illegal state " + this.state + " in " + this);
            }
        }
        this.context = context;
        this.worker.start();
        animationEngine = this;
        synchronized (animationEngine) {
            try {
                while (this.state == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public abstract void start();

    public abstract void pause();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        AnimationEngine animationEngine = this;
        synchronized (animationEngine) {
            if (this.state == 3) {
                return;
            }
            if (this.state != 1) {
                Debug.assertFail();
            }
            this.setState(2);
            try {
                while (this.state != 3) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract void clearArea(int var1, int var2, int var3, int var4);

    protected abstract boolean needsFullRedrawInAnimationLoop();

    protected abstract void callPaintTargets() throws InterruptedException;

    protected abstract void finishedFrame();

    protected abstract void terminatingEraseScreen();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block30: {
            block28: {
                this.setState(1);
                this.context.animationInitialize();
                AnimationEngine animationEngine = this;
                synchronized (animationEngine) {
                    if (this.getComponent() == null) {
                        Debug.assertFail("initContainer() not called");
                    }
                    if (this.clients == null) {
                        Debug.assertFail("initClients() not called");
                    }
                }
                for (int i = 0; i < this.clients.length; ++i) {
                    this.clients[i].initialize(this.getComponent());
                }
                this.context.animationFinishInitialization();
                this.runAnimationLoop();
                Object var4_6 = null;
                AnimationClient[] c2 = this.clients;
                if (c2 == null) break block28;
                for (int i = 0; i < c2.length; ++i) {
                    try {
                        Debug.println("Destroying animation client " + i);
                        c2[i].destroy();
                        Debug.println("Destroyed animation client " + i);
                        continue;
                    }
                    catch (Throwable t2) {
                        Debug.println(this);
                        Debug.printStackTrace(t2);
                        Debug.println("****  Exception in destroy:  " + t2);
                    }
                }
            }
            try {
                this.terminatingEraseScreen();
            }
            catch (Throwable t3) {
                Debug.printStackTrace(t3);
                Debug.println("****  Exception in destroy:  " + t3);
            }
            this.setState(3);
            {
                break block30;
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    Object var4_7 = null;
                    AnimationClient[] c2 = this.clients;
                    if (c2 != null) {
                        for (int i = 0; i < c2.length; ++i) {
                            try {
                                Debug.println("Destroying animation client " + i);
                                c2[i].destroy();
                                Debug.println("Destroyed animation client " + i);
                                continue;
                            }
                            catch (Throwable t2) {
                                Debug.println(this);
                                Debug.printStackTrace(t2);
                                Debug.println("****  Exception in destroy:  " + t2);
                            }
                        }
                    }
                    try {
                        this.terminatingEraseScreen();
                    }
                    catch (Throwable t3) {
                        Debug.printStackTrace(t3);
                        Debug.println("****  Exception in destroy:  " + t3);
                    }
                    this.setState(3);
                    break block30;
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                    Debug.println("****  Exception in animation thread:  " + t);
                    Object var4_8 = null;
                    AnimationClient[] c2 = this.clients;
                    if (c2 != null) {
                        for (int i = 0; i < c2.length; ++i) {
                            try {
                                Debug.println("Destroying animation client " + i);
                                c2[i].destroy();
                                Debug.println("Destroyed animation client " + i);
                                continue;
                            }
                            catch (Throwable t2) {
                                Debug.println(this);
                                Debug.printStackTrace(t2);
                                Debug.println("****  Exception in destroy:  " + t2);
                            }
                        }
                    }
                    try {
                        this.terminatingEraseScreen();
                    }
                    catch (Throwable t3) {
                        Debug.printStackTrace(t3);
                        Debug.println("****  Exception in destroy:  " + t3);
                    }
                    this.setState(3);
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                AnimationClient[] c2 = this.clients;
                if (c2 != null) {
                    for (int i = 0; i < c2.length; ++i) {
                        try {
                            Debug.println("Destroying animation client " + i);
                            c2[i].destroy();
                            Debug.println("Destroyed animation client " + i);
                            continue;
                        }
                        catch (Throwable t2) {
                            Debug.println(this);
                            Debug.printStackTrace(t2);
                            Debug.println("****  Exception in destroy:  " + t2);
                        }
                    }
                }
                try {
                    this.terminatingEraseScreen();
                }
                catch (Throwable t3) {
                    Debug.printStackTrace(t3);
                    Debug.println("****  Exception in destroy:  " + t3);
                }
                this.setState(3);
                throw throwable;
            }
        }
    }

    protected abstract void runAnimationLoop() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkNewClients() throws InterruptedException {
        int i;
        AnimationClient[] oldClients = null;
        AnimationClient[] localNew = null;
        AnimationEngine animationEngine = this;
        synchronized (animationEngine) {
            if (this.newClients == null) {
                return;
            }
            oldClients = this.clients;
            localNew = this.newClients;
            this.newClients = null;
        }
        for (i = 0; i < localNew.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < oldClients.length; ++j) {
                if (localNew[i] != oldClients[j]) continue;
                found = true;
                oldClients[j] = null;
            }
            if (found) continue;
            localNew[i].initialize(this.getComponent());
        }
        for (i = 0; i < oldClients.length; ++i) {
            AnimationClient c2 = oldClients[i];
            if (c2 == null) continue;
            c2.destroy();
        }
        this.renderContext.resetLastFrameList();
        this.doInitClients(localNew);
        this.paintNextFrameFully();
    }

    public final int getModelTimeSkipped() {
        return this.modelTimeSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void advanceModel() throws InterruptedException {
        Object object = this.repaintLock;
        synchronized (object) {
            for (int i = 0; i < this.clients.length; ++i) {
                this.clients[i].nextFrame();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void showFrame() throws InterruptedException {
        int i;
        boolean partialPaint;
        boolean fullPaint;
        for (int i2 = 0; i2 < this.clients.length; ++i2) {
            this.clients[i2].setCaughtUp();
        }
        this.renderContext.setEmpty();
        this.renderContext.setTarget(0);
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        AnimationEngine animationEngine = this;
        synchronized (animationEngine) {
            fullPaint = this.needsFullPaint || this.needsFullRedrawInAnimationLoop();
            boolean bl = partialPaint = this.repaintBounds != null && !this.repaintBounds.isEmpty();
            if (fullPaint) {
                x = 0;
                y = 0;
                w = this.getWidth();
                h = this.getHeight();
            } else if (partialPaint) {
                x = this.repaintBounds.x;
                y = this.repaintBounds.y;
                w = this.repaintBounds.width;
                h = this.repaintBounds.height;
                this.repaintBounds.setSize(0, 0);
            }
            this.needsFullPaint = false;
        }
        if (fullPaint || partialPaint) {
            this.renderContext.setFullPaint(x, y, w, h);
        }
        for (i = 0; i < this.clients.length; ++i) {
            this.clients[i].addDisplayAreas(this.renderContext);
        }
        this.renderContext.processLastFrameRecords();
        this.renderContext.collapseTargets();
        this.renderContext.calculateEraseTargets();
        if (!this.targetsCanOverlap) {
            for (i = 0; i < this.renderContext.numDrawTargets; ++i) {
                Rectangle a2 = this.renderContext.eraseTargets[i];
                if (RenderContextBase.isEmpty(a2)) continue;
                this.clearArea(a2.x, a2.y, a2.width, a2.height);
            }
        }
        try {
            this.callPaintTargets();
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            for (int i3 = 0; i3 < this.clients.length; ++i3) {
                try {
                    this.clients[i3].paintDone();
                    continue;
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            this.finishedFrame();
            throw throwable;
        }
        for (int i3 = 0; i3 < this.clients.length; ++i3) {
            try {
                this.clients[i3].paintDone();
                continue;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        {
        }
        this.finishedFrame();
    }

    protected final void paintTargets(Graphics2D g) throws InterruptedException {
        g.setComposite(AlphaComposite.Src);
        this.lastClip.width = 0;
        g.getClipBounds(this.lastClip);
        for (int i = 0; i < this.renderContext.numDrawTargets; ++i) {
            g.setClip(this.renderContext.drawTargets[i]);
            if (this.targetsCanOverlap) {
                Rectangle a2 = this.renderContext.eraseTargets[i];
                if (!RenderContextBase.isEmpty(a2)) {
                    this.clearArea(a2.x, a2.y, a2.width, a2.height);
                }
            }
            for (int j = 0; j < this.clients.length; ++j) {
                this.clients[j].paintFrame(g);
            }
        }
        if (this.lastClip.width == 0) {
            g.setClip(null);
        } else {
            g.setClip(this.lastClip);
        }
    }

    protected final void paintFrame(Graphics2D g) throws InterruptedException {
        g.setComposite(AlphaComposite.Src);
        for (int j = 0; j < this.clients.length; ++j) {
            this.clients[j].paintFrame(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintFrame(Graphics2D g) throws InterruptedException {
        if (this.destroyRequested()) {
            return;
        }
        Object object = this.repaintLock;
        synchronized (object) {
            this.paintFrame(g);
        }
    }
}

