/*
 * Decompiled with CFR 0.152.
 */
package com.disc_art_authoring.bdjmenu;

import com.disc_art_authoring.bdjmenu.BookMarkHelper;
import com.disc_art_authoring.bdjmenu.ClipAnimator;
import com.disc_art_authoring.bdjmenu.MediaListener;
import com.disc_art_authoring.bdjmenu.MenuDirector;
import com.disc_art_authoring.bdjmenu.MenuDiscNavigator;
import com.disc_art_authoring.bdjmenu.PropertyHelper;
import com.disc_art_authoring.bdjmenu.QueueItem;
import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.ActivatePartCommand;
import com.hdcookbook.grin.features.Assembly;
import com.hdcookbook.grin.features.Clipped;
import com.hdcookbook.grin.features.Fade;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.features.Text;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.VisualRCHandler;
import java.awt.AlphaComposite;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.bluray.system.RegisterAccess;

public class MediaManagement {
    private Show show = null;
    private MenuDirector director = null;
    private MenuDiscNavigator discNavigator = null;
    private RegisterAccess registers = null;
    private MediaListener mediaListener = null;
    private PropertyHelper propManager = null;
    private Properties propHandlers = null;
    private ArrayList clippingAnimators = null;
    private boolean isDead = false;
    private int scaleSourceWidth = 1920;
    private int scaleSourceHeight = 1080;
    public boolean scaleON = false;
    public int iCmd = -1;
    public boolean menuCalled = true;
    public boolean useReal2D = false;
    public boolean propsReaded = false;
    public boolean resumeAvailable = false;
    public int ticks = 0;
    public int tickSeconds = 0;
    public Date playTime = new Date();
    public long duration = 1L;
    private int lastPlayList = -1;
    private int lastPlayMark = 0;
    private long lastMediaTime = 0L;
    private String strLastSegment = "";
    private String strLastAssembly = "";
    private String strLastFeature = "";
    private static final String S_RESUME = "resume_";
    private static final String S_AUDIO = "audio_";
    private static final String S_SUBTITLE = "subtitle_";
    private static final String S_SUB_ON = "sub_on_";
    private static final String S_CHAPTER = "chapter_";
    private static final String S_PLAYLIST = "playlist";
    private static final String S_SEGMENT = "segment";
    private static final String S_ASSEMBLY = "assembly";
    private static final String S_FEATURE = "feature";
    private static final String S_MODE3D = "mode_3d";
    private static final String S_MODESFX = "mode_sfx";
    private static final String S_HANDLERS = "handlers";
    private static final String S_HANDLER = "handler_";
    private static final String S_HANDSTATE = "handlerstate_";
    private static final String BM_POSTFIX = ".bmk.";
    private static final int RATE_PAUSE = -1;
    private static final int RATE_PLAY = 0;
    private String startSegment;
    private boolean doStartSegment = false;
    private boolean FAllowSaveState = false;
    private String strAutoBtn = "";
    private String strIntroSegment = "";
    private String strTrackNumber = "";
    private String debugSpace = "";
    private boolean isSFX_ON = true;
    private int resumePlayList = -1;
    private long resumeTime;
    private boolean topMenuPressed = false;
    private int startPlayMark = 0;
    private int mode2D3D = 0;
    private boolean forceStartVideo = true;
    private int currentRate = 0;
    private static final int GPR_SFX = 4001;
    private static final int GPR_3D = 4003;
    private static final int GPR_TOP_MENU = 4005;
    private static final int GPR_STREAMS = 1000;
    private static final int GPR_RESUME_UPPER = 2000;
    private static final int GPR_RESUME_LOWER = 3000;
    private static final int MAX_BDID = 1000;
    private static final int MAX_CHAPTERS = 8191;
    private static final int MASK_AUDIO = 255;
    private static final int MASK_SUBTITLE = 65280;
    private static final int MASK_CHAPTER = 0x1FFF0000;
    private static final int MASK_SUB_ON = 0x40000000;
    private static final long MASK_LOW = 0xFFFFFFFFL;
    private static final long MASK_LONG = 0x100000000L;
    private static final int MARKER_TOP_MENU = 5;
    private static final int MARKER_ON = 0;
    private static final int MARKER_OFF = 5;
    private static final int MARKER_2D = 2;
    private static final int MARKER_3D = 3;
    private static final int MARKER_RESUME = -1;
    private static final int IN_PREFETCH = 10;
    public static final int SD_NOT_USED = 0;
    public static final int SD_ON_RESUME = 1;
    public static final int SD_ON_LOAD = 2;
    private boolean[] subtitlesOn = new boolean[1001];
    private String propertyPath;
    public boolean suppressLog = false;
    public boolean firstMenuStart = true;
    public static final int CALL_START_MENU = 1;
    public static final int CALL_START = 2;
    public static final int CALL_END = 3;
    public static final int CALL_MARK = 4;
    private ArrayList callQueue = new ArrayList();
    private static final int MAX_RATE = 7;
    private float[] rewindRates = new float[8];
    private static final boolean RESET_CLIP = true;
    private static final boolean SIGNED = true;
    private static final String ORG_ID = "7fff2222";
    private static final String APP_ID = "4000";
    public static final int USE_STORAGE = 1;
    private float REWIND_STEP = 2.0f;
    private static final String STORAGE_NAME = "BDS.properties";
    private static final long RESUME_DELAY = 1000000000L;
    private BookMarkHelper[] bookmarks = new BookMarkHelper[13];

    private boolean isMenu() {
        return false;
    }

    public MediaManagement(Show show, MenuDirector menuDirector, MenuDiscNavigator menuDiscNavigator, boolean bl) {
        if (show == null) {
            throw new IllegalArgumentException("show must not be null!");
        }
        if (menuDirector == null) {
            throw new IllegalArgumentException("director must not be null!");
        }
        if (menuDiscNavigator == null) {
            throw new IllegalArgumentException("discNavigator must not be null!");
        }
        this.show = show;
        this.director = menuDirector;
        this.discNavigator = menuDiscNavigator;
        this.registers = RegisterAccess.getInstance();
        this.rewindRates[0] = 1.0f;
        this.rewindRates[1] = 2.0f;
        this.rewindRates[2] = 5.0f;
        this.rewindRates[3] = 10.0f;
        this.rewindRates[4] = 20.0f;
        this.rewindRates[5] = 30.0f;
        this.rewindRates[6] = 60.0f;
        this.rewindRates[7] = 120.0f;
        if (bl) {
            this.initGetTopMenu();
        }
        try {
            this.propertyPath = File.separator + ORG_ID + File.separator + APP_ID + File.separator + STORAGE_NAME;
        }
        catch (Throwable throwable) {
            this.propertyPath = "\"7fff2222\"4000\"BDS.properties";
        }
        this.propManager = new PropertyHelper(this.propertyPath);
        this.propHandlers = new Properties();
        this.clippingAnimators = new ArrayList();
        if (this.loadStorage()) {
            if (this.topMenuPressed) {
                this.propsReaded = true;
            }
            boolean bl2 = this.resumeAvailable = this.propManager.getDataInt(S_PLAYLIST, -1) > -1 && this.propManager.getData(S_SEGMENT).length() > 0;
            if (!this.propsReaded) {
                this.propManager.clear();
            }
        }
        for (int i = 0; i < this.bookmarks.length; ++i) {
            if (this.fileExists(this.propertyPath + BM_POSTFIX + i)) {
                this.bookmarks[i] = new BookMarkHelper(this.propertyPath + BM_POSTFIX + i);
                this.bookmarks[i].readFile();
                continue;
            }
            this.bookmarks[i] = null;
        }
    }

    public void setMediaListener(MediaListener mediaListener) {
        this.mediaListener = mediaListener;
    }

    public void showLog(String string) {
        if (this.suppressLog) {
            return;
        }
        if (string.startsWith("<==") && this.debugSpace.length() > 0) {
            this.debugSpace = this.debugSpace.substring(0, this.debugSpace.length() - 1);
        }
        System.out.println(this.debugSpace + string + "   ... " + Thread.currentThread().getName());
        if (string.startsWith("==>")) {
            this.debugSpace = this.debugSpace + " ";
        }
    }

    public void showException(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void setXletDead() {
        this.isDead = true;
    }

    public boolean isXletDestroying() {
        if (this.isDead) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.discNavigator.isXletDestroying();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            this.isDead = true;
        }
        return bl;
    }

    private void updateLastPlayMark(int n) {
        this.lastPlayMark = this.getChapter(n, true) - 1;
        if (this.lastPlayMark < 0) {
            this.lastPlayMark = 0;
        }
    }

    public void setLastSegment(String string) {
        this.strLastSegment = string;
    }

    public void setLastAssembly(String string) {
        this.strLastAssembly = string;
    }

    public void setLastFeature(String string) {
        this.strLastFeature = string;
    }

    public void setLastMediaTime() {
        if (this.isMenu()) {
            return;
        }
        try {
            this.lastMediaTime = this.discNavigator.getMediaTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void saveAudio(int n, int n2) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 1;
        }
        this.storeData(S_AUDIO + n, n2);
    }

    public void saveSubtitle(int n, int n2, boolean bl) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 0;
        }
        this.storeData(S_SUBTITLE + n, n2);
        this.storeData(S_SUB_ON + n, String.valueOf(bl));
    }

    public void saveAudioSubtitle(int n, int n2, int n3, boolean bl) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 1;
        }
        if (n3 < 0 || n3 > 255) {
            n3 = 0;
        }
        this.storeData(S_AUDIO + n, n2);
        this.storeData(S_SUBTITLE + n, n3);
        this.storeData(S_SUB_ON + n, String.valueOf(bl));
    }

    public void saveChapter(int n, int n2) {
        if (n > 1000) {
            n = 1000;
        }
        this.storeData(S_CHAPTER + n, n2);
    }

    public void saveResumeTime(int n, long l) {
        this.storeData(S_RESUME + n, l);
    }

    public void savePlayList(int n) {
        this.storeData(S_PLAYLIST, this.lastPlayList);
    }

    public void saveMediaState() {
        this.saveMediaState(-1, -1, -1L, true, false);
    }

    public void saveMediaState(boolean bl) {
        this.saveMediaState(-1, -1, -1L, true, bl);
    }

    public void saveMediaState(int n, int n2, long l, boolean bl) {
        this.saveMediaState(n, n2, l, bl, false);
    }

    public void saveMediaState(int n, int n2, long l, boolean bl, boolean bl2) {
        if (this.isMenu()) {
            return;
        }
        if (n < 0) {
            this.lastPlayList = bl2 ? this.getPSR(6) : this.discNavigator.getPlaylistId();
            if (this.lastPlayList < 0 || this.lastPlayList > 1000) {
                this.lastPlayList = 0;
            }
        } else {
            this.lastPlayList = n;
        }
        this.savePlayList(this.lastPlayList);
        if (n2 < 0) {
            if (bl2) {
                n2 = this.getPSR(5);
                if (n2 < 1 || n2 > 8191) {
                    n2 = this.lastPlayMark + 1;
                }
            } else {
                n2 = this.discNavigatorGetChapterNumber();
            }
            if (n2 < 0 || n2 > 8191) {
                n2 = 0;
            }
        }
        this.saveChapter(this.lastPlayList, n2);
        if (l < 0L) {
            if (!bl2) {
                this.lastMediaTime = this.discNavigator.getMediaTime();
            }
            if (this.lastMediaTime < 0L) {
                this.lastMediaTime = 0L;
            }
        } else {
            this.lastMediaTime = l;
        }
        this.saveResumeTime(this.lastPlayList, this.lastMediaTime);
        if (bl) {
            if (bl2) {
                int n3 = this.getPSR(2);
                this.saveAudioSubtitle(this.lastPlayList, this.getPSR(1), n3 & 0xFFF, (n3 & Integer.MIN_VALUE) != 0);
            } else {
                this.saveAudioSubtitle(this.lastPlayList, this.getCurrentAudioID(), this.getCurrentSubNumber(), this.getCurrentSubState());
            }
        }
    }

    public void saveCurrentResumeTime() {
        this.saveMediaState();
    }

    public void selectAudio(int n) {
        if (n < 0 || n > 255) {
            n = 1;
        }
        try {
            this.discNavigator.selectAudio(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectSubtitle(int n) {
        if (n < 0 || n > 255) {
            n = 0;
        }
        if (n > 0) {
            this.selectSubtitle(n, true);
        } else {
            this.selectSubtitleState(false);
        }
    }

    public void selectSubtitle(int n, boolean bl) {
        if (n < 1 || n > 255) {
            n = 1;
        }
        try {
            this.discNavigator.selectSubtitles(bl, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectSubtitleState(boolean bl) {
        try {
            this.discNavigator.setSubtitling(bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectAudioStream(int n, int n2, boolean bl) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 1;
        }
        try {
            this.discNavigator.selectAudioStream(n, n2, bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveAudio(n, n2);
    }

    public void selectSubtitleStream(int n, int n2, boolean bl) {
        boolean bl2 = n2 > 0;
        this.selectSubtitleStream(n, n2, bl2, bl);
    }

    public void selectSubtitleStream(int n, int n2, boolean bl, boolean bl2) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 0;
        }
        if (n2 == 0) {
            bl = false;
        }
        try {
            if (n2 != 0) {
                this.discNavigator.selectSubtitleStream(n, n2, false);
            }
            this.subtitlesOn[n] = bl;
            if (bl2) {
                if (n2 == 0) {
                    this.discNavigator.setSubtitling(false);
                } else {
                    this.discNavigator.selectSubtitles(bl, n2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveSubtitle(n, n2, bl);
    }

    public void selectAudioSubtitleStream(int n, int n2, int n3, boolean bl) {
        boolean bl2 = n3 > 0;
        this.selectAudioSubtitleStream(n, n2, n3, bl2, bl);
    }

    public void selectAudioSubtitleStream(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (n > 1000) {
            n = 1000;
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > 255) {
            n3 = 0;
        }
        if (n3 == 0) {
            bl = false;
        }
        try {
            this.discNavigator.selectAudioStream(n, n2, bl2);
            if (n3 != 0) {
                this.discNavigator.selectSubtitleStream(n, n3, false);
            }
            this.subtitlesOn[n] = bl;
            if (bl2) {
                if (n3 == 0) {
                    this.discNavigator.setSubtitling(false);
                } else {
                    this.discNavigator.selectSubtitles(bl, n3);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveAudioSubtitle(n, n2, n3, bl);
    }

    public void restoreAudioSubtitle(int n) {
        boolean bl;
        if (n > 1000) {
            n = 1000;
        }
        int n2 = this.readDataInt(S_AUDIO + n);
        int n3 = this.readDataInt(S_SUBTITLE + n);
        boolean bl2 = bl = !this.readData(S_SUB_ON + n).equals(String.valueOf(false));
        if (n3 == 0) {
            bl = false;
        }
        try {
            this.discNavigator.selectAudioStream(n, n2, false);
            if (n3 != 0) {
                this.discNavigator.selectSubtitleStream(n, n3, false);
            }
            this.subtitlesOn[n] = bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void startVideoAt(int n, int n2) {
        this.forceStartVideo = false;
        try {
            this.discNavigator.startVideoAt(n, n2);
            this.lastPlayList = n;
            this.lastPlayMark = n2;
            this.currentRate = 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void startVideo(int n, int n2) {
        int n3 = this.getPlaylistID();
        if (n == 1 || n3 != 1) {
            n3 = n;
        }
        if (n != this.getPlaylistID() || n3 == 0 || this.forceStartVideo) {
            this.forceStartVideo = false;
            try {
                this.discNavigator.startVideoAt(n, n2);
                this.lastPlayList = n;
                this.lastPlayMark = n2;
                this.currentRate = 0;
            }
            catch (Throwable throwable) {}
        } else {
            try {
                this.discNavigator.gotoPlaylistMarkInCurrentPlaylist(n2);
                this.currentRate = 0;
                this.lastPlayMark = n2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void jumpPlayMark(int n) {
        try {
            this.discNavigator.gotoPlaylistMarkInCurrentPlaylist(n);
            this.currentRate = 0;
            this.lastPlayMark = n;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setStartPlayMark(int n) {
        this.startPlayMark = n;
    }

    public void setStartPlayMarkResume() {
        this.startPlayMark = -1;
    }

    public void jumpNextMark() {
        int n = 0;
        try {
            n = this.discNavigatorGetChapterNumber();
            if (n < 0) {
                n = 0;
            }
            this.discNavigator.gotoPlaylistMarkInCurrentPlaylist(n);
            this.lastPlayMark = n;
            this.currentRate = 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void jumpNextMark(int n) {
        int n2 = 0;
        try {
            n2 = this.discNavigatorGetChapterNumber();
            if (n2 < n) {
                this.discNavigator.gotoPlaylistMarkInCurrentPlaylist(n2);
                this.lastPlayMark = n2;
                this.currentRate = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void jumpPrevMark(int n) {
        if (n < 1) {
            n = 1;
        }
        int n2 = 0;
        try {
            n2 = this.discNavigatorGetChapterNumber();
            if (n2 > n) {
                this.discNavigator.gotoPlaylistMarkInCurrentPlaylist(n2 - 2);
                this.lastPlayMark = n2 - 2;
                this.currentRate = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void jumpPrevMark() {
        this.jumpPrevMark(1);
    }

    public void playVideoAt(int n) {
        int n2 = this.startPlayMark;
        this.startPlayMark = 0;
        if (n2 == -1) {
            this.resumeVideoAt(n);
        } else {
            this.startVideoAt(n, n2);
        }
    }

    public void playVideo(int n) {
        int n2 = this.startPlayMark;
        this.startPlayMark = 0;
        if (n2 == -1) {
            this.resumeVideoAt(n);
        } else {
            this.startVideo(n, n2);
        }
    }

    public void playVideoFrom(int n, long l) {
        int n2 = this.getPlaylistID();
        if (n != this.getPlaylistID() || n2 == 0 || this.forceStartVideo) {
            this.forceStartVideo = false;
            try {
                this.discNavigator.startVideoAt(n, 0, l);
                this.lastPlayMark = this.getChapterNumberByTime(n, l) - 1;
                this.lastMediaTime = l;
                this.lastPlayList = n;
                this.updateLastPlayMark(n);
                this.currentRate = 0;
            }
            catch (Throwable throwable) {}
        } else {
            try {
                this.discNavigator.gotoMediaTimeInCurrentPlaylist(l);
                this.lastPlayMark = this.getChapterNumberByTime(n, l) - 1;
                this.lastMediaTime = l;
                this.currentRate = 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean jumpTime(int n) {
        long l = (long)n * 1000000000L;
        try {
            int n2 = this.discNavigator.getPlaylistId();
            this.discNavigator.startVideoAt(n2, 0, l);
            this.lastPlayMark = this.getChapterNumberByTime(n2, l) - 1;
            this.lastMediaTime = l;
            this.updateLastPlayMark(n2);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void setForceStartVideo() {
        this.forceStartVideo = true;
    }

    public boolean resumeVideoAt(int n) {
        this.resumeTime = this.getResumeTimeReg(n);
        this.forceStartVideo = false;
        try {
            this.discNavigator.startVideoAt(n, 0, this.resumeTime);
            this.lastPlayMark = this.getChapterNumberByTime(n, this.resumeTime) - 1;
            this.lastMediaTime = this.resumeTime;
            this.lastPlayList = n;
            this.updateLastPlayMark(n);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public long getResumeTimeReg(int n) {
        long l = this.readDataLong(S_RESUME + n);
        l = l > 1000000000L ? (l -= 1000000000L) : 0L;
        return l;
    }

    public void resetResumeTime(int n) {
        this.saveResumeTime(n, 0L);
        this.saveChapter(n, 0);
    }

    public void resumeMedia() {
        if (this.resumeTime > 0L) {
            try {
                this.discNavigator.gotoMediaTimeInCurrentPlaylist(this.resumeTime);
                this.lastPlayMark = this.getChapterNumberByTime(this.getPlaylistID(), this.resumeTime) - 1;
                this.lastMediaTime = this.resumeTime;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getResumePlaylist() {
        return this.resumePlayList;
    }

    public void setResumePlaylist(int n) {
        this.resumePlayList = n;
        if (n > -1) {
            this.resumeTime = this.getResumeTimeReg(n);
        }
    }

    public boolean canResume(int n) {
        long l = this.getResumeTimeReg(n);
        return l > 0L;
    }

    public float getPlaybackRate() {
        float f = 1.0f;
        try {
            f = this.discNavigator.getPlaybackRate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setPlaybackRate(float f) {
        float f2 = 1.0f;
        MenuDiscNavigator menuDiscNavigator = this.discNavigator;
        synchronized (menuDiscNavigator) {
            try {
                f2 = this.discNavigator.setPlaybackRate(f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f2;
    }

    public void pauseMovie() {
        this.setPlaybackRate(0.0f);
        this.currentRate = -1;
    }

    public void playMovie() {
        this.setPlaybackRate(1.0f);
        this.currentRate = 0;
    }

    public void playPause() {
        if (this.getPlaybackRate() == 1.0f) {
            this.pauseMovie();
        } else {
            this.playMovie();
        }
    }

    private int getRateIndex(float f) {
        f = StrictMath.abs(f);
        for (int i = 7; i > 0; --i) {
            if (StrictMath.round(f * 100.0f) < StrictMath.round(this.rewindRates[i] * 100.0f)) continue;
            return i;
        }
        if (StrictMath.round(f * 100.0f) > 100) {
            return 1;
        }
        if (StrictMath.round(f * 100.0f) < 5) {
            return -1;
        }
        return 0;
    }

    public void fastForward() {
        float f = 0.0f;
        try {
            f = this.discNavigator.getPlaybackRate();
            int n = this.getRateIndex(f);
            if (n <= 0) {
                this.setPlaybackRate(this.rewindRates[1]);
                return;
            }
            n = f > 0.0f ? ++n : --n;
            if (n < 0) {
                n = 0;
            }
            if (n > 7) {
                n = 7;
            }
            if (f > 0.0f || n == 0) {
                this.setPlaybackRate(this.rewindRates[n]);
            } else {
                this.setPlaybackRate(-this.rewindRates[n]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void rewind() {
        float f = 0.0f;
        try {
            f = this.discNavigator.getPlaybackRate();
            int n = this.getRateIndex(f);
            if (n <= 0) {
                this.setPlaybackRate(-this.rewindRates[1]);
                return;
            }
            n = f > 0.0f ? --n : ++n;
            if (n < 0) {
                n = 0;
            }
            if (n > 7) {
                n = 7;
            }
            if (f > 0.0f || n == 0) {
                this.setPlaybackRate(this.rewindRates[n]);
            } else {
                this.setPlaybackRate(-this.rewindRates[n]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isFastForward() {
        float f = this.getPlaybackRate();
        return (double)f > 1.001;
    }

    public boolean isRewind() {
        float f = this.getPlaybackRate();
        return (double)f < -0.001;
    }

    public boolean isPaused() {
        float f = this.getPlaybackRate();
        return StrictMath.round(f * 100.0f) == 0;
    }

    public boolean isPlaying() {
        float f = this.getPlaybackRate();
        return StrictMath.round(f * 100.0f) == 100;
    }

    public boolean isPlayed() {
        return this.isPlaying();
    }

    public boolean canDiscResume() {
        return this.resumeAvailable;
    }

    public boolean resumeDisc() {
        if (!this.propsReaded) {
            this.loadDataFromStorage();
        }
        if (!this.propsReaded) {
            return false;
        }
        this.initSFX();
        this.restoreStreams();
        int n = this.propManager.getDataInt(S_PLAYLIST, -1);
        this.strLastSegment = this.readData(S_SEGMENT);
        this.strLastAssembly = this.readData(S_ASSEMBLY);
        this.strLastFeature = this.readData(S_FEATURE);
        if (n < 0 || this.strLastSegment.length() == 0) {
            return false;
        }
        try {
            if (this.show.getSegment(this.strLastSegment) == null) {
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        String string = "";
        String string2 = "";
        int n2 = this.readDataInt(S_HANDLERS);
        for (int i = 0; i < n2; ++i) {
            string = this.readData(S_HANDLER + i);
            string2 = this.readData(S_HANDSTATE + i);
            if (string.length() <= 0 || string2.length() <= 0) continue;
            this.activateButton(string, string2);
        }
        try {
            Feature feature;
            Assembly assembly;
            if (this.strLastAssembly.length() > 0 && this.strLastFeature.length() > 0 && (assembly = (Assembly)this.show.getFeature(this.strLastAssembly)) != null && (feature = this.show.getFeature(this.strLastFeature)) != null) {
                assembly.setCurrentFeature(feature);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        this.allowSaveState(true);
        if (!this.resumeVideoAt(n)) {
            return false;
        }
        return this.activateSegment(this.strLastSegment);
    }

    public String readData(String string) {
        try {
            return this.propManager.getData(string);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public int readDataInt(String string) {
        try {
            return this.propManager.getDataInt(string, 0);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public long readDataLong(String string) {
        try {
            return this.propManager.getDataLong(string, 0L);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public float readDataFloat(String string) {
        try {
            return this.propManager.getDataFloat(string, 0.0f);
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    public boolean readDataBoolean(String string) {
        try {
            return this.propManager.getDataBoolean(string, false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String readData(String string, String string2) {
        try {
            String string3 = this.propManager.getData(string);
            if (string3.length() == 0) {
                return string2;
            }
            return string3;
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    public int readDataInt(String string, int n) {
        try {
            return this.propManager.getDataInt(string, n);
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public long readDataLong(String string, long l) {
        try {
            return this.propManager.getDataLong(string, l);
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    public float readDataFloat(String string, float f) {
        try {
            return this.propManager.getDataFloat(string, f);
        }
        catch (Throwable throwable) {
            return f;
        }
    }

    public boolean readDataBoolean(String string, boolean bl) {
        try {
            return this.propManager.getDataBoolean(string, bl);
        }
        catch (Throwable throwable) {
            return bl;
        }
    }

    public void storeData(String string, String string2) {
        try {
            this.propManager.setData(string, string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storeData(String string, int n) {
        try {
            this.propManager.setData(string, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storeData(String string, long l) {
        try {
            this.propManager.setData(string, l);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storeData(String string, float f) {
        try {
            this.propManager.setData(string, f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storeData(String string, boolean bl) {
        try {
            this.propManager.setData(string, bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storeRCHandlers(Segment segment) {
        try {
            RCHandler[] rCHandlerArray = segment.getRCHandlers();
            this.propHandlers.clear();
            int n = 0;
            for (int i = 0; i < rCHandlerArray.length; ++i) {
                String string;
                String string2;
                VisualRCHandler visualRCHandler;
                int n2;
                if (!(rCHandlerArray[i] instanceof VisualRCHandler) || (n2 = (visualRCHandler = (VisualRCHandler)rCHandlerArray[i]).getState()) < 0 || (string2 = visualRCHandler.getName()) == null || (string = visualRCHandler.getStateName(n2)) == null) continue;
                this.propHandlers.setProperty(S_HANDLER + n, string2);
                this.propHandlers.setProperty(S_HANDSTATE + n, string);
                ++n;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void allowSaveState(boolean bl) {
        this.FAllowSaveState = bl;
    }

    public void saveStorage() {
        try {
            this.saveMediaState(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.FAllowSaveState) {
            try {
                this.propManager.writeFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.storeData(S_SEGMENT, this.strLastSegment);
        this.storeData(S_ASSEMBLY, this.strLastAssembly);
        this.storeData(S_FEATURE, this.strLastFeature);
        int n = this.propHandlers.size() / 2;
        this.storeData(S_HANDLERS, n);
        for (int i = 0; i < n; ++i) {
            String string = this.propHandlers.getProperty(S_HANDLER + i);
            this.storeData(S_HANDLER + i, string);
            this.storeData(S_HANDSTATE + i, this.propHandlers.getProperty(S_HANDSTATE + i));
        }
        try {
            this.propManager.writeFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean loadStorage() {
        boolean bl = false;
        try {
            bl = this.propManager.readFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public boolean loadDataFromStorage() {
        this.propsReaded = this.loadStorage();
        return this.propsReaded;
    }

    public boolean restoreDataFromStorage() {
        this.propsReaded = this.loadStorage();
        if (this.propsReaded) {
            this.restoreStreams();
        }
        return this.propsReaded;
    }

    public boolean hasDataInStorage() {
        return this.fileExists(this.propertyPath);
    }

    public boolean fileExists(String string) {
        boolean bl = false;
        try {
            File file = new File(System.getProperty("dvb.persistent.root") + string);
            bl = file.exists();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private void checkBookmarksExists(int n) {
        if (this.bookmarks[n] == null) {
            this.bookmarks[n] = new BookMarkHelper(this.propertyPath + BM_POSTFIX + n);
        }
    }

    public int currentBookmarkNumber(int n) {
        int n2 = 0;
        try {
            this.checkBookmarksExists(n);
            n2 = this.bookmarks[n].currentIdx() + 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2;
    }

    public boolean isFirstBookmark(int n) {
        boolean bl = true;
        try {
            this.checkBookmarksExists(n);
            bl = this.bookmarks[n].currentIdx() <= 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public boolean isLastBookmark(int n) {
        boolean bl = true;
        try {
            this.checkBookmarksExists(n);
            int n2 = this.bookmarks[n].currentIdx();
            bl = n2 < 0 || n2 == this.bookmarks[n].count() - 1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public long currentBookmarkTime(int n) {
        long l = -1L;
        try {
            this.checkBookmarksExists(n);
            l = this.bookmarks[n].currentTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public String currentBookmarkText(int n) {
        String string = "";
        try {
            this.checkBookmarksExists(n);
            string = this.time2str(this.bookmarks[n].currentTime());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public void nextBookmark(int n) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].nextCurrent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void prevBookmark(int n) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].prevCurrent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void firstBookmark(int n) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].firstCurrent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void lastBookmark(int n) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].lastCurrent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getBookmarkTime(int n, int n2) {
        long l = -1L;
        try {
            this.checkBookmarksExists(n);
            l = this.bookmarks[n].getTime(n2 - 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public String getBookmarkText(int n, int n2) {
        String string = "";
        try {
            this.checkBookmarksExists(n);
            string = this.time2str(this.bookmarks[n].getTime(n2 - 1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public int getBookmarksCount(int n) {
        int n2 = 0;
        try {
            this.checkBookmarksExists(n);
            n2 = this.bookmarks[n].count();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n2;
    }

    public void addBookmark(int n, long l) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].add(l);
            this.bookmarks[n].writeFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addBookmark() {
        try {
            this.addBookmark(this.getPlaylistID(), this.getMediaTime());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteBookmark(int n, long l) {
        try {
            this.checkBookmarksExists(n);
            this.bookmarks[n].delete(l);
            this.bookmarks[n].writeFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteBookmark(int n) {
        try {
            this.deleteBookmark(n, this.currentBookmarkTime(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void deleteBookmark() {
        try {
            this.deleteBookmark(this.getPlaylistID());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeAllBookmarks(int n) {
        try {
            this.bookmarks[n].removeAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void jumpBookmark(int n) {
        try {
            long l = this.currentBookmarkTime(n);
            if (l > -1L) {
                this.playVideoFrom(n, l);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Iterator bookmarkIterator(int n) {
        Iterator iterator = null;
        try {
            this.checkBookmarksExists(n);
            iterator = this.bookmarks[n].iterator();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return iterator;
    }

    public void setGPR(int n, int n2) {
        try {
            this.registers.setGPR(n, n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getGPR(int n) {
        try {
            return this.registers.getGPR(n);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void clearGPR() {
        try {
            for (int i = 1; i < 4001; ++i) {
                this.registers.setGPR(i, 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getPSR(int n) {
        try {
            return this.registers.getPSR(n);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void logPSR() {
        this.showLog("==> logPSR");
        try {
            for (int i = 1; i < 32; ++i) {
                try {
                    this.showLog("--- PSR [" + i + "] = " + this.registers.getPSR(i));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.showLog("--- PSR [" + i + "] = " + illegalArgumentException);
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.showLog("EXCEPTION: logPSR: " + noClassDefFoundError);
            noClassDefFoundError.printStackTrace();
        }
        this.showLog("<== logPSR done");
    }

    public boolean isTopMenuPressed() {
        return this.topMenuPressed;
    }

    public void initGetTopMenu() {
        this.topMenuPressed = this.getGPR(4005) == 5;
    }

    public void playSFX(String string) {
        if (this.isSFX_ON) {
            try {
                this.discNavigator.playSound(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setSoundState(boolean bl) {
        this.isSFX_ON = bl;
        if (bl) {
            this.setGPR(4001, 0);
            this.storeData(S_MODESFX, 0);
        } else {
            this.setGPR(4001, 5);
            this.storeData(S_MODESFX, 5);
        }
    }

    public void initSFX() {
        int n = this.propManager.getDataInt(S_MODESFX, -1);
        if (n >= 0) {
            this.isSFX_ON = n != 5;
        }
    }

    public boolean isSFXon() {
        return this.isSFX_ON;
    }

    public boolean isSFXoff() {
        return !this.isSFX_ON;
    }

    public int getPlaylistID() {
        int n = -1;
        try {
            n = this.discNavigator.getPlaylistId();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n > 1000) {
            n = -1;
        }
        return n;
    }

    public long getMediaTime() {
        long l = 0L;
        try {
            l = this.discNavigator.getMediaTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public long getMediaTimeInSeconds() {
        return this.getMediaTime() / 1000000000L;
    }

    public long getDuration() {
        this.duration = 1000000000L;
        try {
            this.duration = this.discNavigator.getDuration().getNanoseconds();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.duration < 1L) {
            this.duration = 1L;
        }
        return this.duration;
    }

    public long getDurationInSeconds() {
        return this.getDuration() / 1000000000L;
    }

    public boolean isPlaylist(int n) {
        return n == this.getPlaylistID();
    }

    public int getAudioID(int n) {
        return this.getAudioID(n, false);
    }

    public int getAudioID(int n, boolean bl) {
        int n2 = 1;
        try {
            int n3;
            n2 = this.discNavigator.getAudioStreamId(n);
            if (bl && n == this.getPlaylistID() && (n3 = this.getCurrentAudioID()) != n2 && n3 > 0) {
                n2 = n3;
                this.selectAudioStream(n, n3, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 1;
        }
        return n2;
    }

    public int getCurrentAudioID() {
        int n = 1;
        try {
            n = this.discNavigator.getCurrentAudioStreamIdFromPSR();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n < 0 || n > 255) {
            n = 1;
        }
        return n;
    }

    public int getSubID(int n) {
        return this.getSubID(n, false);
    }

    public int getSubID(int n, boolean bl) {
        int n2 = 0;
        if (this.getSubState(n, bl)) {
            n2 = this.getSubNumber(n, bl);
        }
        return n2;
    }

    public int getSubNumber(int n) {
        return this.getSubNumber(n, false);
    }

    public int getSubNumber(int n, boolean bl) {
        if (n > 1000) {
            n = 1000;
        }
        int n2 = 0;
        try {
            int n3;
            n2 = this.discNavigator.getSubtitleStreamId(n);
            if (bl && n == this.getPlaylistID() && (n3 = this.getCurrentSubNumber()) != n2) {
                n2 = n3;
                this.selectSubtitleStream(n, n3, this.getCurrentSubState(), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 < 0 || n2 > 255) {
            n2 = 0;
        }
        return n2;
    }

    public boolean getSubState(int n) {
        return this.getSubState(n, false);
    }

    public boolean getSubState(int n, boolean bl) {
        if (n > 1000) {
            n = 1000;
        }
        if (bl && n == this.getPlaylistID()) {
            this.subtitlesOn[n] = this.getCurrentSubState();
        }
        return this.subtitlesOn[n];
    }

    public int getCurrentSubID() {
        int n = 0;
        if (this.getCurrentSubState()) {
            n = this.getCurrentSubNumber();
        }
        return n;
    }

    public int getCurrentSubNumber() {
        int n = 0;
        try {
            n = this.discNavigator.getCurrentSubtitleStreamIdFromPSR();
            if (n < 0 || n > 255) {
                n = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public boolean getCurrentSubState() {
        boolean bl = false;
        try {
            bl = this.discNavigator.isSubtitlesOnFromPSR();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public int getChapterCurPL(int n) {
        int n2 = -1;
        try {
            n2 = this.discNavigator.getPlaylistId() == n ? (this.isMenu() ? this.getChapter(n, true) : this.discNavigatorGetChapterNumber()) : -2;
        }
        catch (Throwable throwable) {
            n2 = -3;
        }
        return n2;
    }

    public int getChapter(int n, boolean bl) {
        int n2 = 0;
        try {
            int n3 = this.discNavigator.getPlaylistId();
            if (!bl && n3 == n) {
                n2 = this.discNavigatorGetChapterNumber();
            }
            if (n2 > 9999 || bl || n3 != n) {
                n2 = this.readDataInt(S_CHAPTER + n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 < 0 || n2 > 8191) {
            n2 = 0;
        }
        return n2;
    }

    public int getChapter(int n) {
        return this.getChapter(n, false);
    }

    public int getCurrentChapter() {
        int n = 0;
        if (this.isMenu()) {
            n = this.getChapter(this.getPlaylistID(), true);
            return n;
        }
        try {
            n = this.discNavigatorGetChapterNumber();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n < 0 || n > 8191) {
            n = 0;
        }
        return n;
    }

    public void selectTitle(int n) {
        try {
            String string = Integer.toHexString(n);
            while (string.length() < 4) {
                string = "0" + string;
            }
            this.discNavigator.selectTitle("bd://" + string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setVideoSize(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = new Rectangle(n5, n6, n7, n8);
            this.discNavigator.setVideoSize(rectangle, rectangle2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void scaleVideoSize(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.scaleON) {
            this.scaleSourceWidth = n3;
            this.scaleSourceHeight = n4;
        }
        this.scaleON = true;
        this.setVideoSize(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void scaleBack() {
        this.scaleON = false;
        this.setVideoSize(0, 0, this.scaleSourceWidth, this.scaleSourceHeight, 0, 0, this.scaleSourceWidth, this.scaleSourceHeight);
    }

    public void scaleFullToHalf(int n, int n2) {
        if (this.scaleON) {
            return;
        }
        this.scaleVideoSize(0, 0, 1920, 1080, n, n2, 960, 540);
    }

    public void scaleFullToQuarter(int n, int n2) {
        if (this.scaleON) {
            return;
        }
        this.scaleVideoSize(0, 0, 1920, 1080, n, n2, 480, 270);
    }

    public void scaleUHDToHalf(int n, int n2) {
        if (this.scaleON) {
            return;
        }
        this.scaleVideoSize(0, 0, 3840, 2160, n, n2, 1920, 1080);
    }

    public void scaleUHDToQuarter(int n, int n2) {
        if (this.scaleON) {
            return;
        }
        this.scaleVideoSize(0, 0, 3840, 2160, n, n2, 960, 540);
    }

    public void setPIP(boolean bl) {
        try {
            this.discNavigator.showSecondaryVideo(bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setPIPFullScreen(boolean bl) {
        try {
            this.discNavigator.enableFullScreenForSecondaryVideo(bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectSecondaryVideo(int n) {
        try {
            this.discNavigator.selectSecondaryVideoStream(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void selectSecondaryAudio(int n) {
        try {
            this.discNavigator.selectSecondaryAudioStream(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getSecondaryAudio() {
        return this.getPSR(14) & 0xFF;
    }

    public int getSecondaryVideo() {
        return this.getPSR(14) >>> 8 & 0xFF;
    }

    public int getSecondaryScale() {
        return this.getPSR(14) >>> 24 & 0xF;
    }

    public boolean isPIPAudioOn() {
        return (this.getPSR(14) >>> 30 & 1) != 0;
    }

    public boolean isPIPAudioOff() {
        return (this.getPSR(14) >>> 30 & 1) == 0;
    }

    public boolean isPIPon() {
        return (this.getPSR(14) >>> 31 & 1) != 0;
    }

    public boolean isPIPoff() {
        return (this.getPSR(14) >>> 31 & 1) == 0;
    }

    public boolean isPIPFSon() {
        return this.getSecondaryScale() == 15;
    }

    public boolean isPIPFSoff() {
        return this.getSecondaryScale() == 0;
    }

    public void resetTicks() {
        try {
            this.tickSeconds = 0;
            this.director.resetTicks();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void incrementTicks() {
        try {
            this.director.incrementTicks();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void incrementSecond() {
        ++this.tickSeconds;
    }

    public float abs(float f) {
        return StrictMath.abs(f);
    }

    public double abs(double d2) {
        return StrictMath.abs(d2);
    }

    public int abs(int n) {
        return StrictMath.abs(n);
    }

    public long abs(long l) {
        return StrictMath.abs(l);
    }

    public int round(float f) {
        return StrictMath.round(f);
    }

    public long round(double d2) {
        return StrictMath.round(d2);
    }

    public int random(int n) {
        return StrictMath.round((float)(StrictMath.random() * (double)n));
    }

    public String time2str(long l) {
        if (l < 0L) {
            l = 0L;
        }
        l = this.round((double)l / 1.0E9);
        long l2 = l / 3600L;
        long l3 = (l -= l2 * 3600L) / 60L;
        l -= l3 * 60L;
        String string = "";
        if (l2 < 10L) {
            string = string + "0";
        }
        string = string + l2 + ":";
        if (l3 < 10L) {
            string = string + "0";
        }
        string = string + l3 + ":";
        if (l < 10L) {
            string = string + "0";
        }
        string = string + l;
        return string;
    }

    public void moveXY(String string, int n, int n2) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            if (interpolatedModel != null) {
                if (n != 0) {
                    interpolatedModel.setField(0, interpolatedModel.getField(0) + n);
                }
                if (n2 != 0) {
                    interpolatedModel.setField(1, interpolatedModel.getField(1) + n2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void moveX(String string, int n) {
        this.moveXY(string, n, 0);
    }

    public void moveY(String string, int n) {
        this.moveXY(string, 0, n);
    }

    public void moveToXY(String string, int n, int n2) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            Feature feature = this.show.getFeature(string + ".base");
            if (interpolatedModel != null) {
                if (feature != null) {
                    int n3 = feature.getX();
                    int n4 = feature.getY();
                    if (n3 > -2000000000 && n3 < 2000000000) {
                        n -= n3;
                    }
                    if (n4 > -2000000000 && n4 < 2000000000) {
                        n2 -= n4;
                    }
                }
                interpolatedModel.setField(0, n);
                interpolatedModel.setField(1, n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void moveToX(String string, int n) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            Feature feature = this.show.getFeature(string + ".base");
            if (interpolatedModel != null) {
                int n2;
                if (feature != null && (n2 = feature.getX()) > -2000000000 && n2 < 2000000000) {
                    n -= n2;
                }
                interpolatedModel.setField(0, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void moveToY(String string, int n) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            Feature feature = this.show.getFeature(string + ".base");
            if (interpolatedModel != null) {
                int n2;
                if (feature != null && (n2 = feature.getY()) > -2000000000 && n2 < 2000000000) {
                    n -= n2;
                }
                interpolatedModel.setField(1, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getX(String string) {
        int n = 0;
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            if (interpolatedModel != null) {
                int n2;
                n = interpolatedModel.getField(0);
                Feature feature = this.show.getFeature(string + ".base");
                if (feature != null && (n2 = feature.getX()) > -2000000000 && n2 < 2000000000) {
                    n += n2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public int getY(String string) {
        int n = 0;
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".trm");
            if (interpolatedModel != null) {
                int n2;
                n = interpolatedModel.getField(1);
                Feature feature = this.show.getFeature(string + ".base");
                if (feature != null && (n2 = feature.getY()) > -2000000000 && n2 < 2000000000) {
                    n += n2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public void scaleXY(String string, int n, int n2) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".scm");
            if (interpolatedModel != null) {
                if (n != 0) {
                    interpolatedModel.setField(2, interpolatedModel.getField(2) + n);
                }
                if (n2 != 0) {
                    interpolatedModel.setField(3, interpolatedModel.getField(3) + n2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void scaleX(String string, int n) {
        this.scaleXY(string, n, 0);
    }

    public void scaleY(String string, int n) {
        this.scaleXY(string, 0, n);
    }

    public void scaleToXY(String string, int n, int n2) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".scm");
            if (interpolatedModel != null) {
                interpolatedModel.setField(2, n);
                interpolatedModel.setField(3, n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void scaleToX(String string, int n) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".scm");
            if (interpolatedModel != null) {
                interpolatedModel.setField(2, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void scaleToY(String string, int n) {
        try {
            InterpolatedModel interpolatedModel = (InterpolatedModel)this.show.getFeature(string + ".scm");
            if (interpolatedModel != null) {
                interpolatedModel.setField(3, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setClipping(String string, int n, int n2, int n3, int n4) {
        try {
            Clipped clipped = (Clipped)this.show.getFeature(string);
            if (clipped != null) {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                clipped.changeClipRegion(rectangle);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setClippingRect(String string, int n, int n2, int n3, int n4) {
        try {
            Clipped clipped = (Clipped)this.show.getFeature(string);
            if (clipped != null) {
                Rectangle rectangle = new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1);
                clipped.changeClipRegion(rectangle);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setAlpha(String string, double d2) {
        try {
            Fade fade = (Fade)this.show.getFeature(string + ".over");
            if (fade != null) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)(d2 / 255.0));
                fade.setAlpha(alphaComposite);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setText(String string, String string2) {
        this.setText(string, string2, 0);
    }

    public void setText(String string, String string2, int n) {
        try {
            Text text = null;
            try {
                text = (Text)this.show.getFeature(string + ".base");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (text == null) {
                try {
                    text = (Text)this.show.getFeature(string + ".unclipped");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (text == null) {
                try {
                    text = (Text)this.show.getFeature(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (text != null) {
                String[] stringArray = text.getText();
                stringArray[n] = string2;
                text.setText(stringArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean activateSegment(String string) {
        boolean bl = false;
        try {
            Segment segment = this.show.getSegment(string);
            if (segment != null) {
                this.show.activateSegment(segment);
                this.menuCalled = true;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.clippingAnimators.size() > 0) {
                this.clearClippingAnimation();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public void activateButton(String string, String string2) {
        this.activateButtonEx(string, string2, false);
    }

    public void activateButtonEx(String string, String string2, boolean bl) {
        try {
            int n;
            VisualRCHandler visualRCHandler = (VisualRCHandler)this.show.getRCHandler(string);
            if (bl) {
                this.menuCalled = true;
            }
            if (visualRCHandler != null && (n = visualRCHandler.lookupState(string2)) > -1) {
                visualRCHandler.setState(n, bl, bl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCurrentSegmentNameSafe() {
        String string = this.strLastSegment;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getCurrentSegmentName() {
        String string = "";
        try {
            Segment segment = this.show.getCurrentSegment();
            if (segment != null) {
                string = segment.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public boolean IsMenuOnScreen() {
        boolean bl = true;
        try {
            bl = !this.getCurrentSegmentName().equals("S:Movie");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public void setStartSegment(String string) {
        this.startSegment = string;
        this.doStartSegment = true;
    }

    public String getStartSegment() {
        return this.startSegment;
    }

    public void activateStartSegment() {
        this.doStartSegment = false;
        this.menuCalled = this.activateSegment(this.startSegment);
    }

    public boolean needStartSegment() {
        return this.doStartSegment;
    }

    public void clearStartSegment() {
        this.doStartSegment = false;
    }

    public void setIntroSegment(String string) {
        this.strIntroSegment = string;
    }

    public String getIntroSegment() {
        return this.strIntroSegment;
    }

    public void activateIntroSegment() {
        this.menuCalled = this.activateSegment(this.strIntroSegment);
        if (this.menuCalled) {
            this.clearIntroSegment();
        }
    }

    public boolean needIntroSegment() {
        return this.strIntroSegment.length() != 0;
    }

    public void clearIntroSegment() {
        this.strIntroSegment = "";
    }

    public boolean isButtonSelected(String string, String string2) {
        try {
            Assembly assembly = (Assembly)this.show.getFeature(string);
            if (assembly == null) {
                return false;
            }
            Feature feature = assembly.getCurrentPart();
            if (feature == null) {
                return false;
            }
            return feature.getName().equals(string2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean needAutoButton() {
        return this.strAutoBtn.length() != 0;
    }

    public String getAutoButton(boolean bl) {
        String string = this.strAutoBtn;
        if (bl) {
            this.strAutoBtn = "";
        }
        return string;
    }

    public void setAutoButton(String string) {
        this.strAutoBtn = string;
    }

    public void clearAutoButton() {
        this.strAutoBtn = "";
    }

    public void syncDisplay() {
        try {
            this.show.syncDisplay();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addTrackNumber(String string) {
        this.strTrackNumber = this.strTrackNumber + string;
    }

    public void clearTrackNumber() {
        this.strTrackNumber = "";
    }

    public int getTrackNumber() {
        if (this.strTrackNumber.length() == 0) {
            return 0;
        }
        int n = 0;
        try {
            Integer n2 = new Integer(this.strTrackNumber);
            n = n2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public void animateClipping() {
        try {
            for (int i = 0; i < this.clippingAnimators.size(); ++i) {
                ((ClipAnimator)this.clippingAnimators.get(i)).nextFrame();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalizeClippingAnimation() {
        try {
            for (int i = this.clippingAnimators.size() - 1; i >= 0; --i) {
                ((ClipAnimator)this.clippingAnimators.get(i)).finalizeAnimator();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearClippingAnimation() {
        try {
            for (int i = this.clippingAnimators.size() - 1; i >= 0; --i) {
                ((ClipAnimator)this.clippingAnimators.get(i)).clearAnimator();
                this.clippingAnimators.remove(i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addAnimatorItem(ClipAnimator clipAnimator, String string) {
        try {
            Feature feature = this.show.getFeature(string);
            if (feature != null && feature instanceof Clipped) {
                clipAnimator.addItem((Clipped)feature);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void call_onMediaStartMenu(int n) {
        this.callQueue.add(new QueueItem(1, n));
    }

    public synchronized void call_onMediaStart(int n) {
        this.callQueue.add(new QueueItem(2, n));
    }

    public synchronized void call_onMediaEnd(int n) {
        this.callQueue.add(new QueueItem(3, n));
    }

    public synchronized void call_onMarkReached(int n, int n2) {
        this.callQueue.add(new QueueItem(4, n, n2));
    }

    private synchronized QueueItem getItemFromQueue() {
        if (this.callQueue.size() == 0) {
            return null;
        }
        return (QueueItem)this.callQueue.remove(0);
    }

    public void proceedActionQueue() {
        QueueItem queueItem = this.getItemFromQueue();
        if (queueItem == null) {
            return;
        }
        switch (queueItem.type) {
            case 1: {
                this.execute_onMediaStartMenu(queueItem.playlistId);
                break;
            }
            case 2: {
                this.execute_onMediaStart(queueItem.playlistId);
                break;
            }
            case 3: {
                this.execute_onMediaEnd(queueItem.playlistId);
                break;
            }
            case 4: {
                this.execute_onMarkReached(queueItem.playlistId, queueItem.mark);
            }
        }
    }

    private void execute_onMediaStartMenu(int n) {
        this.saveMediaState(n, -1, -1L, false);
        if (this.needStartSegment()) {
            this.syncDisplay();
            this.activateSegment("S:_StartSegmentRunner_");
        }
    }

    private void execute_onMediaStart(int n) {
        this.execute_onMediaStartMenu(n);
        int n2 = this.getAudioID(n);
        int n3 = this.getSubNumber(n);
        boolean bl = this.getSubState(n);
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        boolean bl2 = true;
        this.oms_01(n2, n3, bl, n4, n5, n6, n7, bl2, n);
        this.oms_02(n2, n3, bl, n4, n5, n6, n7, bl2, n);
        this.oms_03(n2, n3, bl, n4, n5, n6, n7, bl2, n);
        this.oms_04(n2, n3, bl, n4, n5, n6, n7, bl2, n);
    }

    private void oms_01(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        if (n7 == 5) {
            this.selectSubtitleStream(5, 1, true, true);
        }
    }

    private void oms_02(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        if (n7 == 6) {
            this.selectSubtitleStream(6, 1, true, true);
        }
    }

    private void oms_03(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        if (n7 == 7) {
            this.selectSubtitleStream(7, 1, true, true);
        }
    }

    private void oms_04(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        if (n7 == 8) {
            this.selectSubtitleStream(8, 1, true, true);
        }
    }

    private void execute_onMediaEnd(int n) {
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubNumber();
        boolean bl = this.getCurrentSubState();
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = n;
        int n5 = this.getCurrentChapter();
        boolean bl4 = true;
        switch (n) {
            case 4: {
                this.resetResumeTime(4);
                this.activateButtonEx("H:MM_Main_Menu_Set.Handler", "MM_Play", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Main_Menu_Set.show_menu");
                this.activateSegment("S:MM_Main_Menu_Set.show_menu.first_run");
                break;
            }
            case 5: {
                this.resetResumeTime(5);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_1", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 6: {
                this.resetResumeTime(6);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_2", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 7: {
                this.resetResumeTime(7);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_3", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 8: {
                this.resetResumeTime(8);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_4", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 9: {
                this.resetResumeTime(9);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_5", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 10: {
                this.resetResumeTime(10);
                this.activateButtonEx("H:MM_Bonus_Set.Handler", "Bonus_6", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Bonus_Set.show_menu");
                this.activateSegment("S:MM_Bonus_Set.show_menu.first_run");
                break;
            }
            case 11: {
                this.resetResumeTime(11);
                this.activateButtonEx("H:MM_Main_Menu_Set.Handler", "MM_Play", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Main_Menu_Set.show_menu");
                this.activateSegment("S:MM_Main_Menu_Set.show_menu.first_run");
                break;
            }
            case 12: {
                this.resetResumeTime(12);
                this.selectAudioStream(4, 1, false);
                this.selectSubtitleStream(4, 2, true, false);
                this.selectAudioStream(11, 1, false);
                this.activateButtonEx("H:MM_Main_Menu_Set.Handler", "MM_Play", false);
                if (this.scaleON) {
                    this.scaleBack();
                }
                this.setStartSegment("S:MM_Main_Menu_Set.show_menu");
                this.activateSegment("S:MM_Main_Menu_Set.show_menu.first_run");
            }
        }
    }

    private void execute_onMarkReached(int n, int n2) {
        this.lastPlayMark = n2;
        try {
            this.saveMediaState(n, n2 + 1, -1L, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n3 = this.getCurrentAudioID();
        int n4 = this.getCurrentSubNumber();
        boolean bl = this.getCurrentSubState();
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = n;
        int n6 = n2 + 1;
        boolean bl4 = true;
    }

    public int GetChapterNumberByTime(int n, long l) {
        return this.getChapterNumberByTime(n, l);
    }

    public void stopMovie() {
        this.selectTitle(2);
    }

    public int getChapterNumberByTime(int n, long l) {
        switch (n) {
            case 4: {
                if (l < 547590000000L) {
                    return 1;
                }
                if (l < 1171590000000L) {
                    return 2;
                }
                if (l < 1784590000000L) {
                    return 3;
                }
                if (l < 2282590000000L) {
                    return 4;
                }
                if (l < 2902590000000L) {
                    return 5;
                }
                if (l < 3539590000000L) {
                    return 6;
                }
                if (l < 4139590000000L) {
                    return 7;
                }
                if (l < 4670590000000L) {
                    return 8;
                }
                if (l < 5260590000000L) {
                    return 9;
                }
                if (l < 5787590000000L) {
                    return 10;
                }
                if (l < 6417590000000L) {
                    return 11;
                }
                if (l < 6997590000000L) {
                    return 12;
                }
                return 13;
            }
            case 5: {
                if (l < 262394200000L) {
                    return 1;
                }
                if (l < 617999455556L) {
                    return 2;
                }
                if (l < 915171333333L) {
                    return 3;
                }
                if (l < 1258305788889L) {
                    return 4;
                }
                if (l < 1557146000000L) {
                    return 5;
                }
                if (l < 1860157033333L) {
                    return 6;
                }
                if (l < 2123795411111L) {
                    return 7;
                }
                if (l < 2488701622222L) {
                    return 8;
                }
                if (l < 2798469411111L) {
                    return 9;
                }
                if (l < 3030326033333L) {
                    return 10;
                }
                if (l < 3380175533333L) {
                    return 11;
                }
                return 12;
            }
            case 6: {
                if (l < 864620833333L) {
                    return 1;
                }
                return 2;
            }
            case 7: {
                if (l < 778576533333L) {
                    return 1;
                }
                return 2;
            }
            case 8: {
                if (l < 859866077778L) {
                    return 1;
                }
                return 2;
            }
            case 9: {
                if (l < 234340000000L) {
                    return 1;
                }
                return 2;
            }
            case 10: {
                if (l < 73048333333L) {
                    return 1;
                }
                return 2;
            }
        }
        return 1;
    }

    private int discNavigatorGetChapterNumber() {
        return this.discNavigator.getChapterNumber();
    }

    public void UpdateCurrent_MM_Chapters_1_4_Set() {
        int n = this.getPlaylistID();
        boolean bl = false;
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubID();
        try {
            Feature feature = null;
            int n4 = -1;
            bl = false;
            n4 = this.getChapter(4);
            Assembly assembly = (Assembly)this.show.getFeature("F:MM_Chapters_1_4_Set.MOVIE.ScnCurrent.assembly");
            if (n4 == 1) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_1.Current");
            }
            if (n4 == 10) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_10.Current");
            }
            if (n4 == 11) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_11.Current");
            }
            if (n4 == 12) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_12.Current");
            }
            if (n4 == 2) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_2.Current");
            }
            if (n4 == 3) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_3.Current");
            }
            if (n4 == 4) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_4.Current");
            }
            if (n4 == 5) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_5.Current");
            }
            if (n4 == 6) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_6.Current");
            }
            if (n4 == 7) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_7.Current");
            }
            if (n4 == 8) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_8.Current");
            }
            if (n4 == 9) {
                feature = this.show.getFeature("F:MM_Chapters_1_4_Set.Scena_9.Current");
            }
            if (feature != null) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, feature));
                bl = true;
            } else if (!bl) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, this.show.getFeature("F:Dummy.MM_Chapters_1_4_Set.MOVIE.Scn")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void UpdateCurrent_MM_Setup() {
        int n = this.getPlaylistID();
        boolean bl = false;
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubID();
        try {
            Feature feature = null;
            int n4 = -1;
            bl = false;
            n4 = this.getAudioID(11, true);
            if (this.getGroupID(n) == this.getGroupID(11) && n2 != n4) {
                this.Store_Streams();
                n4 = n2;
            }
            Assembly assembly = (Assembly)this.show.getFeature("F:MM_Setup.11.SndCurrent.assembly");
            if (n4 == 1) {
                feature = this.show.getFeature("F:MM_Setup.Setup_Audio_1.Current");
            }
            if (n4 == 2) {
                feature = this.show.getFeature("F:MM_Setup.Setup_Audio_2.Current");
            }
            if (n4 == 3) {
                feature = this.show.getFeature("F:MM_Setup.Setup_Subtitle_1.Current");
            }
            if (feature != null) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, feature));
                bl = true;
            } else if (!bl) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, this.show.getFeature("F:Dummy.MM_Setup.11.Snd")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void UpdateCurrent_PM_Chapters_1_4_Set() {
        int n = this.getPlaylistID();
        boolean bl = false;
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubID();
        try {
            Feature feature = null;
            int n4 = -1;
            bl = false;
            n4 = this.getChapterCurPL(4);
            Assembly assembly = (Assembly)this.show.getFeature("F:PM_Chapters_1_4_Set.MOVIE.ScnCurrent.assembly");
            if (n4 == 1) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_1.Current");
            }
            if (n4 == 10) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_10.Current");
            }
            if (n4 == 11) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_11.Current");
            }
            if (n4 == 12) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_12.Current");
            }
            if (n4 == 2) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_2.Current");
            }
            if (n4 == 3) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_3.Current");
            }
            if (n4 == 4) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_4.Current");
            }
            if (n4 == 5) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_5.Current");
            }
            if (n4 == 6) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_6.Current");
            }
            if (n4 == 7) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_7.Current");
            }
            if (n4 == 8) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_8.Current");
            }
            if (n4 == 9) {
                feature = this.show.getFeature("F:PM_Chapters_1_4_Set.Scena_9.Current");
            }
            if (feature != null) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, feature));
                bl = true;
            } else if (!bl) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, this.show.getFeature("F:Dummy.PM_Chapters_1_4_Set.MOVIE.Scn")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void UpdateCurrent_PM_Setup() {
        int n = this.getPlaylistID();
        boolean bl = false;
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubID();
        try {
            Feature feature = null;
            int n4 = -1;
            bl = false;
            n4 = this.getAudioID(11, true);
            if (this.getGroupID(n) == this.getGroupID(11) && n2 != n4) {
                this.Store_Streams();
                n4 = n2;
            }
            Assembly assembly = (Assembly)this.show.getFeature("F:PM_Setup.11.SndCurrent.assembly");
            if (n4 == 1) {
                feature = this.show.getFeature("F:PM_Setup.Setup_Audio_1.Current");
            }
            if (n4 == 2) {
                feature = this.show.getFeature("F:PM_Setup.Setup_Audio_2.Current");
            }
            if (n4 == 3) {
                feature = this.show.getFeature("F:PM_Setup.Setup_Subtitle_1.Current");
            }
            if (feature != null) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, feature));
                bl = true;
            } else if (!bl) {
                this.show.runCommand(new ActivatePartCommand(this.show, assembly, this.show.getFeature("F:Dummy.PM_Setup.11.Snd")));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void Store_Streams() {
        if (this.forceStartVideo) {
            return;
        }
        int n = this.getPlaylistID();
        int n2 = this.getCurrentAudioID();
        int n3 = this.getCurrentSubNumber();
        boolean bl = this.getCurrentSubState();
        switch (n) {
            case 2: {
                this.selectAudioSubtitleStream(2, n2, n3, bl, false);
                break;
            }
            case 3: {
                this.selectAudioSubtitleStream(3, n2, n3, bl, false);
                break;
            }
            case 4: {
                this.selectAudioSubtitleStream(4, n2, n3, bl, false);
                break;
            }
            case 5: {
                this.selectAudioSubtitleStream(5, n2, n3, bl, false);
                break;
            }
            case 12: {
                this.selectAudioSubtitleStream(12, n2, n3, bl, false);
                break;
            }
            case 6: {
                this.selectAudioSubtitleStream(6, n2, n3, bl, false);
                break;
            }
            case 7: {
                this.selectAudioSubtitleStream(7, n2, n3, bl, false);
                break;
            }
            case 8: {
                this.selectAudioSubtitleStream(8, n2, n3, bl, false);
                break;
            }
            case 9: {
                this.selectAudioSubtitleStream(9, n2, n3, bl, false);
                break;
            }
            case 10: {
                this.selectAudioSubtitleStream(10, n2, n3, bl, false);
                break;
            }
            case 11: {
                this.selectAudioSubtitleStream(11, n2, n3, bl, false);
            }
        }
    }

    public int getGroupID(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case 9: {
                n2 = 9;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 11: {
                n2 = 11;
            }
        }
        return n2;
    }

    public void Close_Popup() {
        if (this.scaleON) {
            this.scaleBack();
        }
        this.activateSegment("S:Movie");
    }

    public void restoreStreams() {
        this.restoreAudioSubtitle(2);
        this.restoreAudioSubtitle(3);
        this.restoreAudioSubtitle(4);
        this.restoreAudioSubtitle(5);
        this.restoreAudioSubtitle(12);
        this.restoreAudioSubtitle(6);
        this.restoreAudioSubtitle(7);
        this.restoreAudioSubtitle(8);
        this.restoreAudioSubtitle(9);
        this.restoreAudioSubtitle(10);
        this.restoreAudioSubtitle(11);
    }
}

