/*
 * Decompiled with CFR 0.152.
 */
package com.disc_art_authoring.bdjmenu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;

public class BookMarkHelper {
    private TreeSet bookmarks;
    private String bookmarkFileName;
    private Object[] bmArray = null;
    private boolean actualArray = false;
    private Iterator iterator = null;
    private int currBM = -1;
    private static final long NANO_IN_SECOND = 1000000000L;

    public BookMarkHelper(String string) {
        this.bookmarkFileName = string;
        this.bookmarks = new TreeSet();
    }

    private String getBookmarkFile() {
        return System.getProperty("dvb.persistent.root") + this.bookmarkFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFile() {
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        boolean bl = false;
        this.actualArray = false;
        try {
            String string;
            fileReader = new FileReader(this.getBookmarkFile());
            bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    if (string.length() > 0) {
                        this.bookmarks.add(new Long(string));
                    }
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile() {
        PrintWriter printWriter = null;
        try {
            File file = new File(this.getBookmarkFile());
            if (file.exists()) {
                file.delete();
            }
            file = null;
            printWriter = new PrintWriter(new FileWriter(this.getBookmarkFile()));
            Iterator iterator = this.bookmarks.iterator();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                printWriter.println(l);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void actualizeArray() {
        if (!this.actualArray) {
            this.bmArray = this.bookmarks.toArray();
            this.actualArray = true;
        }
        if (this.currBM < 0) {
            this.currBM = 0;
        }
        if (this.currBM > this.bmArray.length - 1) {
            this.currBM = this.bmArray.length - 1;
        }
    }

    public int currentIdx() {
        this.actualizeArray();
        return this.currBM;
    }

    public long currentTime() {
        this.actualizeArray();
        if (this.currBM < 0) {
            return -1L;
        }
        return (Long)this.bmArray[this.currBM] * 1000000000L;
    }

    public void nextCurrent() {
        ++this.currBM;
        this.actualizeArray();
    }

    public void prevCurrent() {
        --this.currBM;
        this.actualizeArray();
    }

    public void firstCurrent() {
        this.currBM = 0;
        this.actualizeArray();
    }

    public void lastCurrent() {
        this.actualizeArray();
        this.currBM = this.bmArray.length - 1;
    }

    public long getTime(int n) {
        this.actualizeArray();
        if (n < 0 || n >= this.bmArray.length) {
            return -1L;
        }
        return (Long)this.bmArray[n] * 1000000000L;
    }

    public int getIndex(long l) {
        this.actualizeArray();
        l /= 1000000000L;
        for (int i = 0; i < this.bmArray.length; ++i) {
            if ((Long)this.bmArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public int count() {
        return this.bookmarks.size();
    }

    public int add(long l) {
        this.currBM = this.getIndex(l);
        if (this.currBM > -1) {
            return this.currBM;
        }
        this.bookmarks.add(new Long(l / 1000000000L));
        this.actualArray = false;
        this.currBM = this.getIndex(l);
        return this.currBM;
    }

    public void delete(long l) {
        l /= 1000000000L;
        Iterator iterator = this.bookmarks.iterator();
        Long l2 = null;
        while (iterator.hasNext() && (l2 = (Long)iterator.next()) != l) {
            l2 = null;
        }
        if (l2 != null) {
            this.bookmarks.remove(l2);
            this.actualArray = false;
            this.actualizeArray();
        }
        iterator = null;
    }

    public void delete(Long l) {
        this.bookmarks.remove(l);
        this.actualArray = false;
    }

    public void removeAll() {
        this.bookmarks.clear();
        this.currBM = 0;
        this.actualArray = false;
        this.actualizeArray();
    }

    public Iterator iterator() {
        return this.bookmarks.iterator();
    }
}

