/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.features;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class Assembly
extends Feature
implements Node {
    protected String[] partNames;
    protected Feature[] parts;
    protected Feature currentFeature = null;
    protected boolean activated = false;
    private int numSetupChecked;

    public Assembly(Show show) {
        super(show);
    }

    public void setParts(String[] partNames, Feature[] parts) {
        this.partNames = partNames;
        this.parts = parts;
        this.currentFeature = parts[0];
    }

    protected Feature createClone(HashMap clones) {
        if (!this.isSetup() || this.activated) {
            throw new IllegalStateException();
        }
        Assembly result = new Assembly(this.show);
        int found = -1;
        result.partNames = this.partNames;
        result.parts = new Feature[this.parts.length];
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.currentFeature == this.parts[i]) {
                found = i;
            }
            result.parts[i] = this.parts[i].makeNewClone(clones);
        }
        if (found != -1) {
            result.currentFeature = result.parts[found];
        }
        result.numSetupChecked = this.numSetupChecked;
        return result;
    }

    public void addSubgraph(HashSet set) {
        if (set.contains(this)) {
            return;
        }
        super.addSubgraph(set);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].addSubgraph(set);
        }
    }

    public int getX() {
        return this.currentFeature.getX();
    }

    public int getY() {
        return this.currentFeature.getY();
    }

    public String[] getPartNames() {
        return this.partNames;
    }

    public Feature[] getParts() {
        return this.parts;
    }

    public void initialize() {
    }

    public void destroy() {
    }

    protected void setActivateMode(boolean mode) {
        this.activated = mode;
        if (mode) {
            this.currentFeature.activate();
        } else {
            this.currentFeature.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentFeature(Feature feature) {
        Show show = this.show;
        synchronized (show) {
            if (this.currentFeature == feature) {
                return;
            }
            if (this.activated) {
                feature.activate();
                this.currentFeature.deactivate();
                this.show.getDirector().notifyAssemblyPartSelected(this, feature, this.currentFeature, this.activated);
            }
            this.currentFeature = feature;
        }
    }

    protected int setSetupMode(boolean mode) {
        if (mode) {
            this.numSetupChecked = 0;
            int num = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                num += this.parts[i].setup();
            }
            return num;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].unsetup();
        }
        return 0;
    }

    public boolean needsMoreSetup() {
        while (this.numSetupChecked < this.parts.length) {
            if (this.parts[this.numSetupChecked].needsMoreSetup()) {
                return true;
            }
            ++this.numSetupChecked;
        }
        return false;
    }

    public Feature findPart(String name) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (!this.partNames[i].equals(name)) continue;
            return this.parts[i];
        }
        return null;
    }

    public Feature getCurrentPart() {
        return this.currentFeature;
    }

    public void markDisplayAreasChanged() {
        this.currentFeature.markDisplayAreasChanged();
    }

    public void addDisplayAreas(RenderContext context) {
        this.currentFeature.addDisplayAreas(context);
    }

    public void paintFrame(Graphics2D gr) {
        this.currentFeature.paintFrame(gr);
    }

    public void nextFrame() {
        this.currentFeature.nextFrame();
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        in.readSuperClassData(this);
        this.setParts(in.readStringArray(), in.readFeaturesArrayReference());
    }
}

