/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin;

import com.hdcookbook.grin.GrinXHelper;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.animator.RenderContext;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.util.Debug;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Feature {
    protected Show show;
    protected String name = null;
    private int activateCount = 0;
    private int setupCount = 0;
    private Command featureSetupCommand = null;

    protected Feature(Show show) {
        this.show = show;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getX();

    public abstract int getY();

    public String toString() {
        return super.toString() + "(" + this.name + ")";
    }

    public abstract void initialize();

    public abstract void destroy();

    protected abstract int setSetupMode(boolean var1);

    protected abstract void setActivateMode(boolean var1);

    public abstract boolean needsMoreSetup();

    public final int setup() {
        ++this.setupCount;
        if (this.setupCount == 1) {
            return this.setSetupMode(true);
        }
        return 0;
    }

    public final void unsetup() {
        --this.setupCount;
        if (this.setupCount == 0) {
            this.setSetupMode(false);
        }
    }

    public final boolean isSetup() {
        return this.setupCount > 0;
    }

    public final void activate() {
        ++this.activateCount;
        if (this.activateCount == 1) {
            this.setActivateMode(true);
        }
    }

    public final void deactivate() {
        --this.activateCount;
        if (this.activateCount == 0) {
            this.setActivateMode(false);
        }
    }

    protected void sendFeatureSetup() {
        if (this.featureSetupCommand == null) {
            GrinXHelper c2 = new GrinXHelper(this.show);
            c2.setCommandNumber(2);
            this.featureSetupCommand = c2;
        }
        this.show.runCommand(this.featureSetupCommand);
    }

    public abstract void addDisplayAreas(RenderContext var1);

    public abstract void markDisplayAreasChanged();

    public abstract void paintFrame(Graphics2D var1);

    public abstract void nextFrame();

    public final void resetFeature() {
        if (this.activateCount > 0) {
            this.setActivateMode(false);
            this.setActivateMode(true);
        }
    }

    public final Feature cloneSubgraph(HashMap clones) {
        if (!clones.isEmpty()) {
            Debug.assertFail();
        }
        Feature result = this.makeNewClone(clones);
        if (clones.get(this) == null) {
            Debug.assertFail();
        }
        Iterator it = clones.keySet().iterator();
        while (it.hasNext()) {
            Feature key = (Feature)it.next();
            Feature value = (Feature)clones.get(key);
            value.initializeClone(key, clones);
        }
        return result;
    }

    public final Feature makeNewClone(HashMap clones) {
        Feature clone = (Feature)clones.get(this);
        if (clone == null) {
            clone = this.createClone(clones);
            if (clones.get(this) != null) {
                Debug.assertFail();
            }
            clones.put(this, clone);
        }
        return clone;
    }

    protected Feature createClone(HashMap clones) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".createClone()");
    }

    protected void initializeClone(Feature original, HashMap clones) {
    }

    public final void destroyClonedSubgraph() {
        HashSet set = new HashSet();
        this.addSubgraph(set);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            f.destroy();
        }
    }

    public void addSubgraph(HashSet set) {
        set.add(this);
    }

    protected static Feature clonedReference(Feature f, HashMap clones) {
        if (f == null) {
            return null;
        }
        Object result = clones.get(f);
        if (result == null) {
            return f;
        }
        return (Feature)result;
    }

    protected static Command[] cloneCommands(Command[] commands, HashMap clones) {
        if (commands == null || commands.length == 0) {
            return commands;
        }
        Command[] result = new Command[commands.length];
        boolean changed = false;
        for (int i = 0; i < commands.length; ++i) {
            result[i] = commands[i].cloneIfNeeded(clones);
            changed = changed || result[i] != commands[i];
        }
        if (!changed) {
            result = commands;
        }
        return result;
    }
}

