
# Superhandleiding V3 — Jellyfin + TVHeadend + IPTV Splitter + VOD (.STRM) + EPG (TrueNAS SCALE)

**Stack**: Jellyfin (iGPU), TVHeadend (PVR), M3U Splitter + NGINX (8099), VOD .STRM Generator, EPG mirror  
**Opslag**: QNAP TL‑D800C → `/mnt/QNAP-TL-D800C/Media`  
**DVR**: `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin` (Jellyfin) + `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend` (TVH)  
**IP** voorbeeld: `192.168.2.84`

---

## 1) Mappen & bestanden
Maak deze paden aan (rechten: lees/schrijf voor de containers):
```
/mnt/Applications/Apps/m3u-splitter/{data,out,config,app}
/mnt/Applications/Apps/m3u-vod-strm/{data,out,app}
/mnt/Applications/Apps/tvheadend/config
/mnt/QNAP-TL-D800C/Media/DVR/{Jellyfin,TVHeadend}
```
Plaats je bestanden:
```
/mnt/Applications/Apps/m3u-splitter/data/master.m3u      ← je volledige master
/mnt/Applications/Apps/m3u-splitter/config/include_groups.txt   ← leeg = ALLES
/mnt/Applications/Apps/m3u-splitter/config/exclude_groups.txt   ← leeg = niets blokkeren
/mnt/Applications/Apps/m3u-vod-strm/data/movies.m3u
/mnt/Applications/Apps/m3u-vod-strm/data/series.m3u
```

---

## 2) Stack starten
Gebruik **jellyfin-all-in-one.compose.yaml** (nu inclusief **TVHeadend**):
- Jellyfin (met `/recordings` → `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`)
- M3U Splitter + NGINX (op 8099)
- VOD .STRM Generator
- EPG mirror → `http://192.168.2.84:8099/epg.xml`
- TVHeadend (9981/9982) met PVR op `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`

Start:
```bash
docker compose -f jellyfin-all-in-one.compose.yaml up -d
```

Controle:
- Splitter index: `http://192.168.2.84:8099/m3u/index.html` (1 .m3u per group-title)
- EPG mirror: `http://192.168.2.84:8099/epg.xml`
- TVHeadend: `http://192.168.2.84:9981` (WebUI)

---

## 3) Live TV via Jellyfin (rechtstreeks op je M3U-groepen)
**Tuners (per groep):**
1. Jellyfin → *Dashboard → Live TV → Add → M3U Tuner*
2. URL: kopieer uit Splitter, bv. `http://192.168.2.84:8099/m3u/Netherlands.m3u`  
3. Zet **Allow stream sharing** = aan, **Ignore DTS** = aan, stel evt. **Simultaneous stream limit**.
4. Voeg desgewenst meerdere groepen toe (zie `TUNERS-ALL-URLs.txt`).

**EPG:**
- *Live TV → Guide Data → Add → XMLTV* → **`http://192.168.2.84:8099/epg.xml`** (mirror van `https://epg.iptv.cat/epg.xml`).
- *Map Channels* (tvg-id ↔ gids).

**PVR (Jellyfin):**
- *Live TV → Recording* → **Recordings path**: `/recordings` (gemount naar `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`)  
- Padding 2–3 min. Voeg de DVR-map ook toe als **Library** (Movies/TV).

---

## 4) TVHeadend (optioneel/aanbevolen PVR)
**Doel**: robuustere HLS handling, seriesregels, timeshift, multi-EPG.  
WebUI: `http://192.168.2.84:9981`

### 4.1 Eerste setup
1. Maak **Admin user** in de wizard.  
2. *Configuration → DVB Inputs → Networks → Add → IPTV Automatic Network*  
   - **URL**: `/mnt/Applications/Apps/m3u-splitter/out/m3u/Netherlands.m3u` of je **master** URL (indien extern bereikbaar).  
   - Alternatief: upload **master.m3u** (TVH → *Add* → *M3U*).  
3. *Services* verschijnen → *Map Services to Channels*.
4. *Channel / EPG → Channel Tags*: maak tags (Netherlands/UK/Sports/XXX) en schakel toe.

### 4.2 EPG in TVH
- *Configuration → Channel / EPG → EPG Grabber Modules*: zet **External XMLTV** aan.  
- *Channel / EPG → XMLTV* → **File path/URL**: `http://192.168.2.84:8099/epg.xml`  
  (of mount de XML lokaal). Map zenders indien nodig.

### 4.3 DVR-profielen
- *Configuration → Recording → DVR Profiles*  
  - **Recording system path**: `/recordings` → (gemount naar `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`)  
  - **Pre/Post**: 2–3 min, **Stream type**: `Pass-through` (of transcode-profiel).

### 4.4 Jellyfin koppelen aan TVH
Twee smaken:
- **Per Tag → exporteer M3U** in TVH en voeg die als **M3U Tuner** toe in Jellyfin.  
- **TVHeadend plugin** in Jellyfin (indien geïnstalleerd) → gebruik HTSP (`9982`).

> Voordeel van TVH → per Tag eigen “tuner”, goede PVR/logica; je kunt alsnog je Splitter blijven gebruiken voor directe groep-tuners.

---

## 5) VOD (Movies/Series) via .STRM
**Input**: jouw `Movies.m3u` en `Series.m3u` met `group-title` en/of `#EXTGRP:Action;Crime;...`.  
**Uitvoer**: mappen voor Jellyfin libraries:
```
/mnt/Applications/Apps/m3u-vod-strm/out/Movies/<Genre>/<Titel (Jaar)>/<Titel (Jaar)>.strm
/mnt/Applications/Apps/m3u-vod-strm/out/TV/<Genre>/<Serie>/Season 01/<Serie S01E01>.strm
```
- `tvg-logo` → `poster.jpg`.  
- `SxxEyy` wordt gedetecteerd, anders wordt **Season 01** gebruikt.  
**Jellyfin**: voeg **Movies** en **TV Shows** libraries toe en scan.

---

## 6) Presets, tuners & exports
- **include_groups.txt** = leeg → ALLES (of gebruik `include_groups.family.txt` voor familieprofiel).  
- **exclude_groups.txt** = leeg (of gebruik `exclude_groups.family.txt` om adult-groepen te blokkeren).  
- **TUNERS-ALL-URLs.txt** → alle group-URL’s kant‑en‑klaar.  
- **CHANNELS-ALL.csv** → elk kanaal (kolommen: group, tvg-id, tvg-name, tvg-logo, name, url).

---

## 7) Nummers & blokken (advies)
- NL **101–199**, UK **201–299**, Sports **401–499**, Kids **501–549**, Docs **551–599**, XXX **901–999**.  
- Je kunt nummers vooraf meegeven in M3U met `tvg-chno="101"` of na import in Jellyfin/TVH instellen.

---

## 8) Tips & problemen
- **User-Agent** in tuners instellen indien provider dit vereist.  
- **Stream limit** afstemmen op abonnement.  
- **Ignore DTS** helpt tegen A/V-sync.  
- **Stotteren/Seek**: test via TVHeadend; vergroot padding; verlaag fallback‑bitrate.  
- **Security**: services alleen LAN of achter VPN/reverse proxy.

---

## 9) Juridisch
Gebruik alleen bronnen waarvoor je rechten/abonnement hebt; controleer lokale wetgeving en provider‑voorwaarden.
