# Super-Turnkey Handleiding — **Jellyfin + TVHeadend + IPTV Splitter + VOD (.STRM) + EPG**  
*(TrueNAS SCALE · volledig n00b-proof · NL)*

> Deze gids zet je **hele stack** werkend neer: Live-TV met **M3U per groep**, **EPG**, **opnames (DVR)** naar je **QNAP TL-D800C** pool, én **VOD Films/Series** via `.strm`. Alles is “press-play”—je hoeft alleen paden te maken, bestanden neer te zetten en de compose te starten.

---

## 0) In 1 minuut (wat je krijgt)

- **M3U Splitter + NGINX (poort 8099)**  
  Leest je **grote master.m3u** en maakt **1 M3U per group-title** (bijv. *Netherlands*, *UK News*, *Canada Sports*, *XXX*).  
  → Je voegt in Jellyfin **één tuner per groep** toe: superoverzichtelijk.

- **EPG mirror**  
  Haalt automatisch **`https://epg.iptv.cat/epg.xml`** op en serveert lokaal als:  
  **`http://192.168.2.84:8099/epg.xml`** (snel en stabiel).

- **Jellyfin (met DVR mount)**  
  Opnames gaan naar: **`/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`**.

- **TVHeadend (optioneel, geavanceerde PVR)**  
  Opnames: **`/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`**.

- **VOD .STRM generator**  
  Leest je **Movies.m3u** & **Series.m3u** (met `group-title`/`#EXTGRP`) → maakt **.strm** bibliotheken voor Jellyfin:
  - Films → `/out/Movies/<Genre>/<Titel (Jaar)>/<Titel (Jaar)>.strm`  
  - Series → `/out/TV/<Genre>/<Show>/Season 01/<Show S01E01>.strm`

- **Optionele kanaalnummering (kant-en-klaar)**  
  Gebruik **`master.with_numbers.m3u`** (al voorzien van `tvg-chno`) of de “platte” **`master.m3u`**.

---

## 1) Vereisten & paden

### 1.1 Maak deze mappen op TrueNAS
```bash
# Live-TV splitter
/mnt/Applications/Apps/m3u-splitter/data
/mnt/Applications/Apps/m3u-splitter/out
/mnt/Applications/Apps/m3u-splitter/config
/mnt/Applications/Apps/m3u-splitter/app

# VOD (.strm) generator
/mnt/Applications/Apps/m3u-vod-strm/data
/mnt/Applications/Apps/m3u-vod-strm/out
/mnt/Applications/Apps/m3u-vod-strm/app

# TVHeadend config
/mnt/Applications/Apps/tvheadend/config

# DVR (QNAP TL-D800C)
/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin
/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend
```

> **Tip (rechten):** geef de mappen in eerste instantie **0775/0777** (schrijven/lezen). Als alles draait, mag je rechten strakker zetten.

### 1.2 Plaats de kant-en-klare bestanden (uit de ZIP)

**Live-TV (master M3U):**
- **Kies één van de twee** en **hernoem** naar `master.m3u`:
  - **Genummerd** (aanbevolen voor vaste kanaalnrs):  
    `/mnt/Applications/Apps/m3u-splitter/data/master.m3u`  ← *(inhoud van `master.with_numbers.m3u`)*  
  - **Zonder nummers** (vrij ingeven in Jellyfin):  
    `/mnt/Applications/Apps/m3u-splitter/data/master.m3u`  ← *(inhoud van `master.m3u`)*

**Groepsfilters (optioneel):**
```
/mnt/Applications/Apps/m3u-splitter/config/include_groups.txt   ← leeg = ALLES
/mnt/Applications/Apps/m3u-splitter/config/exclude_groups.txt   ← leeg = niets blokkeren
```
> Je kunt later presets gebruiken (bijv. familie-only): `include_groups.family.txt` / `exclude_groups.family.txt`.

**VOD M3U’s:**
```
/mnt/Applications/Apps/m3u-vod-strm/data/movies.m3u
/mnt/Applications/Apps/m3u-vod-strm/data/series.m3u
```

---

## 2) Stack starten (alles in 1 keer)

Je hebt een compose met **Jellyfin + Splitter + NGINX + EPG mirror + VOD .STRM + TVHeadend**:  
**`jellyfin-all-in-one.compose.yaml`**

### 2.1 TrueNAS SCALE (aanrader)
- Apps → **Launch Docker Compose App** → upload de compose of plak de inhoud.  
- Start de app.

### 2.2 CLI (alternatief)
```bash
docker compose -f jellyfin-all-in-one.compose.yaml up -d
```

---

## 3) Controleren of alles draait

- **Splitter index (per-groep M3U):**  
  `http://192.168.2.84:8099/m3u/index.html`  
  → Je ziet bijv. **Netherlands.m3u**, **UK News.m3u**, **Canada Sports.m3u**, **XXX.m3u**, …

- **Lokale EPG (mirror):**  
  `http://192.168.2.84:8099/epg.xml`

- **TVHeadend WebUI:**  
  `http://192.168.2.84:9981`

- **Jellyfin:**  
  (jouw bestaande Jellyfin-adres/poort)

> **Let op:** als 8099/9981 niet bereikbaar zijn, check of de app aan staat en poorten niet geblokkeerd worden door een firewall.

---

## 4) Jellyfin — Live-TV instellen (eenmalig)

### 4.1 M3U tuners (per groep één tuner)
1. Jellyfin → **Dashboard → Live TV → Add → M3U Tuner**  
2. **URL**: kopieer uit de Splitter index, bv.:  
   - `http://192.168.2.84:8099/m3u/Netherlands.m3u`  
   - `http://192.168.2.84:8099/m3u/UK%20News.m3u`  
   - `http://192.168.2.84:8099/m3u/Canada%20Sports.m3u`  
3. **Enable** (aan), **Allow stream sharing** (aan), **Ignore DTS** (aan).  
4. (Optioneel) **Simultaneous stream limit**: stel volgens je provider in.

> TIP: In de ZIP staat **`TUNERS-ALL-URLs.txt`**: copy/paste-lijst met alle groep-URL’s.

### 4.2 EPG (gids) toevoegen
- **Dashboard → Live TV → Guide Data → Add → XMLTV**  
  Plak: **`http://192.168.2.84:8099/epg.xml`**  
- Daarna **Map Channels**: koppel kanalen aan gidsitems (tvg-id helpt).

### 4.3 PVR (opnames) in Jellyfin
- **Dashboard → Live TV → Recording**  
  - **Recordings path**: `/recordings` *(is gemount naar `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`)*  
  - **Pre/Post padding**: 2–3 minuten  
- Voeg de map **`/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`** ook toe als **Library** (Movies/TV) voor mooie posters.

---

## 5) (Optioneel) TVHeadend — pro PVR & tagging

**Waarom TVH?** Sterke seriesregels, timeshift en stabielere HLS opname.

### 5.1 Eerste setup
1. Ga naar `http://192.168.2.84:9981` → maak **Admin**.  
2. **Configuration → DVB Inputs → Networks → Add → IPTV Automatic Network**  
   - **Playlist**: gebruik je **master.m3u** of een **per-groep M3U** uit de Splitter.  
3. Wacht tot **Services** zichtbaar → **Map Services to Channels**.  
4. **Channel / EPG → Channel Tags**: maak tags (Netherlands, UK, Sports, XXX, …) en koppel zenders.

### 5.2 EPG in TVH
- **Configuration → Channel / EPG → EPG Grabber Modules** → zet **External XMLTV** aan.  
- **Channel / EPG → XMLTV** → **URL**: `http://192.168.2.84:8099/epg.xml`  
- Map zenders waar nodig.

### 5.3 TVH-opnames
- **Configuration → Recording → DVR Profiles**  
  - **Recording path**: `/recordings` *(is gemount naar `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`)*  
  - **Pre/Post**: 2–3 min, **Stream type**: `Pass-through`.

### 5.4 Koppelen aan Jellyfin
- **Optie A:** Exporteer per **Tag** in TVH een M3U en voeg die als tuner toe in Jellyfin.  
- **Optie B:** Jellyfin TVH-plugin + **HTSP** (poort **9982**).

---

## 6) VOD (Films & Series) via **.STRM**

### 6.1 Hoe het werkt
- De service leest **`movies.m3u`** en **`series.m3u`** met `group-title` en/of `#EXTGRP`.  
- Bouwt mappen en `.strm` bestanden zodat Jellyfin ze ziet als normale bibliotheken.  
- **Posters** worden (indien aanwezig) uit `tvg-logo` gedownload naar `poster.jpg`.

**Uitvoer-structuur:**
```
/mnt/Applications/Apps/m3u-vod-strm/out/Movies/<Genre>/<Titel (Jaar)>/<Titel (Jaar)>.strm
/mnt/Applications/Apps/m3u-vod-strm/out/TV/<Genre>/<Show>/Season 01/<Show S01E01>.strm
```

### 6.2 In Jellyfin toevoegen (eenmalig)
- **Libraries → Add Library**  
  - **Movies** → `/mnt/Applications/Apps/m3u-vod-strm/out/Movies`  
  - **TV Shows** → `/mnt/Applications/Apps/m3u-vod-strm/out/TV`  
- **Scan** starten → klaar.

> **Tip:** wil je alleen bepaalde genres genereren? Gebruik env-vars in de compose:  
> `MOVIES_INCLUDE=Action,Comedy` / `SERIES_EXCLUDE=XXX`

---

## 7) Kanaalnummering (optioneel, maar lekker)

- In de ZIP vind je:
  - **`master.with_numbers.m3u`** → alle kanalen hebben **`tvg-chno`** (bv. NL 101+, UK 201+, Sports 401+, XXX 901+).  
  - **`CHANNEL_NUMBERS_PLAN.csv`** → compleet overzicht (groep, nummer, naam, tvg-id, …).

**Wil je vaste nummers?**  
Gebruik **`master.with_numbers.m3u`** als **master** (hernoem naar `master.m3u`). De Splitter behoudt de nummers.

**Lievere losse nummering?**  
Gebruik de “platte” **`master.m3u`** en nummer per kanaal in Jellyfin/TVH.

---

## 8) Groepen filteren (optioneel)

- **Alles meenemen** → laat `include_groups.txt` **leeg**.  
- **Wat blokkeren** → zet bv. `XXX` in `exclude_groups.txt`.  
- **Familie-only** → kopieer `include_groups.family.txt` → `include_groups.txt` en `exclude_groups.family.txt` → `exclude_groups.txt`.

**Herstart** de splitter-service als je filters wijzigt (of wacht tot de automatische refresh).

---

## 9) Dagelijkse workflow

- **Kijken**: Jellyfin → Live TV → Channels/Guide.  
- **Opnemen (Jellyfin)**: Guide → selecteer programma → **Record** (Series/Once).  
- **Opnemen (TVH)**: TVHeadend → EPG → **Record** (met je DVR-profiel).  
- **VOD**: Jellyfin → Movies/TV Shows (afspelen als normale content).

---

## 10) Troubleshooting (kort & duidelijk)

- **Kanaal speelt niet** → test de M3U-URL in **VLC**. Vaak is het bron/abonnement/geo-issue.  
- **Geen EPG** → check `http://192.168.2.84:8099/epg.xml`, voeg opnieuw toe, **Map Channels**.  
- **Haperingen / A/V-sync** → zet **Ignore DTS** **aan** in de tuner; verlaag **Fallback bitrate**; overweeg TVHeadend.  
- **Opnames missen begin/einde** → verhoog **Pre/Post padding**.  
- **Geen VOD in Jellyfin** → controleer of `.strm` mappen gevuld zijn en of de bibliotheken goed verwijzen.  
- **Permissies** → test tijdelijk 0777 op target-mappen; als het werkt, weer aanscherpen.  
- **Poorten** → 8099 (NGINX), 9981/9982 (TVH) moeten op je LAN bereikbaar zijn.

---

## 11) Veiligheid & onderhoud

- **Zet services alleen open op LAN** of achter **VPN/reverse proxy** met login.  
- **Respecteer stream-limieten** van je provider (Simultaneous stream limit).  
- **Back-ups**: bewaar je **compose** en `/config` mappen.  
- **Updates**: Linuxserver.io TVH en NGINX/Alpine images regelmatig vernieuwen.

---

## 12) Spiekbriefje (alle paden/poorten/bestanden)

**Paden (host):**
```
Live-TV Splitter data:   /mnt/Applications/Apps/m3u-splitter/data
Live-TV Splitter out:    /mnt/Applications/Apps/m3u-splitter/out
Live-TV Splitter config: /mnt/Applications/Apps/m3u-splitter/config
VOD data:                /mnt/Applications/Apps/m3u-vod-strm/data
VOD out:                 /mnt/Applications/Apps/m3u-vod-strm/out
TVHeadend config:        /mnt/Applications/Apps/tvheadend/config
DVR Jellyfin:            /mnt/QNAP-TL-D800C/Media/DVR/Jellyfin
DVR TVHeadend:           /mnt/QNAP-TL-D800C/Media/DVR/TVHeadend
```

**Belangrijke poorten & URL’s:**
```
Splitter index (per groep): http://192.168.2.84:8099/m3u/index.html
Lokale EPG (XMLTV):         http://192.168.2.84:8099/epg.xml
TVHeadend UI:               http://192.168.2.84:9981
```

**Belangrijke bestanden (uit de ZIP):**
```
jellyfin-all-in-one.compose.yaml
master.m3u / master.with_numbers.m3u (kies 1 → hernoem naar master.m3u)
Movies.m3u, Series.m3u
include_groups.txt, exclude_groups.txt (filters)
TUNERS-ALL-URLs.txt (alle per-groep tuner-URL’s)
CHANNELS-ALL.csv (alle kanalen)
CHANNEL_NUMBERS_PLAN.csv (nummerplan)
```

---

## 13) Reset / Clean (als je even “schoon” wilt beginnen)

1. **Stop** de compose/app.  
2. Leeg (indien gewenst) de **out**-mappen:
   ```
   /mnt/Applications/Apps/m3u-splitter/out
   /mnt/Applications/Apps/m3u-vod-strm/out
   ```
3. Zet je gewenste **filters** (include/exclude).  
4. Start de compose/app opnieuw.

---

### Klaar!  
Met dit stappenplan kun je **van niets naar alles** in één keer: per-groep M3U-tuners, lokale EPG, opnames naar je **QNAP TL-D800C /Media/DVR**, en VOD als nette bibliotheken.
