
# Jellyfin + IPTV/VOD — Superhandleiding (TrueNAS SCALE)
**Één grote M3U → nette groepen + PVR (opnames) op `/mnt/QNAP-TL-D800C/Media/DVR` + VOD via .STRM**  
Auteur: **Marco Salentijn & ChatGPT** — Server-IP (voorbeeld): **192.168.2.84**  
Apps-dataset: **/mnt/Applications/Apps** · Media-dataset: **/mnt/QNAP-TL-D800C/Media**

> **Doel in 1 regel:**  
> Je hebt één **grote M3U** met veel *group-title*’s (NL, UK, Sports, XXX, …). We **knippen** die automatisch per groep tot losse M3U’s (voor Live TV in Jellyfin) en zetten VOD-M3U’s (films/series) om naar **.strm** mappen zodat ze als **normale bibliotheken** werken. **Alle opnames** (Jellyfin of TVHeadend) gaan naar **`/mnt/QNAP-TL-D800C/Media/DVR`**.

---

## Inhoud
1. Overzicht & keuzes
2. Paden & vereisten
3. Live TV — M3U Splitter + Webserver
4. Jellyfin — Tuners, EPG & kanaalnummers
5. **PVR/Opnames in Jellyfin → `/mnt/QNAP-TL-D800C/Media/DVR`**
6. Optioneel: TVHeadend (krachtige PVR) → `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`
7. VOD (Movies/Series) — M3U → STRM bibliotheken
8. Beheer, performance & veiligheid
9. Troubleshooting
10. Bijlagen: YAML’s, filters & voorbeelden

---

## Overzicht & keuzes
**Waarom een tussenlaag?** Jellyfin toont geen “secties” per M3U; alle kanalen komen in één lijst. Met de **M3U Splitter** expose je voor elke groep (NL/UK/Sports/…) een **aparte M3U-uitgang**. In Jellyfin voeg je die toe als **losse tuner** — heel beheerbaar en stabiel.

**PVR:**  
- **Snel & simpel:** PVR in **Jellyfin** zelf (opnames gaan naar `/mnt/QNAP-TL-D800C/Media/DVR`).  
- **Geavanceerd:** **TVHeadend** (tags, regels, timeshift); opnames naar `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend` en als bibliotheek in Jellyfin tonen.

**VOD (self-hosted Movies/Series M3U):** zet om naar **.strm** mappen; Jellyfin ziet ze als gewone films/series met posters.

---

## Paden & vereisten
- **Apps (Compose) root:** `/mnt/Applications/Apps`
- **Media dataset:** `/mnt/QNAP-TL-D800C/Media`
- **Opnames:**  
  - **Jellyfin PVR** → **`/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`**  
  - **TVHeadend PVR** → **`/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`**
- **Tijdzone:** `Europe/Amsterdam`
- **Jellyfin** draait al (Docker/Custom App).

Maak (desnoods via SMB) de volgende mappen aan als ze nog niet bestaan:
```
/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin
/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend
```

**Kanaalnummer-blokken (advies):**
- NL: **101–199**, UK: **201–299**, Sports: **401–499**, Kids: **501–549**, Docs: **551–599**, XXX: **901–999**.

Voorbeeldregel in je M3U (veilig voor alle tools):
```m3u
#EXTINF:-1 tvg-id="npo1.nl" tvg-name="NL · NPO 1" tvg-chno="101" group-title="Netherlands",NL · NPO 1
http://provider.example/stream.m3u8
```

---

## Live TV — M3U Splitter + Webserver
(zelfde als eerdere versie; geen DVR-pad nodig)

*Web index:* `http://192.168.2.84:8099/m3u/index.html`  
*Voorbeeld tuner-URL’s:* `.../Netherlands.m3u`, `.../UK%20News.m3u`, `.../Canada%20Sports.m3u`, `.../XXX.m3u`

---

## Jellyfin — Tuners, EPG & kanaalnummers
**Per groep = één M3U Tuner** (Allow stream sharing **aan**, Ignore DTS **aan**).  
EPG: één XMLTV-bron is voldoende en daarna *Map Channels*.

---

## PVR/Opnames in Jellyfin → `/mnt/QNAP-TL-D800C/Media/DVR`
**Mount in Jellyfin-container** (TrueNAS App / Compose):
- **Host path**: `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin`  
- **Container path**: `/recordings`

**Jellyfin instellingen**
- *Dashboard → Live TV → Recording*  
  - **Recordings path**: `/recordings`  
  - **Pre/Post padding**: 2–3 min (meer bij onzekere gids)  
  - **Keep**: *until space needed* of *keep N recordings*
- Plan opnames vanuit *Guide* (Once/Series).
- Voeg **ook** `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin` toe als **Library** (Movies/TV) voor metadata/posters.

> **Tip:** Bij streams met rare timestamps: zet **Ignore DTS** aan in de tuner.

---

## Optioneel: TVHeadend (krachtige PVR) → `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend`
Compose volume-lijn aangepast:
```yaml
volumes:
  - /mnt/Applications/Apps/tvheadend/config:/config
  - /mnt/QNAP-TL-D800C/Media/DVR/TVHeadend:/recordings   # ← op QNAP-TL-D800C pool
```

TVH WebUI: `http://192.168.2.84:9981` → Admin aanmaken → IPTV Automatic Network met jouw master M3U → Services mappen → Channel Tags (Netherlands/UK/Sports/XXX) → per Tag M3U exporteren of HTSP gebruiken.

**PVR in TVH**
- *Recording → DVR Profiles*:
  - **Recording path**: `/recordings`
  - **Pre/Post padding**: 2–3 min
  - **Stream type**: Pass-through (of transcode)
- Voeg `/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend` toe als Jellyfin Library voor weergave.

---

## VOD (Movies/Series) — M3U → STRM
Uitvoer blijft ongewijzigd (los van DVR):  
- Movies → `/mnt/Applications/Apps/m3u-vod-strm/out/Movies`
- TV → `/mnt/Applications/Apps/m3u-vod-strm/out/TV`

Deze twee paden voeg je als **Libraries** toe in Jellyfin.

---

## Beheer, performance & veiligheid
- **User-Agent/headers** per tuner instellen indien provider dat eist.  
- **Simultaneous stream limit** respecteert provider-limieten.  
- **Tuner priority** voor doublures.  
- **Transcoding** vermijden waar kan (H.264/AAC → pass‑through).  
- Opnames **op de juiste pool**: `/mnt/QNAP-TL-D800C/Media/DVR`.  
- xTeVe/NGINX/TVH alleen LAN of achter VPN/reverse proxy.

---

## Troubleshooting (kort)
- Zender speelt niet → test URL in VLC (bron).  
- Geen EPG → XMLTV, tijdzone, *Map Channels*.  
- Dubbele kanalen → tuner-priority of disable.  
- Opnames corrupt → meer padding of TVHeadend-PVR.

---

## Bijlagen
**A) Jellyfin PVR mount (samenvatting)**  
Host: `/mnt/QNAP-TL-D800C/Media/DVR/Jellyfin` → Container: `/recordings` → Recording path: `/recordings`

**B) TVHeadend volume**  
`/mnt/QNAP-TL-D800C/Media/DVR/TVHeadend:/recordings`

**C) Kanaalnummers (advies)**  
NL 101–199 · UK 201–299 · Sports 401–499 · Kids 501–549 · Docs 551–599 · XXX 901–999

**D) Juridisch**  
Gebruik alleen bronnen waarvoor je rechten/abonnement hebt.


---

## EPG (XMLTV)
Gebruik: **https://epg.iptv.cat/epg.xml** of de **lokale mirror**: `http://192.168.2.84:8099/epg.xml` (via epg_fetcher).  
Voeg toe in Jellyfin: *Live TV → Guide Data → Add → XMLTV*, daarna **Map Channels**.


---

## Extra exports (volledig)
- **TUNERS-ALL-URLs.txt** — alle groep-URL’s voor Jellyfin tuners (via de Splitter/NGINX).
- **CHANNELS-ALL.csv** — elk kanaal uit je master (kolommen: group, tvg-id, tvg-name, tvg-logo, name, url).
