/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BitStreamIO {
    private int bitsProcessed = 0;
    private int buf = 0;
    private static final int[] maskArr = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    public int readBits(DataInputStream dis, int numBits) throws IOException {
        if (numBits < 0 || numBits > 32) {
            Debug.assertFail();
        }
        int result = 0;
        int bitsInBuf = 8 - (this.bitsProcessed & 7) & 7;
        this.bitsProcessed += numBits;
        while (numBits > 0) {
            if (bitsInBuf == 0) {
                this.buf = dis.readByte() & 0xFF;
                bitsInBuf = 8;
            }
            if (numBits >= bitsInBuf) {
                result <<= bitsInBuf;
                int mask = maskArr[bitsInBuf];
                result |= this.buf & mask;
                numBits -= bitsInBuf;
                bitsInBuf = 0;
                continue;
            }
            result <<= numBits;
            int buf2 = this.buf >> (bitsInBuf -= numBits);
            int mask = maskArr[numBits];
            result |= buf2 & mask;
            numBits = 0;
        }
        return result;
    }

    public long readBitsLong(DataInputStream dis, int numBits) throws IOException {
        if (numBits < 0 || numBits > 64) {
            Debug.assertFail();
        }
        long result = 0L;
        int bitsInBuf = 8 - (this.bitsProcessed & 7) & 7;
        this.bitsProcessed += numBits;
        while (numBits > 0) {
            if (bitsInBuf == 0) {
                this.buf = dis.readByte() & 0xFF;
                bitsInBuf = 8;
            }
            if (numBits >= bitsInBuf) {
                result <<= bitsInBuf;
                int mask = maskArr[bitsInBuf];
                result |= (long)(this.buf & mask);
                numBits -= bitsInBuf;
                bitsInBuf = 0;
                continue;
            }
            result <<= numBits;
            int buf2 = this.buf >> (bitsInBuf -= numBits);
            int mask = maskArr[numBits];
            result |= (long)(buf2 & mask);
            numBits = 0;
        }
        return result;
    }

    public void writeBits(DataOutputStream dos, int numBits, int value) throws IOException {
        if (numBits < 0 || numBits > 32) {
            Debug.assertFail();
        }
        int bitsInBuf = this.bitsProcessed & 7;
        this.bitsProcessed += numBits;
        while (numBits > 0) {
            if (bitsInBuf > 0) {
                int mask;
                int available = 8 - bitsInBuf;
                if (available <= numBits) {
                    mask = maskArr[available];
                    this.buf |= value >> numBits - available & mask;
                    numBits -= available;
                    bitsInBuf += available;
                } else {
                    mask = maskArr[numBits];
                    int buf2 = value & mask;
                    this.buf |= buf2 << available - numBits;
                    bitsInBuf += numBits;
                    numBits = 0;
                }
            } else if (numBits >= 8) {
                this.buf = value >> numBits - 8;
                numBits -= 8;
                bitsInBuf = 8;
            } else {
                int mask = maskArr[numBits];
                int buf2 = value & mask;
                this.buf |= buf2 << 8 - numBits;
                bitsInBuf = numBits;
                numBits = 0;
            }
            if (bitsInBuf != 8) continue;
            dos.write(this.buf);
            this.buf = 0;
            bitsInBuf = 0;
        }
    }

    public void writeBitsLong(DataOutputStream dos, int numBits, long value) throws IOException {
        if (numBits < 0 || numBits > 64) {
            Debug.assertFail();
        }
        int bitsInBuf = this.bitsProcessed & 7;
        this.bitsProcessed += numBits;
        while (numBits > 0) {
            if (bitsInBuf > 0) {
                int available = 8 - bitsInBuf;
                if (available <= numBits) {
                    int mask = maskArr[available];
                    this.buf = (int)((long)this.buf | value >> numBits - available & (long)mask);
                    numBits -= available;
                    bitsInBuf += available;
                } else {
                    long mask = maskArr[numBits];
                    int buf2 = (int)(value & mask);
                    this.buf |= buf2 << available - numBits;
                    bitsInBuf += numBits;
                    numBits = 0;
                }
            } else if (numBits >= 8) {
                this.buf = (int)(value >> numBits - 8);
                numBits -= 8;
                bitsInBuf = 8;
            } else {
                int mask = maskArr[numBits];
                int buf2 = (int)(value & (long)mask);
                this.buf |= buf2 << 8 - numBits;
                bitsInBuf = numBits;
                numBits = 0;
            }
            if (bitsInBuf != 8) continue;
            dos.write(this.buf);
            this.buf = 0;
            bitsInBuf = 0;
        }
    }

    public void assertByteAligned(int numBytes) {
        int numBits = numBytes * 8;
        int bits = this.bitsProcessed % numBits;
        if (bits != 0) {
            Debug.assertFail(bits + " stray bits.");
        }
    }

    public int getBitsProcessed() {
        return this.bitsProcessed;
    }
}

