/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ImageManager;
import com.hdcookbook.grin.util.ManagedFullImage;
import io.pttt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;

public class AssetFinder {
    private static AssetFinder helper = null;
    private static Class theClass = class$com$hdcookbook$grin$util$AssetFinder == null ? (class$com$hdcookbook$grin$util$AssetFinder = AssetFinder.class$("com.hdcookbook.grin.util.AssetFinder")) : class$com$hdcookbook$grin$util$AssetFinder;
    private static String[] appJarPath;
    private static File[] filePath;
    static /* synthetic */ Class class$com$hdcookbook$grin$util$AssetFinder;

    protected AssetFinder() {
    }

    public static void setHelper(AssetFinder assetFinder) {
        helper = assetFinder;
    }

    public static void setSearchPath(String[] stringArray, File[] fileArray) {
        if (stringArray == null) {
            appJarPath = null;
        } else {
            appJarPath = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                AssetFinder.appJarPath[i] = stringArray[i].endsWith("/") ? stringArray[i] : stringArray[i] + "/";
            }
        }
        filePath = fileArray;
    }

    public static void setImageMap(String string) {
        Hashtable hashtable = new Hashtable();
        try {
            ImageManager.readImageMap(string, hashtable);
            ImageManager.setImageMap(hashtable);
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            Debug.assertFail();
        }
    }

    public static void setImageMap(String[] stringArray) {
        Hashtable hashtable = new Hashtable();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                ImageManager.readImageMap(stringArray[i], hashtable);
            }
            ImageManager.setImageMap(hashtable);
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            Debug.assertFail();
        }
    }

    public static URL getURL(String string) {
        URL uRL = AssetFinder.tryURL(string);
        if (uRL == null) {
            int n;
            if (appJarPath != null) {
                for (n = 0; n < appJarPath.length; ++n) {
                    Debug.println("   Tried " + appJarPath[n] + string);
                }
            }
            if (filePath != null) {
                for (n = 0; n < filePath.length; ++n) {
                    Debug.println("   Tried " + new pttt(filePath[n], string));
                }
            }
            Debug.println();
            Debug.println("****  Resource " + string + " does not exist!  ****");
            Debug.println();
        }
        return uRL;
    }

    public static URL tryURL(String string) {
        Serializable serializable;
        URL uRL;
        if (helper != null && (uRL = helper.tryURLHelper(string)) != null) {
            return uRL;
        }
        if (appJarPath == null && filePath == null) {
            Debug.assertFail("Search path not set.");
        }
        if (appJarPath != null) {
            for (int i = 0; i < appJarPath.length; ++i) {
                serializable = theClass.getResource(appJarPath[i] + string);
                if (serializable == null) continue;
                return serializable;
            }
        }
        if (filePath != null) {
            for (int i = 0; i < filePath.length; ++i) {
                serializable = new pttt(filePath[i], string);
                if (!((File)serializable).exists()) continue;
                try {
                    return ((File)serializable).toURL();
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
            }
        }
        return null;
    }

    protected URL tryURLHelper(String string) {
        return null;
    }

    public static Color getColor(int n, int n2, int n3, int n4) {
        Color color = new Color(n, n2, n3, n4);
        return color;
    }

    public static Font getFont(String string, int n, int n2) {
        if (helper != null) {
            Font font = helper.getFontHelper(string, n, n2);
            if (font != null) {
                return font;
            }
            if (!"SansSerif".equals(string)) {
                Debug.println("*** Helper didn't find font " + string);
            }
        }
        return new Font(string, n, n2);
    }

    protected Font getFontHelper(String string, int n, int n2) {
        return null;
    }

    public static Image createCompatibleImageBuffer(Component component, int n, int n2) {
        Image image;
        if (helper != null && (image = helper.createCompatibleImageBufferHelper(component, n, n2)) != null) {
            return image;
        }
        return component.getGraphicsConfiguration().createCompatibleImage(n, n2);
    }

    protected Image createCompatibleImageBufferHelper(Component component, int n, int n2) {
        return null;
    }

    public static Graphics2D createGraphicsFromImageBuffer(Image image) {
        Graphics2D graphics2D;
        if (helper != null && (graphics2D = helper.createGraphicsFromImageBufferHelper(image)) != null) {
            return graphics2D;
        }
        return ((BufferedImage)image).createGraphics();
    }

    protected Graphics2D createGraphicsFromImageBufferHelper(Image image) {
        return null;
    }

    public static void destroyImageBuffer(Image image) {
        if (helper != null) {
            helper.destroyImageBufferHelper(image);
        }
    }

    protected void destroyImageBufferHelper(Image image) {
    }

    public static Image loadImage(String string) {
        Object object;
        if (helper != null && (object = helper.loadImageHelper(string)) != null) {
            return object;
        }
        object = Toolkit.getDefaultToolkit();
        URL uRL = AssetFinder.getURL(string);
        return ((Toolkit)object).createImage(uRL);
    }

    protected Image loadImageHelper(String string) {
        return null;
    }

    public static int getColorKeyCode(Color color) {
        int n = -1;
        if (helper != null) {
            n = helper.getColorKeyCodeHelper(color);
        }
        if (n == -1) {
            if (color == Color.red) {
                return 403;
            }
            if (color == Color.green) {
                return 404;
            }
            if (color == Color.yellow) {
                return 405;
            }
            if (color == Color.blue) {
                return 406;
            }
        }
        if (n < 403 || n > 406) {
            Debug.assertFail();
        }
        return n;
    }

    protected int getColorKeyCodeHelper(Color color) {
        return -1;
    }

    public static void abort() {
        if (helper != null) {
            helper.abortHelper();
        }
        throw new RuntimeException("ABORT");
    }

    protected void abortHelper() {
    }

    public static void notifyLoaded(ManagedFullImage managedFullImage) {
        Debug.println("Loaded image " + managedFullImage.getName());
        if (helper != null) {
            helper.notifyLoadedHelper(managedFullImage);
        }
    }

    protected void notifyLoadedHelper(ManagedFullImage managedFullImage) {
    }

    public static void notifyUnloaded(ManagedFullImage managedFullImage, int n, int n2) {
        Debug.println("Unloaded image " + managedFullImage.getName());
        if (helper != null) {
            helper.notifyUnloadedHelper(managedFullImage, n, n2);
        }
    }

    protected void notifyUnloadedHelper(ManagedFullImage managedFullImage, int n, int n2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return pttt.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

