/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.io.binary;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.GrinXHelper;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.ActivatePartCommand;
import com.hdcookbook.grin.commands.ActivateSegmentCommand;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.commands.ResetFeatureCommand;
import com.hdcookbook.grin.commands.SetVisualRCStateCommand;
import com.hdcookbook.grin.features.Assembly;
import com.hdcookbook.grin.features.Box;
import com.hdcookbook.grin.features.Clipped;
import com.hdcookbook.grin.features.Fade;
import com.hdcookbook.grin.features.FixedImage;
import com.hdcookbook.grin.features.Group;
import com.hdcookbook.grin.features.GuaranteeFill;
import com.hdcookbook.grin.features.ImageSequence;
import com.hdcookbook.grin.features.InterpolatedModel;
import com.hdcookbook.grin.features.SetTarget;
import com.hdcookbook.grin.features.SrcOver;
import com.hdcookbook.grin.features.Text;
import com.hdcookbook.grin.features.Translator;
import com.hdcookbook.grin.input.CommandRCHandler;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.VisualRCHandler;
import com.hdcookbook.grin.io.binary.DebugInputStream;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import io.pttt;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class GrinBinaryReader {
    private Show show;
    private Object[] showInArray;
    private Feature[] featureList;
    private RCHandler[] rcHandlerList;
    private Segment[] segmentList;
    private Command[] commandList;
    Hashtable publicSegments = new Hashtable();
    Hashtable publicFeatures = new Hashtable();
    Hashtable publicRCHandlers = new Hashtable();
    private InputStream stream;
    private Class showCommandsClass = null;
    private String[] stringConstants = null;
    private int[][] intArrayConstants = null;
    private Rectangle[] rectangleConstants;
    private Rectangle[][] rectangleArrayConstants;
    private Command[][] commandArrayConstants;
    private GrinXHelper showCommands = null;
    private int extensionStartIndex;
    private Constructor[] extensionConstructors = null;
    boolean debuggable = false;
    private ClassLoader classLoader = null;
    static /* synthetic */ Class class$com$hdcookbook$grin$Show;

    public GrinBinaryReader(InputStream inputStream) {
        this.stream = new DebugInputStream(inputStream);
    }

    public GrinBinaryReader(InputStream inputStream, ClassLoader classLoader) {
        this(inputStream);
        this.classLoader = classLoader;
    }

    Feature getFeatureFromIndex(int n) throws IOException {
        if (n < 0 || n >= this.featureList.length) {
            throw new IOException("non-existing feature reference");
        }
        return this.featureList[n];
    }

    Segment getSegmentFromIndex(int n) throws IOException {
        if (n < 0 || n > this.segmentList.length) {
            throw new IOException("non-existing segment reference");
        }
        return this.segmentList[n];
    }

    RCHandler getRCHandlerFromIndex(int n) throws IOException {
        if (n < 0 || n > this.rcHandlerList.length) {
            throw new IOException("non-existing rchandler reference");
        }
        return this.rcHandlerList[n];
    }

    Command getCommandFromIndex(int n) throws IOException {
        if (n < 0 || n > this.commandList.length) {
            throw new IOException("non-existing command reference " + n);
        }
        return this.commandList[n];
    }

    int[] getIntArrayFromReference(int n) throws IOException {
        if (n < 0 || n > this.intArrayConstants.length) {
            throw new IOException("non-existing int array reference");
        }
        return this.intArrayConstants[n];
    }

    String getStringFromReference(int n) throws IOException {
        if (n < 0 || n > this.stringConstants.length) {
            throw new IOException("wrong string reference ");
        }
        return this.stringConstants[n];
    }

    Rectangle getRectangleFromReference(int n) throws IOException {
        if (n < 0 || n > this.rectangleConstants.length) {
            throw new IOException("bad rectangle reference");
        }
        return this.rectangleConstants[n];
    }

    Rectangle[] getRectangleArrayFromReference(int n) throws IOException {
        if (n < 0 || n > this.rectangleArrayConstants.length) {
            throw new IOException("bad rectangle array reference");
        }
        return this.rectangleArrayConstants[n];
    }

    Command[] getCommandArrayFromReference(int n) throws IOException {
        if (n < 0 || n > this.commandArrayConstants.length) {
            throw new IOException("bad command array reference");
        }
        return this.commandArrayConstants[n];
    }

    private void checkValue(int n, int n2, String string) throws IOException {
        if (n != n2) {
            throw new IOException("Mismatch: " + string);
        }
    }

    private void checkScriptHeader(DataInputStream dataInputStream) throws IOException {
        this.checkValue(dataInputStream.readInt(), -1072910324, "Script identifier");
        int n = dataInputStream.readInt();
        this.checkValue(n, 27, "Script version mismatch, expects 27, found " + n);
    }

    public void readShow(Show show) throws IOException {
        this.show = show;
        this.showInArray = new Show[]{show};
        GrinDataInputStream grinDataInputStream = new GrinDataInputStream(this.stream, this);
        this.checkScriptHeader(grinDataInputStream);
        this.stringConstants = this.readStringConstants(grinDataInputStream);
        this.intArrayConstants = this.readIntArrayConstants(grinDataInputStream);
        this.rectangleConstants = this.readRectangleConstants(grinDataInputStream);
        this.rectangleArrayConstants = this.readRectangleArrayConstants(grinDataInputStream);
        this.extensionConstructors = this.readExtensionConstructors(grinDataInputStream);
        this.readShowCommandsClass(grinDataInputStream);
        this.showCommands = this.instantiateShowCommandsCmd();
        this.commandList = new Command[grinDataInputStream.readInt()];
        this.readDeclarations(grinDataInputStream, this.commandList);
        this.commandArrayConstants = this.readCommandArrayConstants(grinDataInputStream);
        int n = grinDataInputStream.readInt();
        show.setSegmentStackDepth(n);
        String[] stringArray = grinDataInputStream.readStringArray();
        show.setDrawTargets(stringArray);
        String[] stringArray2 = grinDataInputStream.readStringArray();
        Hashtable hashtable = this.readPublicNamedCommands(grinDataInputStream);
        this.debuggable = grinDataInputStream.readBoolean();
        this.featureList = new Feature[grinDataInputStream.readInt()];
        this.readDeclarations(grinDataInputStream, this.featureList);
        this.rcHandlerList = new RCHandler[grinDataInputStream.readInt()];
        this.readDeclarations(grinDataInputStream, this.rcHandlerList);
        this.segmentList = new Segment[grinDataInputStream.readInt()];
        this.readDeclarations(grinDataInputStream, this.segmentList);
        this.readContents(grinDataInputStream, this.featureList);
        this.readContents(grinDataInputStream, this.rcHandlerList);
        this.readContents(grinDataInputStream, this.segmentList);
        this.readContents(grinDataInputStream, this.commandList);
        Segment segment = grinDataInputStream.readSegmentReference();
        Group group = (Group)grinDataInputStream.readFeatureReference();
        String[] stringArray3 = grinDataInputStream.readStringArray();
        int[] nArray = grinDataInputStream.readSharedIntArray();
        int n2 = grinDataInputStream.readInt();
        int n3 = grinDataInputStream.readInt();
        int n4 = grinDataInputStream.readInt();
        int n5 = grinDataInputStream.readInt();
        show.setScale(n2, n3, n4, n5);
        show.buildShow(this.segmentList, this.featureList, this.rcHandlerList, stringArray2, segment, group, this.publicSegments, this.publicFeatures, this.publicRCHandlers, hashtable, stringArray3, nArray);
    }

    private Hashtable readPublicNamedCommands(GrinDataInputStream grinDataInputStream) throws IOException {
        int n = grinDataInputStream.readInt();
        Hashtable<String, Command> hashtable = new Hashtable<String, Command>(n);
        for (int i = 0; i < n; ++i) {
            String string = grinDataInputStream.readString();
            Command command = this.getCommandFromIndex(grinDataInputStream.readInt());
            hashtable.put(string, command);
        }
        return hashtable;
    }

    private void readDeclarations(GrinDataInputStream grinDataInputStream, Object[] objectArray) throws IOException {
        for (int i = 0; i < objectArray.length; ++i) {
            Node node;
            int n = grinDataInputStream.readInt();
            switch (n) {
                case 0: {
                    node = new Assembly(this.show);
                    break;
                }
                case 1: {
                    node = new Box(this.show);
                    break;
                }
                case 8: {
                    node = new Clipped(this.show);
                    break;
                }
                case 9: {
                    node = new Fade(this.show);
                    break;
                }
                case 2: {
                    node = new FixedImage(this.show);
                    break;
                }
                case 3: {
                    node = new Group(this.show);
                    break;
                }
                case 4: {
                    node = new ImageSequence(this.show);
                    break;
                }
                case 5: {
                    node = new Text(this.show);
                    break;
                }
                case 6: {
                    node = new InterpolatedModel(this.show);
                    break;
                }
                case 7: {
                    node = new Translator(this.show);
                    break;
                }
                case 10: {
                    node = new SrcOver(this.show);
                    break;
                }
                case 18: {
                    node = new GuaranteeFill(this.show);
                    break;
                }
                case 19: {
                    node = new SetTarget(this.show);
                    break;
                }
                case 16: {
                    node = new CommandRCHandler();
                    break;
                }
                case 17: {
                    node = new VisualRCHandler();
                    break;
                }
                case 20: {
                    node = new Segment();
                    break;
                }
                case 11: {
                    node = new ActivatePartCommand(this.show);
                    break;
                }
                case 12: {
                    node = new ActivateSegmentCommand(this.show);
                    break;
                }
                case 13: {
                    node = new ResetFeatureCommand(this.show);
                    break;
                }
                case 14: {
                    node = new GrinXHelper(this.show);
                    break;
                }
                case 15: {
                    node = new SetVisualRCStateCommand(this.show);
                    break;
                }
                case -1: {
                    node = null;
                }
                default: {
                    node = this.instantiateExtension(n);
                }
            }
            objectArray[i] = node;
        }
    }

    private Node instantiateExtension(int n) throws IOException {
        if (this.extensionConstructors == null) {
            if (this.showCommands == null) {
                throw new IOException("Missing GrinXHelper subclass for instantiating extensions");
            }
            return this.showCommands.getInstanceOf(this.show, n);
        }
        int n2 = n - this.extensionStartIndex;
        try {
            return (Node)this.extensionConstructors[n2].newInstance(this.showInArray);
        }
        catch (Exception exception) {
            throw new IOException("Error instantiating extension:  " + exception);
        }
    }

    private int[][] readIntArrayConstants(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -31, "Integer array constants identifier");
        int n = grinDataInputStream.readInt();
        int[][] nArrayArray = new int[n][];
        nArrayArray[0] = null;
        for (int i = 1; i < n; ++i) {
            nArrayArray[i] = new int[grinDataInputStream.readInt()];
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                nArrayArray[i][j] = grinDataInputStream.readInt();
            }
        }
        return nArrayArray;
    }

    private Rectangle[] readRectangleConstants(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -30, "Rectangle constants identifier");
        int n = grinDataInputStream.readInt();
        Rectangle[] rectangleArray = new Rectangle[n];
        rectangleArray[0] = null;
        for (int i = 1; i < n; ++i) {
            Rectangle rectangle = new Rectangle();
            rectangle.x = grinDataInputStream.readInt();
            rectangle.y = grinDataInputStream.readInt();
            rectangle.width = grinDataInputStream.readInt();
            rectangle.height = grinDataInputStream.readInt();
            rectangleArray[i] = rectangle;
        }
        return rectangleArray;
    }

    private Rectangle[][] readRectangleArrayConstants(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -29, "Rectangle array constants identifier");
        int n = grinDataInputStream.readInt();
        Rectangle[][] rectangleArray = new Rectangle[n][];
        rectangleArray[0] = null;
        for (int i = 1; i < n; ++i) {
            Rectangle[] rectangleArray2 = new Rectangle[grinDataInputStream.readInt()];
            rectangleArray[i] = rectangleArray2;
            for (int j = 0; j < rectangleArray2.length; ++j) {
                rectangleArray2[j] = this.getRectangleFromReference(grinDataInputStream.readInt());
            }
        }
        return rectangleArray;
    }

    private Command[][] readCommandArrayConstants(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -28, "Command array constants identifier");
        int n = grinDataInputStream.readInt();
        Command[][] commandArray = new Command[n][];
        commandArray[0] = null;
        for (int i = 1; i < n; ++i) {
            Command[] commandArray2 = new Command[grinDataInputStream.readInt()];
            commandArray[i] = commandArray2;
            for (int j = 0; j < commandArray2.length; ++j) {
                commandArray2[j] = this.getCommandFromIndex(grinDataInputStream.readInt());
            }
        }
        return commandArray;
    }

    private Constructor[] readExtensionConstructors(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -27, "Extension classes identifier");
        this.extensionStartIndex = grinDataInputStream.readInt();
        if (this.extensionStartIndex == -1) {
            return null;
        }
        int n = grinDataInputStream.readInt();
        Constructor[] constructorArray = new Constructor[n];
        Class[] classArray = new Class[]{class$com$hdcookbook$grin$Show == null ? (class$com$hdcookbook$grin$Show = GrinBinaryReader.class$("com.hdcookbook.grin.Show")) : class$com$hdcookbook$grin$Show};
        for (int i = 0; i < n; ++i) {
            String string = grinDataInputStream.readUTF();
            try {
                Class<?> clazz = null;
                clazz = this.classLoader == null ? pttt.forName(string) : Class.forName(string, true, this.classLoader);
                constructorArray[i] = clazz.getDeclaredConstructor(classArray);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Extension class " + string + " is missing:  " + classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("Extension class " + string + " missing constructor:  " + noSuchMethodException);
            }
        }
        return constructorArray;
    }

    private void readShowCommandsClass(GrinDataInputStream grinDataInputStream) throws IOException {
        String string = grinDataInputStream.readString();
        if (string == null) {
            return;
        }
        try {
            this.showCommandsClass = this.classLoader == null ? pttt.forName(string) : Class.forName(string, true, this.classLoader);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private void readContents(GrinDataInputStream grinDataInputStream, Object[] objectArray) throws IOException {
        for (int i = 0; i < objectArray.length; ++i) {
            Node node = (Node)objectArray[i];
            if (node == null) continue;
            int n = grinDataInputStream.readInt();
            ((DebugInputStream)this.stream).pushExpectedLength(n);
            node.readInstanceData(grinDataInputStream, n);
            ((DebugInputStream)this.stream).popExpectedLength();
        }
    }

    private String[] readStringConstants(GrinDataInputStream grinDataInputStream) throws IOException {
        this.checkValue(grinDataInputStream.readByte(), -32, "String array identifier");
        String[] stringArray = new String[grinDataInputStream.readInt()];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = grinDataInputStream.readUTF();
        }
        return stringArray;
    }

    Command[] getCommandArrayFromIndex(int n) throws IOException {
        if (n < 0 || n > this.commandArrayConstants.length) {
            throw new IOException("non-existing command array reference");
        }
        return this.commandArrayConstants[n];
    }

    private GrinXHelper instantiateShowCommandsCmd() throws IOException {
        GrinXHelper grinXHelper;
        if (this.showCommandsClass == null) {
            return null;
        }
        Class[] classArray = new Class[]{class$com$hdcookbook$grin$Show == null ? (class$com$hdcookbook$grin$Show = GrinBinaryReader.class$("com.hdcookbook.grin.Show")) : class$com$hdcookbook$grin$Show};
        Object[] objectArray = new Object[]{this.show};
        try {
            grinXHelper = (GrinXHelper)this.showCommandsClass.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
        return grinXHelper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return pttt.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

