/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.input;

import com.hdcookbook.grin.Feature;
import com.hdcookbook.grin.Node;
import com.hdcookbook.grin.Segment;
import com.hdcookbook.grin.Show;
import com.hdcookbook.grin.commands.Command;
import com.hdcookbook.grin.features.Assembly;
import com.hdcookbook.grin.input.RCHandler;
import com.hdcookbook.grin.input.RCKeyEvent;
import com.hdcookbook.grin.io.binary.GrinDataInputStream;
import com.hdcookbook.grin.util.Debug;
import java.awt.Rectangle;
import java.io.IOException;

public class VisualRCHandler
extends RCHandler
implements Node {
    public static final int GRID_ACTIVATE = 65535;
    protected static int MASK = RCKeyEvent.KEY_UP.getBitMask() | RCKeyEvent.KEY_DOWN.getBitMask() | RCKeyEvent.KEY_RIGHT.getBitMask() | RCKeyEvent.KEY_LEFT.getBitMask() | RCKeyEvent.KEY_ENTER.getBitMask();
    protected int[] upDown;
    protected int[] rightLeft;
    protected int[][] upDownAlternates;
    protected int[][] rightLeftAlternates;
    protected String[] gridAlternateNames;
    protected String[] stateNames;
    protected Assembly assembly;
    protected Feature[] selectFeatures;
    protected Command[][] selectCommands;
    protected Feature[] activateFeatures;
    protected Command[][] activateCommands;
    protected Rectangle[] mouseRects;
    protected int[] mouseRectStates;
    protected int timeout;
    protected Command[] timeoutCommands;
    protected boolean startSelected = false;
    private boolean activated = false;
    private int currState = 0;
    private int currFrame;
    private boolean timedOut;

    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    private boolean handlesActivation() {
        return this.activateFeatures != null || this.activateCommands != null;
    }

    public boolean getActivated() {
        return this.activated;
    }

    public int getState() {
        return this.currState;
    }

    public String getStateName(int stateNum) {
        return this.stateNames[stateNum];
    }

    public int lookupState(String name) {
        for (int i = 0; i < this.stateNames.length; ++i) {
            if (!this.stateNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int lookupGrid(String gridAlternateName) {
        for (int i = 0; i < this.gridAlternateNames.length; ++i) {
            if (!this.gridAlternateNames[i].equals(gridAlternateName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleKeyPressed(RCKeyEvent ke, Show caller) {
        if ((ke.getBitMask() & MASK) == 0) {
            return false;
        }
        Show show = this.show;
        synchronized (show) {
            int newState = 0;
            if (ke == RCKeyEvent.KEY_ENTER) {
                newState = 65535;
            } else if (ke == RCKeyEvent.KEY_UP) {
                newState = this.upDown[this.currState] >> 16 & 0xFFFF;
            } else if (ke == RCKeyEvent.KEY_DOWN) {
                newState = this.upDown[this.currState] & 0xFFFF;
            } else if (ke == RCKeyEvent.KEY_RIGHT) {
                newState = this.rightLeft[this.currState] >> 16 & 0xFFFF;
            } else if (ke == RCKeyEvent.KEY_LEFT) {
                newState = this.rightLeft[this.currState] & 0xFFFF;
            } else {
                Debug.assertFail();
            }
            if (newState == 65535) {
                if (!this.handlesActivation()) {
                    return false;
                }
                this.setState(-1, true, true);
                return true;
            }
            this.setState(newState, false, true);
            return true;
        }
    }

    public boolean handleKeyReleased(RCKeyEvent ke, Show caller) {
        return false;
    }

    public boolean handleKeyTyped(RCKeyEvent ke, Show caller) {
        return false;
    }

    public boolean handleMouse(int x, int y, boolean activate) {
        if (this.mouseRects == null) {
            return false;
        }
        for (int i = 0; i < this.mouseRects.length; ++i) {
            if (!this.mouseRects[i].contains(x, y)) continue;
            this.setState(this.mouseRectStates[i], activate, true);
            return true;
        }
        return false;
    }

    public void setState(int newState, boolean newActivated, boolean runCommands) {
        this.setState(newState, newActivated, runCommands, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int newState, boolean newActivated, boolean runCommands, int gridAlternate) {
        Show show = this.show;
        synchronized (show) {
            Command[] arr;
            Command[][] cs;
            if (gridAlternate != -1) {
                this.upDown = this.upDownAlternates[gridAlternate];
                this.rightLeft = this.rightLeftAlternates[gridAlternate];
            }
            if (newState == 65535) {
                newState = this.currState;
                newActivated = true;
            } else if (newState == -1) {
                newState = this.currState;
            }
            if (newState == this.currState && newActivated == this.activated) {
                if (this.activated) {
                    this.setState(newState, false, false);
                } else {
                    return;
                }
            }
            Debug.println("RC handler state becomes " + this.stateNames[newState]);
            Feature[] fs = newActivated ? this.activateFeatures : this.selectFeatures;
            Command[][] commandArray = cs = newActivated ? this.activateCommands : this.selectCommands;
            if (fs != null && fs[newState] != null) {
                this.assembly.setCurrentFeature(fs[newState]);
                Debug.println("    Setting assembly to " + fs[newState]);
            }
            if (runCommands && cs != null && (arr = cs[newState]) != null) {
                for (int i = 0; i < arr.length; ++i) {
                    this.show.runCommand(arr[i]);
                }
            }
            this.currState = newState;
            this.activated = newActivated;
        }
    }

    public void activate(Segment s) {
        this.timedOut = this.timeout <= -1;
        this.currFrame = 0;
        if (this.assembly != null) {
            Feature curr = this.assembly.getCurrentPart();
            int i = this.lookForFeature(curr, this.selectFeatures);
            if (i != -1) {
                this.currState = i;
                this.activated = false;
            } else {
                i = this.lookForFeature(curr, this.activateFeatures);
                if (i != -1) {
                    this.currState = i;
                    if (this.startSelected) {
                        this.assembly.setCurrentFeature(this.selectFeatures[i]);
                        this.activated = false;
                    } else {
                        this.activated = true;
                    }
                } else {
                    Debug.println("Handler " + this.getName() + " can't find current assembly state");
                }
            }
        }
    }

    private int lookForFeature(Feature f, Feature[] fs) {
        if (fs == null) {
            return -1;
        }
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i] != f) continue;
            return i;
        }
        return -1;
    }

    public void nextFrame() {
        ++this.currFrame;
        if (!this.timedOut && this.currFrame > this.timeout) {
            this.timedOut = true;
            for (int i = 0; i < this.timeoutCommands.length; ++i) {
                this.show.runCommand(this.timeoutCommands[i]);
            }
        }
    }

    public void readInstanceData(GrinDataInputStream in, int length) throws IOException {
        int i;
        in.readSuperClassData(this);
        this.gridAlternateNames = in.readStringArray();
        this.upDownAlternates = new int[in.readInt()][];
        this.rightLeftAlternates = new int[this.upDownAlternates.length][];
        for (i = 0; i < this.upDownAlternates.length; ++i) {
            this.upDownAlternates[i] = in.readSharedIntArray();
            this.rightLeftAlternates[i] = in.readSharedIntArray();
        }
        this.upDown = this.upDownAlternates[0];
        this.rightLeft = this.rightLeftAlternates[0];
        this.stateNames = in.readStringArray();
        if (in.isNull()) {
            this.selectCommands = null;
        } else {
            this.selectCommands = new Command[in.readInt()][];
            for (i = 0; i < this.selectCommands.length; ++i) {
                this.selectCommands[i] = in.readCommands();
            }
        }
        if (in.isNull()) {
            this.activateCommands = null;
        } else {
            this.activateCommands = new Command[in.readInt()][];
            for (i = 0; i < this.activateCommands.length; ++i) {
                this.activateCommands[i] = in.readCommands();
            }
        }
        this.mouseRects = in.readRectangleArray();
        this.mouseRectStates = in.readIntArray();
        this.timeout = in.readInt();
        this.timeoutCommands = in.readCommands();
        if (in.readBoolean()) {
            this.assembly = (Assembly)in.readFeatureReference();
        }
        this.selectFeatures = in.readFeaturesArrayReference();
        this.activateFeatures = in.readFeaturesArrayReference();
        this.startSelected = in.readBoolean();
    }
}

