/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

public class XMLParser
implements Serializable {
    private final String XMLheader = "<?xml version=\"1.0\" standalone=\"yes\"?>";
    private final String XMLcomment = "<!-- Written by WiSH XML writer -->";
    private String tag;
    private Object element = null;
    public Attribute Attribute = new Attribute();
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;
    private int line = 1;
    private int col = 0;
    private boolean eol = false;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$lang$String;

    public XMLParser(String tag) {
        this.tag = tag;
    }

    public XMLParser() {
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() == (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return null;
        }
        return (String)this.element;
    }

    public int size() {
        if (this.element == null) {
            return 0;
        }
        if (this.element.getClass() == (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return ((Vector)this.element).size();
        }
        return 0;
    }

    public XMLParser findElement(String tag) {
        if (this.tag.compareTo(tag) == 0) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return null;
        }
        XMLParser xml = null;
        Vector v = (Vector)this.element;
        for (int i = 0; i < v.size(); ++i) {
            xml = (XMLParser)v.get(i);
            if (xml == null || xml.findElement(tag) == null) continue;
            return xml;
        }
        return null;
    }

    public boolean removeElement(XMLParser element) throws XMLException {
        if (element == null) {
            throw new XMLException("Cannot prune if target element is null");
        }
        if (this.element == null) {
            throw new XMLException("No subelements");
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            throw new XMLException("No subelements");
        }
        Vector v = (Vector)this.element;
        if (v.size() <= 0) {
            return false;
        }
        if (!v.remove(element)) {
            return false;
        }
        if (v.size() == 0) {
            this.element = null;
        }
        return true;
    }

    public boolean contains(XMLParser element) throws XMLException {
        if (element == null) {
            throw new XMLException("Cannot prune if target element is null");
        }
        if (this.element == null) {
            throw new XMLException("No subelements");
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            throw new XMLException("No subelements");
        }
        Vector v = (Vector)this.element;
        if (v.size() <= 0) {
            return false;
        }
        return v.contains(element);
    }

    public boolean removeAllElements() {
        if (this.element == null) {
            return false;
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return false;
        }
        this.element = null;
        return true;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public XMLParser findattribute(String name) {
        if (this.Attribute.find(name) != null) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return null;
        }
        XMLParser xml = null;
        Vector v = (Vector)this.element;
        for (int i = 0; i < v.size(); ++i) {
            xml = (XMLParser)v.get(i);
            if (xml.findattribute(name) == null) continue;
            return xml;
        }
        return null;
    }

    public XMLParser findElement(String tag, String attname) {
        if (this.tag.compareTo(tag) == 0 && this.Attribute.find(attname) != null) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return null;
        }
        XMLParser xml = null;
        Vector v = (Vector)this.element;
        for (int i = 0; i < v.size(); ++i) {
            xml = (XMLParser)v.get(i);
            if (xml.findElement(tag) == null || xml.Attribute.find(attname) == null) continue;
            return xml;
        }
        return null;
    }

    public XMLParser getElement(int index) {
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            return null;
        }
        Vector v = (Vector)this.element;
        if (index > v.size()) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return (XMLParser)v.get(index);
    }

    private void setTag(String tag) {
        this.tag = tag;
    }

    private void setValue(String value) throws XMLException {
        if (this.element != null && this.element.getClass() == (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            throw new XMLException("Cannot assign a value to an element with subelements");
        }
        this.element = value;
    }

    public XMLParser addElement(String tag) throws XMLException {
        Vector v = null;
        if (this.element != null && this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            throw new XMLException("Cannot create a subelement to an element with a value");
        }
        if (this.element == null) {
            v = new Vector();
            this.element = v;
        } else {
            v = (Vector)this.element;
        }
        XMLParser xml = new XMLParser(tag);
        v.add(xml);
        return xml;
    }

    public XMLParser addElement(String tag, Object value) throws XMLException {
        Vector v = null;
        if (this.element != null && this.element.getClass() != (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            throw new XMLException("Cannot create a subelement to an element with a value");
        }
        if (this.element == null) {
            v = new Vector();
            this.element = v;
        } else {
            v = (Vector)this.element;
        }
        XMLParser e = new XMLParser(tag);
        e.setValue(value.toString());
        v.add(e);
        return e;
    }

    public void serialize(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
        out.println("<!-- Written by WiSH XML writer -->");
        this.dumpelements("", out);
    }

    private void dumpelements(String indent, PrintWriter out) {
        out.print(indent + "<" + this.tag + this.Attribute.dumpattributes());
        if (this.element == null) {
            out.println("/>");
            return;
        }
        if (this.element.getClass() == (class$java$util$Vector == null ? (class$java$util$Vector = XMLParser.class$("java.util.Vector")) : class$java$util$Vector)) {
            Vector v = (Vector)this.element;
            out.println(">");
            for (int i = 0; i < v.size(); ++i) {
                ((XMLParser)v.get(i)).dumpelements(new String(indent + "  "), out);
            }
            out.println(indent + "</" + this.tag + ">");
        } else {
            out.println(">" + this.getValue() + "</" + this.tag + ">");
        }
    }

    private Object cleanup(Object o) {
        if (o.getClass() == (class$java$lang$String == null ? (class$java$lang$String = XMLParser.class$("java.lang.String")) : class$java$lang$String)) {
            String s = (String)o;
            return s;
        }
        return o;
    }

    public XMLParser(BufferedReader in) throws XMLException, XMLEncodingException, IOException {
        FileReader f = new FileReader(in);
        try {
            this.readXML(this, f);
        }
        catch (XMLEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (XMLException e) {
            throw e;
        }
    }

    private static int popState(Stack st) {
        if (!st.empty()) {
            return (Integer)st.pop();
        }
        return 15;
    }

    private boolean checkforlinefeed(int c) {
        if (c == 10 && this.eol) {
            this.eol = false;
            return true;
        }
        if (this.eol) {
            this.eol = false;
        } else if (c == 10) {
            ++this.line;
            this.col = 0;
        } else if (c == 13) {
            this.eol = true;
            c = 10;
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return false;
    }

    private void readXML(XMLParser xml, FileReader in) throws XMLException, XMLEncodingException, IOException {
        int c;
        int state = 15;
        Stack<Integer> stack = new Stack<Integer>();
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String lvalue = null;
        String rvalue = null;
        int quotec = 34;
        block20: while ((c = in.read()) != -1) {
            if (this.checkforlinefeed(c)) continue;
            switch (state) {
                case 15: {
                    if (c != 60) continue block20;
                    stack.push(new Integer(1));
                    state = 5;
                    continue block20;
                }
                case 5: {
                    state = XMLParser.popState(stack);
                    if (c == 47) {
                        stack.push(new Integer(state));
                        state = 4;
                        continue block20;
                    }
                    if (c == 63) {
                        state = 14;
                        continue block20;
                    }
                    if (xml.getTag() != null) {
                        in.unread(c);
                        in.unread(60);
                        this.readXML(xml.addElement(null), in);
                        state = XMLParser.popState(stack);
                        continue block20;
                    }
                    stack.push(new Integer(state));
                    state = 3;
                    sb.append((char)c);
                    continue block20;
                }
                case 3: {
                    if (c == 62) {
                        if (xml.getTag() == null) {
                            xml.setTag(sb.toString());
                        } else {
                            xml.addElement(sb.toString());
                        }
                        sb.setLength(0);
                        state = XMLParser.popState(stack);
                        continue block20;
                    }
                    if (c == 47) {
                        state = 12;
                        continue block20;
                    }
                    if (c == 45 && sb.toString().equals("!-")) {
                        state = 13;
                        continue block20;
                    }
                    if (c == 91 && sb.toString().equals("![CDATA")) {
                        state = 16;
                        sb.setLength(0);
                        continue block20;
                    }
                    if (c == 69 && sb.toString().equals("!DOCTYP")) {
                        sb.setLength(0);
                        state = 14;
                        continue block20;
                    }
                    if (Character.isWhitespace((char)c)) {
                        xml.setTag(sb.toString());
                        sb.setLength(0);
                        state = 8;
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 1: {
                    if (Character.isWhitespace((char)c) && sb.length() < 1) continue block20;
                    if (c == 60) {
                        stack.push(new Integer(state));
                        state = 5;
                        if (sb.length() <= 0) continue block20;
                        xml.setValue(sb.toString());
                        sb.setLength(0);
                        continue block20;
                    }
                    if (c == 38) {
                        stack.push(new Integer(state));
                        state = 2;
                        etag.setLength(0);
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 4: {
                    if (c == 62) {
                        state = XMLParser.popState(stack);
                        String endTag = sb.toString();
                        if (endTag.compareTo(xml.getTag()) != 0) {
                            throw new XMLEncodingException("Mismatched close tag near line " + this.line + ", column " + this.col);
                        }
                        sb.setLength(0);
                        return;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 8: {
                    if (c == 62) {
                        state = XMLParser.popState(stack);
                        continue block20;
                    }
                    if (c == 47) {
                        state = 12;
                        continue block20;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    state = 6;
                    sb.append((char)c);
                    continue block20;
                }
                case 11: {
                    return;
                }
                case 16: {
                    if (c == 62 && sb.toString().endsWith("]]")) {
                        sb.setLength(sb.length() - 2);
                        xml.setValue(sb.toString());
                        sb.setLength(0);
                        state = XMLParser.popState(stack);
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 13: {
                    if (c == 62 && sb.toString().endsWith("--")) {
                        sb.setLength(0);
                        state = XMLParser.popState(stack);
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 14: {
                    if (c != 62 || (state = XMLParser.popState(stack)) != 1) continue block20;
                    state = 15;
                    continue block20;
                }
                case 2: {
                    if (c == 59) {
                        state = XMLParser.popState(stack);
                        String cent = etag.toString();
                        etag.setLength(0);
                        if (cent.equals("lt")) {
                            sb.append('<');
                            continue block20;
                        }
                        if (cent.equals("gt")) {
                            sb.append('>');
                            continue block20;
                        }
                        if (cent.equals("amp")) {
                            sb.append('&');
                            continue block20;
                        }
                        if (cent.equals("quot")) {
                            sb.append('\"');
                            continue block20;
                        }
                        if (cent.equals("apos")) {
                            sb.append('\'');
                            continue block20;
                        }
                        if (cent.startsWith("#")) {
                            sb.append((char)Integer.parseInt(cent.substring(1)));
                            continue block20;
                        }
                        throw new XMLEncodingException("Unknown entity: &" + cent + "; near line " + this.line + ", column " + this.col);
                    }
                    etag.append((char)c);
                    continue block20;
                }
                case 12: {
                    if (xml.getTag() == null) {
                        xml.setTag(sb.toString());
                        sb.setLength(0);
                    }
                    if (c != 62) {
                        throw new XMLEncodingException("Expected > for tag <" + xml.getTag() + "/> near line " + this.line + ", column " + this.col);
                    }
                    return;
                }
                case 7: {
                    if (c == quotec) {
                        rvalue = sb.toString();
                        sb.setLength(0);
                        xml.Attribute.add(lvalue, rvalue);
                        state = 8;
                        continue block20;
                    }
                    if (" \r\n\t".indexOf(c) >= 0) {
                        sb.append(' ');
                        continue block20;
                    }
                    if (c == 38) {
                        stack.push(new Integer(state));
                        state = 2;
                        etag.setLength(0);
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 10: {
                    if (c == 34 || c == 39) {
                        quotec = c;
                        state = 7;
                        continue block20;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    throw new XMLEncodingException("Error in attribute processing near line " + this.line + ", column " + this.col);
                }
                case 6: {
                    if (Character.isWhitespace((char)c)) {
                        lvalue = sb.toString();
                        sb.setLength(0);
                        state = 9;
                        continue block20;
                    }
                    if (c == 61) {
                        lvalue = sb.toString();
                        sb.setLength(0);
                        state = 10;
                        continue block20;
                    }
                    sb.append((char)c);
                    continue block20;
                }
                case 9: {
                    if (c == 61) {
                        state = 10;
                        continue block20;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    throw new XMLEncodingException("Error in attribute processing near line " + this.line + ", column " + this.col);
                }
            }
            throw new XMLEncodingException("State exception near line " + this.line + ", column " + this.col);
        }
        if (state == 11) {
            return;
        }
        throw new XMLEncodingException("Missing end tag near line " + this.line + ", column " + this.col);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XMLIOException
    extends Exception
    implements Serializable {
        public XMLIOException() {
        }

        public XMLIOException(String s) {
            super(s);
        }
    }

    public static class XMLException
    extends Exception
    implements Serializable {
        public XMLException() {
        }

        public XMLException(String s) {
            super(s);
        }
    }

    public static class XMLEncodingException
    extends Exception
    implements Serializable {
        public XMLEncodingException() {
        }

        public XMLEncodingException(String s) {
            super(s);
        }
    }

    private class FileReader
    implements Serializable {
        Stack stack = new Stack();
        BufferedReader f = null;

        FileReader(BufferedReader in) {
            this.f = in;
        }

        void unread(int c) {
            this.stack.push(new Integer(c));
        }

        int read() throws IOException {
            if (this.stack.empty()) {
                return this.f.read();
            }
            int c = (Integer)this.stack.pop();
            return c;
        }
    }

    public class Attribute {
        public Vector attributes = new Vector();

        public void add(String name, Object value) {
            attribute a = new attribute(name, value.toString());
            this.attributes.add(a);
        }

        private String dumpattributes() {
            String result = new String("");
            for (int i = 0; i < this.attributes.size(); ++i) {
                attribute o = (attribute)this.attributes.get(i);
                result = new String(result + " " + o.name + "=\"" + XMLParser.this.cleanup(o.value) + "\"");
            }
            return result;
        }

        public String find(String name) {
            if (this.attributes.size() == 0) {
                return null;
            }
            for (int i = 0; i < this.attributes.size(); ++i) {
                attribute a = (attribute)this.attributes.get(i);
                if (a.name == null || a.name.compareTo(name) != 0) continue;
                return a.value;
            }
            return null;
        }

        public class attribute {
            public String name = null;
            public String value = null;

            attribute(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

