/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.Debugging;
import javax.media.Player;
import org.bluray.media.StreamNotAvailableException;
import org.bluray.media.SubtitlingControl;
import org.dvb.media.SubtitleListener;

public class SubtitleUtility {
    static /* synthetic */ Class class$org$bluray$media$SubtitlingControl;

    public static void disable(Player player) {
        try {
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            if (sub != null && sub.isSubtitlingOn()) {
                sub.setSubtitling(false);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.disable(): " + e);
        }
    }

    public static void enable(Player player) {
        try {
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            if (sub != null && !sub.isSubtitlingOn()) {
                sub.setSubtitling(true);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.enable(): " + e);
        }
    }

    public static void disable(int subtitle_stream_id, Player player) throws StreamNotAvailableException {
        try {
            SubtitleUtility.disable(player);
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            sub.selectStreamNumber(subtitle_stream_id);
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.disable(): " + e);
        }
    }

    public static void enable(int subtitle_stream_id, Player player) throws StreamNotAvailableException {
        try {
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            if (sub != null) {
                sub.selectStreamNumber(subtitle_stream_id);
                SubtitleUtility.enable(player);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.enable(): " + subtitle_stream_id + " - " + e);
        }
    }

    public static void selectSubtitle(int subtitle_id, Player player) {
        try {
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            sub.selectStreamNumber(subtitle_id);
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.selectSubtitle(): " + e);
        }
    }

    public static void selectDefaultLanguage(Player player) {
        try {
            SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
            sub.selectDefaultLanguage();
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.selectDefaultLanguage(): " + e);
        }
    }

    public static synchronized void enablePiPSubtitles(Player player) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        try {
            sub.setPipSubtitleMode(true);
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.enablePiPSubtitles(): " + e);
        }
    }

    public static void disablePiPSubtitles(Player player) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        try {
            sub.setPipSubtitleMode(false);
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.disablePiPSubtitles(): " + e);
        }
    }

    public static boolean setBDPiPSubtitlingMode(Player player, boolean mode) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        try {
            return sub.setPipSubtitleMode(mode);
        }
        catch (Throwable e) {
            Debugging.dmsg("SubtitleUtility.enablePiPSubs(): " + e);
            return false;
        }
    }

    public static boolean getBDPipSubtitleMode(Player player) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        try {
            return sub.isPipSubtitleMode();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isOn(Player player) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        return sub.isSubtitlingOn();
    }

    public static int getCurrentStream(Player player) {
        SubtitlingControl sub = SubtitleUtility.getSubtitlingControl(player);
        return sub.getCurrentStreamNumber();
    }

    public static void addSubtitlingControlListener(SubtitleListener l, Player player) {
        try {
            SubtitleUtility.removeSubtitlingControlListener(l, player);
            SubtitleUtility.getSubtitlingControl(player).addSubtitleListener(l);
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.addSubtitlingControlListener(): " + e);
        }
    }

    public static void removeSubtitlingControlListener(SubtitleListener l, Player player) {
        try {
            SubtitlingControl sc = SubtitleUtility.getSubtitlingControl(player);
            if (sc != null) {
                sc.removeSubtitleListener(l);
            }
        }
        catch (Exception e) {
            Debugging.dmsg("SubtitleUtility.removeSubtitlingControlListener(): " + e);
        }
    }

    private static SubtitlingControl getSubtitlingControl(Player player) {
        String name = (class$org$bluray$media$SubtitlingControl == null ? (class$org$bluray$media$SubtitlingControl = SubtitleUtility.class$("org.bluray.media.SubtitlingControl")) : class$org$bluray$media$SubtitlingControl).getName();
        return (SubtitlingControl)player.getControl(name);
    }

    public static int getStreamCount(Player player) {
        try {
            SubtitlingControl pac = SubtitleUtility.getSubtitlingControl(player);
            int[] streams = pac.listAvailableStreamNumbers();
            if (streams != null) {
                return streams.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

