/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.Debugging;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;

public class SoundManager {
    private static Time resetTime = new Time(0.0);
    private static Player select = null;
    private static Player activate = null;
    private static Player chime = null;
    public static boolean soundPlayed = false;

    public static void initSounds() {
        block8: {
            try {
                MediaLocator locator = null;
                if (Debugging.getPlaybackEnv() != 0) break block8;
                try {
                    locator = new MediaLocator("bd://SOUND:00");
                    select = Manager.createPlayer((MediaLocator)locator);
                    select.prefetch();
                }
                catch (Exception e) {
                    select = null;
                }
                try {
                    locator = new MediaLocator("bd://SOUND:01");
                    activate = Manager.createPlayer((MediaLocator)locator);
                    activate.prefetch();
                }
                catch (Exception e) {
                    activate = null;
                }
                try {
                    locator = new MediaLocator("bd://SOUND:02");
                    chime = Manager.createPlayer((MediaLocator)locator);
                    chime.prefetch();
                }
                catch (Exception e) {
                    chime = null;
                }
            }
            catch (Throwable e) {
                Debugging.dmsg("SoundManager.initSounds: " + e.toString());
            }
        }
    }

    public static void destroySounds() {
        try {
            select.stop();
            select.close();
            select = null;
            activate.stop();
            activate.close();
            activate = null;
            chime.stop();
            chime.close();
            chime = null;
        }
        catch (Throwable e) {
            Debugging.dmsg("SoundManager.destroySounds: " + e.toString());
        }
    }

    public static void playChime() {
        try {
            if (chime == null) {
                return;
            }
            if (Debugging.getPlaybackEnv() == 0) {
                if (chime.getState() == 600) {
                    chime.stop();
                    chime.setMediaTime(resetTime);
                }
                chime.start();
            }
        }
        catch (Throwable e) {
            Debugging.dmsg("SoundManager.playChime: " + e);
        }
    }

    public static void playSelect() {
        try {
            if (select == null) {
                return;
            }
            if (Debugging.getPlaybackEnv() == 0) {
                if (select.getState() == 600) {
                    select.stop();
                    select.setMediaTime(resetTime);
                }
                select.start();
            }
        }
        catch (Throwable e) {
            Debugging.dmsg("SoundManager.playSelect: " + e);
        }
    }

    public static void playActivate() {
        try {
            if (activate == null) {
                return;
            }
            if (Debugging.getPlaybackEnv() == 0) {
                if (activate.getState() == 600) {
                    activate.stop();
                    activate.setMediaTime(resetTime);
                }
                activate.start();
            }
        }
        catch (Throwable e) {
            Debugging.dmsg("SoundManager.playActivate: " + e);
        }
    }
}

