/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.Debugging;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.havi.ui.HScene;
import org.havi.ui.HSceneFactory;
import org.havi.ui.HSceneTemplate;
import org.havi.ui.HScreenDimension;
import org.havi.ui.HScreenPoint;

public class SceneUtils {
    public static Color transparent = new Color(0, 0, 0, 0);
    private static final long fMinimumMillis = 41L;
    public static long fStartMillis = 0L;
    public static long fEndMillis = 0L;
    private static long fIntervalMillis = 0L;
    private static long fCumIntervals = 0L;
    private static int fIntCounter = 0;

    public static HScene createScene() {
        HSceneFactory factory = HSceneFactory.getInstance();
        HSceneTemplate hst = new HSceneTemplate();
        hst.setPreference(4, (Object)new HScreenDimension(1.0f, 1.0f), 1);
        hst.setPreference(8, (Object)new HScreenPoint(0.0f, 0.0f), 1);
        HScene scene = factory.getBestScene(hst);
        scene.setBounds(0, 0, 1920, 1080);
        scene.setLayout(null);
        return scene;
    }

    public static void resize16x9(HScene scene) {
        scene.setSize(1920, 1080);
    }

    public static void resize4x3(HScene scene) {
        scene.setSize(720, 480);
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        BufferedImage bi = gc.createCompatibleImage(w, h);
        return bi;
    }

    public static Graphics2D createBufferedGraphics(BufferedImage bi) {
        Graphics2D bg = bi.createGraphics();
        bg.setComposite(AlphaComposite.Src);
        return bg;
    }

    public static void clearBuffer(BufferedImage bi) {
        SceneUtils.clearBuffer(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
    }

    public static void clearBuffer(BufferedImage bi, Rectangle r) {
        SceneUtils.clearBuffer(bi, r.x, r.y, r.width, r.height);
    }

    public static Graphics2D clearBuffer(BufferedImage bi, int x, int y, int w, int h) {
        Graphics2D bg = (Graphics2D)bi.getGraphics();
        bg.setComposite(AlphaComposite.Src);
        bg.setColor(transparent);
        bg.fillRect(x, y, w, h);
        bg.setComposite(AlphaComposite.SrcOver);
        return bg;
    }

    public static void startFrame() {
        fStartMillis = System.currentTimeMillis();
    }

    public static long endFrame() {
        return SceneUtils.endFrame(41L);
    }

    public static long endFrame(long l) {
        fEndMillis = System.currentTimeMillis();
        long l1 = fEndMillis - fStartMillis;
        fIntervalMillis = (fCumIntervals += l1) / (long)(++fIntCounter);
        Debugging.dmsg("fIntervalMillis: " + fIntervalMillis);
        return fIntervalMillis;
    }

    public static long getCurrentSpeed() {
        return fIntervalMillis;
    }

    public static long getMinimumSpeed() {
        return 41L;
    }
}

