/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import com.zoo.util.ImageMap;
import com.zoo.util.ImageUtils;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;

public class ResourceManager
extends Component {
    private static final long serialVersionUID = 0L;
    private static String langcode = "eng";
    private static String fileroot = BDProperties.getVFSRoot() + "/BDMV/JAR/22222/";
    private ArrayList mosaicList = new ArrayList();
    private ArrayList coordsList = new ArrayList();
    public ArrayList imagemaps;

    public boolean setLangCode(String lang) {
        if (lang.length() != 3) {
            return false;
        }
        langcode = lang;
        return true;
    }

    public String getLangCode() {
        return langcode;
    }

    public boolean unloadResources() {
        try {
            for (int i = 0; i < this.mosaicList.size(); ++i) {
                Image currMosaic = (Image)this.mosaicList.get(i);
                String[] currCoords = (String[])this.coordsList.get(i);
                if (currMosaic != null) {
                    ImageUtils.unloadImage(this, currMosaic);
                    currMosaic = null;
                }
                if (currCoords == null) continue;
                Object var3_4 = null;
            }
            this.mosaicList = new ArrayList();
            this.coordsList = new ArrayList();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Image loadBitmap(String s) {
        return ImageUtils.loadImage(this, fileroot + s);
    }

    public String[] loadCoordinates(String s) {
        return FileUtils.tokenizeString(FileUtils.readFromFile(fileroot + s), ";");
    }

    public boolean loadImageResources(String[] im, String[] ic) {
        try {
            this.unloadResources();
            this.imagemaps = new ArrayList();
            for (int i = 0; i < im.length; ++i) {
                this.mosaicList.add(this.loadBitmap(im[i]));
                this.coordsList.add(this.loadCoordinates(ic[i]));
                Image currMosaic = (Image)this.mosaicList.get(i);
                String[] currCoords = (String[])this.coordsList.get(i);
                for (int j = 0; j < currCoords.length; ++j) {
                    String[] s = FileUtils.tokenizeString(currCoords[j], ",");
                    String[] c = new String[]{currCoords[j]};
                    this.imagemaps.add(ImageUtils.cropImage(currMosaic, c, s[0]));
                }
                Debugging.dmsg("mosaicList: " + this.mosaicList.size());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ImageMap getImageMap(String s) {
        for (int i = 0; i < this.imagemaps.size(); ++i) {
            if (!s.equals(((ImageMap)this.imagemaps.get((int)i)).key)) continue;
            return (ImageMap)this.imagemaps.get(i);
        }
        return null;
    }

    public void printResources() {
        for (int i = 0; i < this.imagemaps.size(); ++i) {
            System.out.println(((ImageMap)this.imagemaps.get(i)).toString());
        }
    }

    public static void setFileRoot(String s) {
        fileroot = s;
    }

    public static String getFileRoot() {
        return fileroot;
    }

    public int[] getImageDim(String s) {
        int[] imageInfo = new int[2];
        try {
            for (int i = 0; i < this.imagemaps.size(); ++i) {
                if (!s.equals(((ImageMap)this.imagemaps.get((int)i)).key)) continue;
                imageInfo[0] = ((ImageMap)this.imagemaps.get((int)i)).w;
                imageInfo[1] = ((ImageMap)this.imagemaps.get((int)i)).h;
            }
        }
        catch (Exception e) {
            Debugging.dmsg("Could not getImageDim: " + e);
        }
        return imageInfo;
    }
}

