/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import java.io.IOException;
import javax.media.Control;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import javax.tv.service.selection.ServiceContextException;
import org.bluray.media.PlayListChangeControl;
import org.bluray.net.BDLocator;

public class PlaylistUtility {
    public static boolean setPlaylist(String locator, Player player) {
        try {
            PlayListChangeControl plc = PlaylistUtility.getPlayListChangeControl(player);
            if (player.getState() == 600) {
                player.stop();
            }
            plc.selectPlayList(new BDLocator(locator));
            player.setMediaTime(new Time(0L));
            player.start();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean setPlaylist(BDLocator locator, Player player) {
        try {
            PlayListChangeControl plc = PlaylistUtility.getPlayListChangeControl(player);
            if (player.getState() == 600) {
                player.stop();
            }
            plc.selectPlayList(locator);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean setPlaylist(String locator, Player player, double savedTime) {
        try {
            PlayListChangeControl plc = PlaylistUtility.getPlayListChangeControl(player);
            if (plc == null) {
                return false;
            }
            if (player.getState() == 600) {
                player.stop();
            }
            plc.selectPlayList(new BDLocator(locator));
            if (savedTime > 0.0) {
                if (player.getState() < 500) {
                    player.prefetch();
                }
                player.setMediaTime(new Time(savedTime));
                player.start();
            } else {
                player.start();
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean setPlaylist(BDLocator locator, Player player, double savedTime) {
        try {
            PlayListChangeControl plc = PlaylistUtility.getPlayListChangeControl(player);
            if (plc == null) {
                return false;
            }
            if (player.getState() == 600) {
                player.stop();
            }
            plc.selectPlayList(locator);
            if (savedTime > 0.0) {
                if (player.getState() < 500) {
                    player.prefetch();
                }
                player.setMediaTime(new Time(savedTime));
                player.start();
            } else {
                player.start();
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static PlayListChangeControl getPlayListChangeControl(Player player) throws NoPlayerException, SecurityException, IOException, ServiceContextException {
        Control[] controls = player.getControls();
        for (int i = 0; i < controls.length; ++i) {
            if (!(controls[i] instanceof PlayListChangeControl)) continue;
            return (PlayListChangeControl)controls[i];
        }
        return null;
    }
}

