/*
 * Decompiled with CFR 0.152.
 */
package com.zoo.util;

import com.zoo.util.BDProperties;
import com.zoo.util.Debugging;
import com.zoo.util.FileUtils;
import java.io.File;
import org.bluray.system.RegisterAccess;

public class PersistentSettings {
    private static final int FIRST_RUN_GPR = 4000;
    private static final int FIRST_PERSIST_GPR = 4001;
    private static final int MAX_PERSIST_GPRS = 65;
    private static final boolean FASTPLAY = true;
    private static String[] m_setting;
    private static String m_settingsFile;
    private static boolean m_firstRun;
    public static final int SETTING_LANGUAGE = 0;
    public static final int SETTING_RESUMEVALID = 1;
    public static final int SETTING_RESUMETIME = 2;
    public static final int SETTING_RESUMEPLAYLIST = 3;
    public static final int SETTING_RESUMEPLAYMARK = 4;
    public static final int SETTING_AUDIOSELECTID = 5;
    public static final int SETTING_AUDIOSTREAMID = 6;
    public static final int SETTING_AUDIOSTREAMINDEX = 7;
    public static final int SETTING_SUBTITLESELECTID = 8;
    public static final int SETTING_SUBTITLESTREAMID = 9;
    public static final int SETTING_SUBTITLESTREAMINDEX = 10;
    public static final int SETTING_SUBTITLESTREAMENABLED = 11;
    public static final int SETTING_PLAYONCESTATUS = 12;
    public static final int SETTING_FIRSTPLAY = 13;
    public static final int SETTING_COMMENTARYSTATE = 14;
    public static final int SETTING_COMMENTARYAUDIOSTREAM = 15;
    public static final int SETTING_COMMENTARYSTATE_SUBSURFED = 16;
    public static final int SETTINGS = 17;

    public static void Initialise(String org_id, String app_id) {
        m_settingsFile = BDProperties.getPersistentRoot() + File.separator + org_id + File.separator + app_id + File.separator + "globalsettings.txt";
        m_setting = new String[17];
        for (int i = 0; i < 17; ++i) {
            PersistentSettings.m_setting[i] = "";
        }
    }

    public static void setString(int setting, String data) {
        PersistentSettings.m_setting[setting] = data;
    }

    public static void setInt(int setting, int data) {
        PersistentSettings.m_setting[setting] = Integer.toString(data);
    }

    public static void setLong(int setting, long data) {
        PersistentSettings.m_setting[setting] = Long.toString(data);
    }

    public static void setDouble(int setting, double data) {
        PersistentSettings.m_setting[setting] = Double.toString(data);
    }

    public static void setBoolean(int setting, boolean data) {
        PersistentSettings.m_setting[setting] = data ? "1" : "0";
    }

    public static String getString(int setting) {
        return m_setting[setting];
    }

    public static int getInt(int setting) {
        if (m_setting[setting].equals("")) {
            return 0;
        }
        return Integer.parseInt(m_setting[setting]);
    }

    public static long getLong(int setting) {
        if (m_setting[setting].equals("")) {
            return 0L;
        }
        return Long.parseLong(m_setting[setting]);
    }

    public static double getDouble(int setting) {
        if (m_setting[setting].equals("")) {
            return 0.0;
        }
        return Double.parseDouble(m_setting[setting]);
    }

    public static boolean getBoolean(int setting) {
        return m_setting[setting].equals("1");
    }

    public static void writeSettings() {
        if (Debugging.getPlaybackEnv() != 0) {
            return;
        }
        Debugging.dmsg("ESS - Writing persistent settings");
        for (int i = 0; i < m_setting.length; ++i) {
            Debugging.dmsg("ESS -   " + i + ": " + m_setting[i]);
        }
        String concat = "";
        for (int i = 0; i < m_setting.length; ++i) {
            concat = concat + i + ":" + m_setting[i];
            if (i == m_setting.length - 1) continue;
            concat = concat + "|";
        }
        FileUtils.DeleteFile(m_settingsFile);
        boolean OK = FileUtils.writeToFile(m_settingsFile, concat, false);
        if (!OK) {
            FileUtils.DeleteFile(m_settingsFile);
        }
        int maxStringLength = 256;
        if (concat.length() < maxStringLength) {
            RegisterAccess.getInstance().setGPR(4001, concat.length());
            for (int i = 0; i < concat.length(); i += 4) {
                String sub = concat.substring(i, Math.min(i + 4, concat.length()));
                int val = 0;
                for (int j = 0; j < sub.length(); ++j) {
                    val *= 256;
                    int c = sub.charAt(j) & 0xFF;
                    val += c;
                }
                RegisterAccess.getInstance().setGPR(4002 + i / 4, val);
            }
        } else {
            RegisterAccess.getInstance().setGPR(4001, 0);
            Debugging.dmsg("ESS - String too long to write persistent data in GPRs. Max Length = " + maxStringLength + "  required length = " + concat.length());
        }
    }

    private static void readSettings() {
        int i;
        if (Debugging.getPlaybackEnv() != 0) {
            return;
        }
        boolean persistentData = false;
        boolean GPRdata = false;
        boolean clearPersistent = false;
        for (int i2 = 0; i2 < m_setting.length; ++i2) {
            PersistentSettings.m_setting[i2] = "";
        }
        String result = FileUtils.readFromFile(m_settingsFile);
        if (!result.equals("")) {
            persistentData = true;
        }
        if (!persistentData) {
            FileUtils.DeleteFile(m_settingsFile);
            int maxStringLength = 256;
            int length = RegisterAccess.getInstance().getGPR(4001);
            if (length < 0 || length > maxStringLength) {
                throw new RuntimeException("Failed to read string");
            }
            result = "";
            for (i = 0; i < length; i += 4) {
                int digits = Math.min(i + 4, length) - i;
                int composite = RegisterAccess.getInstance().getGPR(4002 + i / 4);
                for (int d = 0; d < digits; ++d) {
                    int c = composite >> (digits - d - 1) * 8 & 0xFF;
                    result = result + new Character((char)c).toString();
                }
            }
            if (!result.equals("")) {
                GPRdata = true;
            }
        }
        if (!result.equals("")) {
            if (persistentData) {
                Debugging.dmsg("ESS - Loading persistent data from file");
            } else {
                Debugging.dmsg("ESS - Loading persistent data from GPRs");
            }
            String[] settings = FileUtils.tokenizeString(result, "|");
            for (int i3 = 0; i3 < settings.length; ++i3) {
                int key;
                String[] splt = FileUtils.tokenizeString(settings[i3], ":");
                if (splt.length != 2 || (key = Integer.valueOf(splt[0]).intValue()) < 0 || key >= 17) continue;
                PersistentSettings.m_setting[key] = splt[1];
            }
            if (settings.length != 17) {
                Debugging.dmsg("ESS - Persistent data is invalid!!!");
                clearPersistent = true;
            } else {
                Debugging.dmsg("ESS - Persistent data is valid");
            }
        } else {
            if (!persistentData && !GPRdata) {
                Debugging.dmsg("ESS - FIRST RUN - no persistent data");
            } else {
                Debugging.dmsg("ESS - Persistent data is invalid!!!");
            }
            clearPersistent = true;
        }
        int firstRun = RegisterAccess.getInstance().getGPR(4000);
        boolean firstRunSetting = PersistentSettings.getBoolean(13);
        RegisterAccess.getInstance().setGPR(4000, 0);
        PersistentSettings.setBoolean(13, false);
        Debugging.dmsg("ESS - FIRSTRUNGPR=" + firstRun + "  SETTINGFIRSTPLAY=" + (firstRunSetting ? "true" : "false"));
        if (firstRun != 0 || firstRunSetting || clearPersistent) {
            Debugging.dmsg("ESS - First Run. Wiping persistent data");
            for (i = 0; i < 17; ++i) {
                if (i == 0) continue;
                PersistentSettings.setString(i, "");
            }
            m_firstRun = true;
        } else {
            Debugging.dmsg("ESS - Reloading");
            m_firstRun = false;
        }
    }

    public static boolean isFirstRun() {
        return m_firstRun;
    }

    public static void setFirstRun(boolean value) {
        m_firstRun = value;
    }

    static {
        m_firstRun = false;
    }
}

